/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Objects;
import org.simantics.acorn.AcornKey;
import org.simantics.acorn.FileIO;
import org.simantics.acorn.FileStore;
import org.simantics.db.IO;

public class AcornKeyFile
implements AcornKey {
    private FileStore store;
    private AcornKeyFile parent;
    private String name;

    public AcornKeyFile(FileStore store, AcornKeyFile parent, String name) {
        this.store = store;
        this.parent = parent;
        this.name = name;
    }

    @Override
    public IO getIO() {
        return new FileIO(this.path());
    }

    public Path path() {
        if (this.parent == null) {
            return this.store.root().resolve(this.name);
        }
        Path parentPath = this.parent.path();
        return parentPath.resolve(this.name);
    }

    @Override
    public boolean exists() {
        return Files.exists(this.path(), new LinkOption[0]);
    }

    @Override
    public byte[] bytes() throws IOException {
        return Files.readAllBytes(this.path());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String debugLocation() {
        return this.path().toAbsolutePath().toString();
    }

    @Override
    public AcornKey child(String name) {
        return new AcornKeyFile(this.store, this, name);
    }

    @Override
    public void ensureExists() throws IOException {
        Files.createDirectories(this.path(), new FileAttribute[0]);
    }

    @Override
    public boolean sameName(String n) {
        return this.name.equals(n);
    }

    @Override
    public void deleteIfExists() throws IOException {
        Files.deleteIfExists(this.path());
    }

    @Override
    public int countChildren() throws IOException {
        Path directory = this.path();
        Throwable throwable = null;
        Object var3_4 = null;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(directory);){
            int count = 0;
            Iterator<Path> iterator = ds.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
            return count;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void sync() throws IOException {
        FileIO.syncPath(this.path());
    }

    @Override
    public void syncChildren() throws IOException {
        Files.walk(this.path(), 1, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(FileIO::uncheckedSyncPath);
    }

    public OutputStream newOutputStream() throws IOException {
        return Files.newOutputStream(this.path(), new OpenOption[0]);
    }

    @Override
    public void copyTo(AcornKey to) throws IOException {
        Files.copy(this.path(), ((AcornKeyFile)to).path(), StandardCopyOption.COPY_ATTRIBUTES);
    }

    @Override
    public void deleteAll() throws IOException {
        Files.walkFileTree(this.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent, this.store);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AcornKeyFile other = (AcornKeyFile)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.parent, other.parent) && Objects.equals(this.store, other.store);
    }
}

