/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.variables;

import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.DefinedUCInterfaceMap;
import org.simantics.structural2.Functions;
import org.simantics.structural2.utils.StructuralUtils;
import org.simantics.structural2.variables.AbstractVariableConnectionPointDescriptor;
import org.simantics.structural2.variables.ConnectionBrowser;
import org.simantics.structural2.variables.IsLeafType;

class ActualConnectionDescriptor
extends AbstractVariableConnectionPointDescriptor {
    final Variable root;
    final Resource component;
    final Resource componentType;
    final Resource cp;

    public ActualConnectionDescriptor(Variable root, Resource component, Resource componentType, Resource cp) {
        assert (root != null);
        assert (component != null);
        assert (componentType != null);
        assert (cp != null);
        this.root = root;
        this.component = component;
        this.componentType = componentType;
        this.cp = cp;
    }

    @Override
    public boolean isLeaf(ReadGraph graph) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource type = graph.getPossibleType(this.component, STR.Component);
        return type != null ? (Boolean)graph.syncRequest((Read)new IsLeafType(type)) : false;
    }

    @Override
    public Collection<Functions.InterfaceResolution> getInterfaceDescription(ReadGraph graph) throws DatabaseException {
        return (Collection)graph.syncRequest((Read)new ActualConnectionDescriptorInterfaceDescription(this), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    @Override
    public Resource getConnectionPointResource(ReadGraph graph) throws DatabaseException {
        return this.cp;
    }

    @Override
    public Variable getVariable(ReadGraph graph) throws DatabaseException {
        return (Variable)graph.syncRequest((Read)new ComputeVariable(this), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    @Override
    public String getURI(ReadGraph graph) throws DatabaseException {
        Variable var = this.getVariable(graph);
        return var.getURI(graph);
    }

    @Override
    public boolean isFlattenedFrom(ReadGraph graph, Variable possiblyStructuralCp) throws DatabaseException {
        Resource otherCp = possiblyStructuralCp.getPossiblePredicateResource(graph);
        if (!this.cp.equals(otherCp)) {
            return false;
        }
        Variable otherComponentVariable = possiblyStructuralCp.getParent(graph);
        Resource otherComponent = otherComponentVariable.getPossibleRepresents(graph);
        if (!this.component.equals(otherComponent)) {
            return false;
        }
        Variable otherContainer = otherComponentVariable.getParent(graph);
        if (otherContainer.equals(this.root)) {
            return true;
        }
        return this.getVariable(graph).equals(possiblyStructuralCp);
    }

    @Override
    public String getRelativeRVI(ReadGraph graph, Variable base) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String cpName = (String)graph.getRelatedValue(this.cp, L0.HasName, (Binding)Bindings.STRING);
        if (cpName.startsWith("/")) {
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            if (graph.isInstanceOf(this.component, MOD.ReferenceElement)) {
                return "#" + cpName;
            }
        }
        if (this.root.equals(base.getParent(graph))) {
            StringBuilder b = new StringBuilder();
            b.append("./");
            String cName = (String)graph.getRelatedValue(this.component, L0.HasName, (Binding)Bindings.STRING);
            b.append(URIStringUtils.escape((String)cName));
            b.append("#");
            b.append(cpName);
            return b.toString();
        }
        return super.getRelativeRVI(graph, base);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.component.hashCode();
        result = 31 * result + this.componentType.hashCode();
        result = 31 * result + this.cp.hashCode();
        result = 31 * result + this.root.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActualConnectionDescriptor other = (ActualConnectionDescriptor)obj;
        if (!this.component.equals(other.component)) {
            return false;
        }
        if (!this.componentType.equals(other.componentType)) {
            return false;
        }
        if (!this.cp.equals(other.cp)) {
            return false;
        }
        return this.root.equals(other.root);
    }

    public String toString() {
        return "ActualConnectionDescriptor [root=" + String.valueOf(this.root) + ", component=" + String.valueOf(this.component) + ", componentType=" + String.valueOf(this.componentType) + ", cp=" + String.valueOf(this.cp) + "]";
    }

    static class ActualConnectionDescriptorInterfaceDescription
    extends UnaryRead<ActualConnectionDescriptor, Collection<Functions.InterfaceResolution>> {
        public ActualConnectionDescriptorInterfaceDescription(ActualConnectionDescriptor desc) {
            super((Object)desc);
        }

        public Collection<Functions.InterfaceResolution> perform(ReadGraph graph) throws DatabaseException {
            StructuralUtils.StructuralComponentClass clazz = StructuralUtils.StructuralComponentClass.get(graph, ((ActualConnectionDescriptor)this.parameter).componentType);
            if (StructuralUtils.StructuralComponentClass.PRIMITIVE.equals((Object)clazz)) {
                return null;
            }
            if (StructuralUtils.StructuralComponentClass.DEFINED.equals((Object)clazz)) {
                Collection interfaces = (Collection)graph.syncRequest((Read)new DefinedUCInterfaceMap(((ActualConnectionDescriptor)this.parameter).componentType));
                if (interfaces != null) {
                    return interfaces;
                }
                return Functions.BUILTIN_STRUCTURAL_CPS;
            }
            if (StructuralUtils.StructuralComponentClass.REPLACEABLE.equals((Object)clazz)) {
                throw new DatabaseException("ConnectionBrowser does not support nested replaceable defined structural types.");
            }
            return Functions.computeInterfacePaths(graph, ((ActualConnectionDescriptor)this.parameter).getVariable(graph).getParent(graph));
        }
    }

    static class ComputeVariable
    extends UnaryRead<ActualConnectionDescriptor, Variable> {
        public ComputeVariable(ActualConnectionDescriptor desc) {
            super((Object)desc);
        }

        public Variable perform(ReadGraph graph) throws DatabaseException {
            Variable cnp;
            Variable c = ConnectionBrowser.resolve(graph, ((ActualConnectionDescriptor)this.parameter).root, ((ActualConnectionDescriptor)this.parameter).component);
            if (c != null && (cnp = c.getPossibleProperty(graph, ((ActualConnectionDescriptor)this.parameter).cp)) != null) {
                return cnp;
            }
            throw new DatabaseException("Unresolved connection point (root=" + ((ActualConnectionDescriptor)this.parameter).root.getURI(graph) + ", component=" + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)((ActualConnectionDescriptor)this.parameter).component) + ", cp=" + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)((ActualConnectionDescriptor)this.parameter).cp) + ")");
        }
    }
}

