/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.ResourceToURI;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Valuations;
import org.simantics.db.request.Read;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.Pair;

public class DefaultValuations
implements Valuations {
    private final Resource resource;

    public DefaultValuations(Resource module) {
        this.resource = module;
    }

    public static Pair<String, String> splitModelAndStructure(ReadGraph graph, String path, int startPosition) throws DatabaseException {
        int position = path.indexOf("/", startPosition);
        String prefix = path.substring(0, position);
        Resource r = graph.getResource(prefix);
        if (graph.isInstanceOf(r, SimulationResource.getInstance((ReadGraph)graph).Model)) {
            return new Pair((Object)path.substring(0, position), (Object)path.substring(position + 1, path.length()));
        }
        return DefaultValuations.splitModelAndStructure(graph, path, position + 1);
    }

    public static Pair<String, String> splitModelAndStructure(ReadGraph graph, String path) throws DatabaseException {
        Resource r = graph.getResource(path);
        if (graph.isInstanceOf(r, SimulationResource.getInstance((ReadGraph)graph).Model)) {
            return new Pair((Object)path, (Object)"");
        }
        return DefaultValuations.splitModelAndStructure(graph, path, 8);
    }

    @Override
    public Resource getValue(ReadGraph graph, String variableIdentityPrefix, String experiment) throws DatabaseException {
        String path = (String)graph.syncRequest((Read)new ResourceToURI(this.resource));
        Pair<String, String> modelAndStructure = DefaultValuations.splitModelAndStructure(graph, path);
        try {
            return graph.getResource((String)modelAndStructure.first + "/" + experiment + "/" + (String)modelAndStructure.second);
        }
        catch (DatabaseException databaseException) {
            try {
                return graph.getResource((String)modelAndStructure.first + "/BaseRealization/" + (String)modelAndStructure.second);
            }
            catch (DatabaseException databaseException2) {
                return null;
            }
        }
    }

    @Override
    public Resource getValue(ReadGraph graph, String variableIdentityPrefix, String experiment, String suffix) throws DatabaseException {
        String path = (String)graph.syncRequest((Read)new ResourceToURI(this.resource));
        Pair<String, String> modelAndStructure = DefaultValuations.splitModelAndStructure(graph, path);
        String prefix = ((String)modelAndStructure.second).isEmpty() ? "" : "/" + (String)modelAndStructure.second;
        String uri = (String)modelAndStructure.first + "/" + experiment + prefix + (String)(suffix.isEmpty() ? "" : "/" + suffix);
        return graph.getResource(uri);
    }
}

