/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.ArrayList;
import org.simantics.charts.query.AddChartItem;
import org.simantics.charts.query.ChartItemDescriptor;
import org.simantics.charts.ui.NewChart;
import org.simantics.charts.ui.NewChartGroup;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.subscription.SCLSubscription;

public class SCLChart {
    public static Resource createNewChart(Resource targetModel) throws DatabaseException {
        return NewChart.createChart(targetModel);
    }

    public static Resource createNewChart(Resource targetModel, String chartNameProposal) throws DatabaseException {
        return NewChart.createChart(targetModel, chartNameProposal);
    }

    public static Resource createNewChartGroup(Resource targetModel) throws DatabaseException {
        return NewChartGroup.createChartGroup(targetModel);
    }

    public static Resource createNewChartGroup(Resource targetModel, String chartGroupNameProposal) throws DatabaseException {
        return NewChartGroup.createChartGroup(targetModel, chartGroupNameProposal);
    }

    public static Resource addChartItems(WriteGraph graph, Resource chart, Variable variable) throws DatabaseException {
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)variable);
        Resource defaultSubscriptionResource = SCLSubscription.defaultSubscriptionFolder((ReadGraph)graph, (Resource)model);
        Resource subscriptionItem = SCLSubscription.addSubscriptionItems((WriteGraph)graph, (Resource)defaultSubscriptionResource, (Variable)variable);
        ArrayList<ChartItemDescriptor> refs = new ArrayList<ChartItemDescriptor>(1);
        refs.add(AddChartItem.createDescriptor((ReadGraph)graph, subscriptionItem));
        AddChartItem ci = new AddChartItem(chart, refs);
        ci.perform(graph);
        return ci.chartItem;
    }

    public static Resource linkSubToChart(WriteGraph graph, Resource subscriptionItem, Resource chart) throws DatabaseException {
        ArrayList<ChartItemDescriptor> refs = new ArrayList<ChartItemDescriptor>(1);
        refs.add(AddChartItem.createDescriptor((ReadGraph)graph, subscriptionItem));
        AddChartItem ci = new AddChartItem(chart, refs);
        ci.perform(graph);
        return ci.chartItem;
    }
}

