/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Literals;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.layer0.Layer0;

public class DatabaseUtils {
    public static String getReadableName(ReadGraph graph, Resource resource) throws ValidationException, ServiceException {
        StringBuilder bb;
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        String uri = graph.getPossibleURI(resource);
        if (uri != null) {
            return uri;
        }
        ArrayList<String> names = new ArrayList<String>(1);
        for (Resource nameResource : graph.getObjects(resource, b.HasName)) {
            Object value = graph.getPossibleValue(nameResource);
            if (value == null) continue;
            names.add(Literals.shortString((Object)Literals.literalToString((Object)value)));
        }
        if (!names.isEmpty()) {
            if (names.size() == 1) {
                return (String)names.get(0);
            }
            bb = new StringBuilder();
            bb.append('[');
            int i = 0;
            while (i < names.size()) {
                if (i > 0) {
                    bb.append(", ");
                }
                bb.append((String)names.get(i));
                ++i;
            }
            bb.append(']');
            return bb.toString();
        }
        bb = new StringBuilder();
        Object val = graph.getPossibleValue(resource);
        if (val != null) {
            if (val instanceof double[]) {
                bb.append(Literals.shortString((Object)Arrays.toString((double[])val)));
            } else if (val instanceof float[]) {
                bb.append(Literals.shortString((Object)Arrays.toString((float[])val)));
            } else if (val instanceof int[]) {
                bb.append(Literals.shortString((Object)Arrays.toString((int[])val)));
            } else if (val instanceof boolean[]) {
                bb.append(Literals.shortString((Object)Arrays.toString((boolean[])val)));
            } else if (val instanceof long[]) {
                bb.append(Literals.shortString((Object)Arrays.toString((long[])val)));
            } else if (val instanceof byte[]) {
                bb.append(Literals.shortString((Object)Arrays.toString((byte[])val)));
            } else if (val instanceof String[]) {
                bb.append(Literals.shortString((Object)Arrays.toString((String[])val)));
            } else {
                bb.append(Literals.shortString((Object)val));
            }
        } else {
            bb.append(resource.getResourceId());
        }
        boolean ok = false;
        for (Resource r : graph.getObjects(resource, b.InstanceOf)) {
            bb.append(" : (" + DatabaseUtils.getReadableName(graph, r) + ")");
            ok = true;
        }
        if (!ok) {
            for (Resource r : graph.getObjects(resource, b.Inherits)) {
                bb.append(" <T (" + DatabaseUtils.getReadableName(graph, r) + ")");
                ok = true;
            }
            if (!ok) {
                for (Resource r : graph.getObjects(resource, b.SubrelationOf)) {
                    bb.append(" <R (" + DatabaseUtils.getReadableName(graph, r) + ")");
                    ok = true;
                }
            }
        }
        return bb.toString();
    }
}

