/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.units.internal.deprecated;

public enum Magnitude {
    yotta("Y", 24, "yotta"),
    zetta("Z", 21, "zetta"),
    exa("E", 18, "exa"),
    peta("P", 15, "peta"),
    tera("T", 12, "tera"),
    giga("G", 9, "giga"),
    mega("M", 6, "mega"),
    kilo("k", 3, "kilo"),
    hecto("h", 2, "hecto"),
    deca("da", 1, "deca"),
    unscaled("", 0, ""),
    deci("d", -1, "deci"),
    centi("c", -2, "centi"),
    milli("m", -3, "milli"),
    micro("\ufffd", -6, "micro"),
    nano("n", -9, "nano"),
    pico("p", -12, "pico"),
    femto("f", -15, "femto"),
    atto("a", -18, "atto"),
    zepto("z", -21, "zepto"),
    yocto("y", -24, "yocto");

    String symbol;
    int exp;
    String name;

    private Magnitude(String symbol, int exp, String prefix) {
        this.symbol = symbol;
        this.exp = exp;
        this.name = prefix;
    }

    public String getPrefix() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int getExponent() {
        return this.exp;
    }

    public static Magnitude getSuitable(double value) {
        double exp = Math.log10(value);
        Magnitude[] magnitudeArray = Magnitude.values();
        int n = magnitudeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Magnitude m = magnitudeArray[n2];
            if (!m.equals((Object)hecto) && !m.equals((Object)deca) && (double)m.exp < exp) {
                return m;
            }
            ++n2;
        }
        return yotta;
    }
}

