/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.RandomAccess;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.file.IFileList;
import org.simantics.databoard.file.RandomAccessBinaryList;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.serialization.SerializerScheme;
import org.simantics.databoard.util.binary.BinaryFile;

public class FileList<T>
extends RandomAccessBinaryList<T>
implements IFileList<T>,
RandomAccess {
    File f;
    RandomAccessFile raf;

    public FileList(File file) throws IOException, BindingConstructionException, SerializerConstructionException, SerializationException {
        this(file, (Binding)Bindings.getBinding(Object.class), 0L, Bindings.serializationFactory);
    }

    public FileList(File file, Class<T> clazz) throws IOException, BindingConstructionException, SerializerConstructionException, SerializationException {
        this(file, (Binding)Bindings.getBinding(clazz), 0L, Bindings.serializationFactory);
    }

    public FileList(String file, Class<T> clazz) throws IOException, BindingConstructionException, SerializerConstructionException, SerializationException {
        this(new File(file), (Binding)Bindings.getBinding(clazz), 0L, Bindings.serializationFactory);
    }

    public FileList(String file, Binding binding) throws IOException, SerializerConstructionException, SerializationException {
        this(new File(file), binding, 0L, Bindings.serializationFactory);
    }

    public FileList(File file, Binding binding) throws IOException, SerializerConstructionException, SerializationException {
        this(file, binding, 0L, Bindings.serializationFactory);
    }

    public FileList(File file, Class<T> clazz, long startPos) throws IOException, BindingConstructionException, SerializerConstructionException, SerializationException {
        this(file, (Binding)Bindings.getBinding(clazz), startPos, Bindings.serializationFactory);
    }

    public FileList(File file, Binding binding, long startPos) throws IOException, SerializationException, SerializerConstructionException {
        super(new BinaryFile(new RandomAccessFile(file, "rw")), binding, startPos, Bindings.serializationFactory);
        this.f = file;
        this.raf = ((BinaryFile)this.blob).getRandomAccessFile();
    }

    public FileList(File file, Binding binding, long startPos, SerializerScheme format) throws IOException, SerializerConstructionException, SerializationException {
        super(new BinaryFile(new RandomAccessFile(file, "rw")), binding, startPos, format);
        this.f = file;
        this.raf = ((BinaryFile)this.blob).getRandomAccessFile();
    }

    @Override
    public void close() {
        super.close();
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public File getFile() {
        return this.f;
    }
}

