/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.binding.impl.DoubleBindingDefault;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.IdentityPair;

public final class DoubleArrayBinding
extends ArrayBinding {
    public static DoubleArrayBinding createFrom(ArrayType type) {
        return new DoubleArrayBinding(type, new DoubleBindingDefault((DoubleType)type.componentType));
    }

    public DoubleArrayBinding(ArrayType type, Binding componentBinding) {
        super(type, componentBinding);
    }

    @Override
    public Object create() {
        return new double[0];
    }

    @Override
    public Object create(int length, Iterator<Object> values) {
        double[] array = new double[length];
        int i = 0;
        while (i < length) {
            array[i] = (Double)values.next();
            ++i;
        }
        return array;
    }

    @Override
    public Object create(Object[] values) {
        double[] result = new double[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = (Double)values[i];
            ++i;
        }
        return result;
    }

    @Override
    public Object createDefault() throws BindingException {
        NumberType nt = (NumberType)this.type().componentType;
        if (nt.getRange() == null) {
            return new double[this.type().minLength()];
        }
        return super.createDefault();
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        ArrayBinding sb = (ArrayBinding)srcBinding;
        DoubleBinding scb = (DoubleBinding)sb.getComponentBinding();
        double[] d = (double[])dst;
        if (d.length != sb.size(src)) {
            throw new BindingException("double[] is length immutable");
        }
        int i = 0;
        while (i < d.length) {
            d[i] = scb.getValue_(sb.get(src, i));
            ++i;
        }
    }

    @Override
    public Object readFromTry(Binding srcBinding, Object src, Object dst) throws BindingException {
        ArrayBinding sb = (ArrayBinding)srcBinding;
        DoubleBinding scb = (DoubleBinding)sb.getComponentBinding();
        double[] d = (double[])dst;
        int srcSize = sb.size(src);
        if (d.length != srcSize) {
            d = new double[srcSize];
        }
        int i = 0;
        while (i < d.length) {
            d[i] = scb.getValue_(sb.get(src, i));
            ++i;
        }
        return d;
    }

    public Object create(double[] array) {
        return array;
    }

    @Override
    public Object get(Object array, int index) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", double[] expected");
        }
        return ((double[])array)[index];
    }

    @Override
    public void getAll(Object array, Object[] result) throws BindingException {
        double[] a = (double[])array;
        int i = 0;
        while (i < a.length) {
            result[i] = a[i];
            ++i;
        }
    }

    @Override
    public void set(Object array, int index, Object value) throws BindingException {
        double[] a = (double[])array;
        a[index] = (Double)value;
    }

    @Override
    public int size(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", double[] expected");
        }
        return ((double[])array).length;
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof double[];
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    public double[] getArray(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", double[] expected");
        }
        return (double[])array;
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        int result = 1;
        double[] array = (double[])value;
        int i = 0;
        while (i < array.length) {
            double element = array[i];
            long bits = Double.doubleToLongBits(element);
            int elementHash = (int)(bits ^ bits >>> 32);
            result = 31 * result + elementHash;
            ++i;
        }
        return result;
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        double[] a1 = (double[])o1;
        int l1 = a1.length;
        double[] a2 = (double[])o2;
        int l2 = a2.length;
        int dif = l1 - l2;
        if (dif != 0) {
            return dif;
        }
        int i = 0;
        while (i < l1) {
            double v1 = a1[i];
            double v2 = a2[i];
            dif = Double.compare(v1, v2);
            if (dif != 0) {
                return dif;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void add(Object array, int index, Object element) throws BindingException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Object array, int index, int count) throws BindingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSize(Object array, int newSize) throws BindingException {
        int oldSize = Array.getLength(array);
        if (oldSize == newSize) {
            return;
        }
        throw new BindingException("double[] is length immutable");
    }

    @Override
    public boolean isResizable() {
        return false;
    }
}

