/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.DatatypeConstructionException;
import org.simantics.databoard.binding.error.RuntimeDatatypeConstructionException;
import org.simantics.databoard.binding.reflection.VoidBinding;
import org.simantics.databoard.parser.repository.DataTypeRepository;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.StreamUtil;

public class Datatypes {
    public static final BooleanType BOOLEAN = new BooleanType();
    public static final ByteType BYTE = new ByteType();
    public static final IntegerType INTEGER = new IntegerType();
    public static final LongType LONG = new LongType();
    public static final FloatType FLOAT = new FloatType();
    public static final DoubleType DOUBLE = new DoubleType();
    public static final StringType STRING = new StringType();
    public static final VariantType VARIANT = new VariantType();
    public static final Datatype VOID = VoidBinding.VOID_BINDING.type();
    public static final ArrayType BOOLEAN_ARRAY = new ArrayType(BOOLEAN);
    public static final ArrayType BYTE_ARRAY = new ArrayType(BYTE);
    public static final ArrayType INTEGER_ARRAY = new ArrayType(INTEGER);
    public static final ArrayType LONG_ARRAY = new ArrayType(LONG);
    public static final ArrayType FLOAT_ARRAY = new ArrayType(FLOAT);
    public static final ArrayType DOUBLE_ARRAY = new ArrayType(DOUBLE);
    public static final ArrayType STRING_ARRAY = new ArrayType(STRING);
    public static final ArrayType VARIANT_ARRAY = new ArrayType(VARIANT);
    public static final DataTypeRepository datatypeRepository = new DataTypeRepository();

    static {
        Charset UTF82 = Charset.forName("UTF-8");
        InputStream is = Datatypes.class.getResourceAsStream("standardTypes.dbt");
        try {
            try {
                String defs = StreamUtil.readString(is, UTF82);
                datatypeRepository.addDefinitions(defs);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (DataTypeSyntaxError e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {}
    }

    public static Datatype optional(Datatype type) {
        return new OptionalType(type);
    }

    public static <T extends Datatype> T getDatatype(Class<?> clazz) throws DatatypeConstructionException {
        try {
            return (T)((Binding)Bindings.getBinding(clazz)).type();
        }
        catch (BindingConstructionException e) {
            throw new DatatypeConstructionException(e);
        }
    }

    public static <T extends Datatype> T getDatatypeUnchecked(Class<?> clazz) throws RuntimeDatatypeConstructionException {
        try {
            return (T)((Binding)Bindings.getBinding(clazz)).type();
        }
        catch (BindingConstructionException e) {
            throw new RuntimeDatatypeConstructionException(new DatatypeConstructionException(e));
        }
    }

    public static void addDatatype(String name, Datatype type) {
        datatypeRepository.add(name, type);
    }

    public static Datatype getDatatype(String name) {
        return datatypeRepository.get(name);
    }

    public static void addDefinitions(String definitions) throws DataTypeSyntaxError {
        datatypeRepository.addDefinitions(definitions);
    }

    public static Datatype translate(String typeString) throws DataTypeSyntaxError {
        return datatypeRepository.translate(typeString);
    }
}

