/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.binary.BinaryArray;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.binary.BinaryStreamArray;
import org.simantics.databoard.accessor.binary.BinaryVariableWidthStreamArray;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.file.FileAccessor;
import org.simantics.databoard.accessor.file.FileArrayAccessor;
import org.simantics.databoard.accessor.file.FileVariantAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.DirectoryMap;
import org.simantics.databoard.accessor.java.JavaObject;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.BinaryMemory;
import org.simantics.databoard.util.binary.Blob;
import org.simantics.databoard.util.binary.RandomAccessBinary;

public class Accessors {
    static Executor CURRENT_THREAD = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };

    public static <T extends Accessor> T getAccessor(RandomAccessBinary binary, Datatype type, AccessorParams params) throws AccessorConstructionException {
        return (T)BinaryObject.createAccessor(binary, type, params);
    }

    public static <T extends Accessor> T getAccessor(RandomAccessBinary binary, Datatype type) throws AccessorConstructionException {
        return (T)BinaryObject.createAccessor(binary, type, AccessorParams.DEFAULT);
    }

    public static <T extends Accessor> T getAccessor(byte[] binary, Datatype type) throws AccessorConstructionException {
        BinaryMemory rab = new BinaryMemory(ByteBuffer.wrap(binary));
        return (T)BinaryObject.createAccessor(rab, type, AccessorParams.DEFAULT);
    }

    public static <T extends Accessor> T getAccessor(Binding binding, Object value, AccessorParams params) throws AccessorConstructionException {
        return (T)JavaObject.createAccessor(null, binding, value, params);
    }

    public static <T extends Accessor> T getAccessor(Binding binding, Object value) throws AccessorConstructionException {
        return (T)JavaObject.createAccessor(null, binding, value, AccessorParams.DEFAULT);
    }

    public static <T extends Accessor> T getAccessor(Variant variant) throws AccessorConstructionException {
        return (T)JavaObject.createAccessor(null, variant.getBinding(), variant.getValue(), AccessorParams.DEFAULT);
    }

    public static <T extends Accessor> T getAccessor(Variant variant, ChildReference ref) throws AccessorConstructionException {
        T a = Accessors.getAccessor(variant);
        return a.getComponent(ref);
    }

    public static <T extends Accessor> T getAccessor(Object value) throws AccessorConstructionException {
        try {
            Object binding = Bindings.getBinding(value.getClass());
            return (T)JavaObject.createAccessor(null, binding, value, AccessorParams.DEFAULT);
        }
        catch (BindingConstructionException e) {
            throw new AccessorConstructionException(e);
        }
    }

    public static FileVariantAccessor openAccessor(File file) throws AccessorConstructionException {
        try {
            BinaryFile bf = new BinaryFile(file);
            FileVariantAccessor result = (FileVariantAccessor)((Object)BinaryObject.createAccessor(bf, Datatypes.VARIANT, AccessorParams.DEFAULT));
            return result;
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
    }

    public static FileArrayAccessor openStream(File file, ArrayType type) throws AccessorConstructionException {
        return Accessors.openStream(file, type, "rw");
    }

    public static FileArrayAccessor openStream(File file, ArrayType type, String mode) throws AccessorConstructionException {
        return Accessors.openStream(file, type, mode, null);
    }

    public static FileArrayAccessor openStream(File file, ArrayType type, String mode, ArrayAccessor index) throws AccessorConstructionException {
        try {
            BinaryFile bf = new BinaryFile(file, mode);
            Blob blob = new Blob(bf);
            Object b = Bindings.getBinding(type.componentType);
            Serializer s = Bindings.getSerializer(b);
            if (s.getConstantSize() != null) {
                return new BinaryStreamArray(null, blob, (Datatype)type, AccessorParams.DEFAULT);
            }
            if (index == null) {
                return new BinaryArray(null, blob, (Datatype)type, AccessorParams.DEFAULT);
            }
            return new BinaryVariableWidthStreamArray(null, blob, type, AccessorParams.DEFAULT, index);
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
        catch (AccessorException e) {
            throw new AccessorConstructionException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorConstructionException(e);
        }
    }

    public static FileVariantAccessor createFile(File file) throws AccessorConstructionException {
        try {
            file.createNewFile();
            BinaryFile bf = new BinaryFile(file);
            FileVariantAccessor result = (FileVariantAccessor)((Object)BinaryObject.createAccessor(bf, Datatypes.VARIANT, AccessorParams.DEFAULT));
            try {
                Object vb = Bindings.getBinding(Void.TYPE);
                Object vv = ((Binding)vb).createDefault();
                result.setContentValue((Binding)vb, vv);
            }
            catch (AccessorException e) {
                try {
                    result.close();
                }
                catch (AccessorException accessorException) {}
                throw new AccessorConstructionException(e);
            }
            catch (BindingConstructionException e) {
                try {
                    result.close();
                }
                catch (AccessorException accessorException) {}
                throw new AccessorConstructionException(e);
            }
            catch (BindingException e) {
                try {
                    result.close();
                }
                catch (AccessorException accessorException) {}
                throw new AccessorConstructionException(e);
            }
            return result;
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
    }

    public static <T extends FileAccessor> T createFile(File file, Datatype type) throws AccessorConstructionException {
        BinaryFile bf;
        boolean existed;
        try {
            existed = file.createNewFile();
            bf = new BinaryFile(file);
        }
        catch (IOException e1) {
            throw new AccessorConstructionException(e1);
        }
        try {
            FileVariantAccessor result = (FileVariantAccessor)((Object)BinaryObject.createAccessor(bf, Datatypes.VARIANT, AccessorParams.DEFAULT));
            Object binding = Bindings.getMutableBinding(type);
            Object value = ((Binding)binding).createDefault();
            result.setContentValue((Binding)binding, value);
            return (T)((FileAccessor)result.getContentAccessor());
        }
        catch (BindingException e) {
            if (!existed) {
                file.delete();
            }
            throw new AccessorConstructionException(e);
        }
        catch (AccessorException e) {
            if (!existed) {
                file.delete();
            }
            throw new AccessorConstructionException(e);
        }
    }

    public static DirectoryMap openDirectory(File directory) {
        return new DirectoryMap(directory);
    }

    public static Executor getCurrentThread() {
        return Accessors.getCurrentThread();
    }
}

