/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.db.SCLExpressionTableEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsedSCLExpressionsRequest
extends UniqueRead<Collection<SCLExpressionTableEntry>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsedSCLExpressionsRequest.class);
    private static final String structuralResourceComponentURI = "http://www.simantics.org/Structural-1.2/Component";

    public Collection<SCLExpressionTableEntry> perform(ReadGraph graph) throws DatabaseException {
        ArrayList<SCLExpressionTableEntry> result = new ArrayList<SCLExpressionTableEntry>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        TreeSet<Resource> indexRoots = new TreeSet<Resource>();
        for (Resource ontology : Layer0Utils.listOntologies((ReadGraph)graph)) {
            if (!graph.isInstanceOf(ontology, L0.SharedOntology)) continue;
            indexRoots.add(ontology);
        }
        for (Resource child : graph.getObjects(Simantics.getProjectResource(), L0.ConsistsOf)) {
            if (!graph.isInstanceOf(child, L0.IndexRoot)) continue;
            indexRoots.add(child);
        }
        Resource componentResource = graph.getPossibleResource(structuralResourceComponentURI);
        if (componentResource != null) {
            for (Resource ontology : indexRoots) {
                List components = QueryIndexUtils.searchByTypeShallow((ReadGraph)graph, (Resource)ontology, (Resource)componentResource);
                for (Resource component : components) {
                    for (Statement propertyStatement : graph.getStatements(component, L0.HasProperty)) {
                        if (!graph.isInstanceOf(propertyStatement.getObject(), L0.SCLValue)) continue;
                        Resource sclValue = propertyStatement.getObject();
                        String expression = (String)graph.getPossibleRelatedValue2(sclValue, L0.SCLValue_expression);
                        Resource source = graph.getPossibleObject(sclValue, L0.PropertyOf);
                        if (source == null) continue;
                        String uri = graph.getPossibleURI(source);
                        String pred = (String)graph.getRelatedValue2(propertyStatement.getPredicate(), L0.HasName);
                        if (uri == null) continue;
                        result.add(new SCLExpressionTableEntry(expression, uri + "#" + pred, source));
                    }
                }
            }
        } else {
            LOGGER.info("{} is not available for finding expressions in component properties", (Object)structuralResourceComponentURI);
        }
        return result;
    }

    public static Collection<SCLExpressionTableEntry> execute() {
        try {
            return (Collection)Simantics.getSession().syncRequest((Read)new UsedSCLExpressionsRequest(), (Listener)TransientCacheListener.instance());
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

