/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.schema;

import java.util.ArrayList;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.IFunction;
import org.simantics.objmap.ILinkType;
import org.simantics.objmap.IMappingRule;
import org.simantics.objmap.MappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLinkType
implements ILinkType {
    static Logger LOGGER = LoggerFactory.getLogger((String)"org.simantics.objmap");
    public Resource domainType;
    public Class<?> rangeType;
    ArrayList<IMappingRule> rules;

    public SimpleLinkType(Resource domainType, Class<?> rangeType, ArrayList<IMappingRule> rules) {
        this.domainType = domainType;
        this.rangeType = rangeType;
        this.rules = rules;
    }

    public SimpleLinkType(Resource domainType, Class<?> rangeType) {
        this(domainType, rangeType, new ArrayList<IMappingRule>());
    }

    public void addRule(IMappingRule rule) {
        this.rules.add(rule);
    }

    @Override
    public Resource createDomainElement(WriteGraph g, Object rangeElement) throws MappingException {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.trace("SimpleLinkType.createDomainElement " + rangeElement.toString());
            }
            Resource result = g.newResource();
            g.claim(result, Layer0.getInstance((ReadGraph)g).InstanceOf, null, this.domainType);
            return result;
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public Object createRangeElement(ReadGraph g, Resource domainElement) throws MappingException {
        try {
            if (LOGGER.isInfoEnabled()) {
                try {
                    LOGGER.trace("SimpleLinkType.createRangeElement " + NameUtils.getSafeName((ReadGraph)g, (Resource)domainElement));
                }
                catch (DatabaseException e) {
                    throw new MappingException(e);
                }
            }
            return this.rangeType.newInstance();
        }
        catch (InstantiationException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public boolean updateDomain(WriteGraph g, IFunction<Object, Resource> map, Resource domainElement, Object rangeElement) throws MappingException {
        if (LOGGER.isInfoEnabled()) {
            try {
                LOGGER.trace("SimpleLinkType.updateDomain " + NameUtils.getSafeName((ReadGraph)g, (Resource)domainElement) + " " + rangeElement.toString());
            }
            catch (DatabaseException e) {
                throw new MappingException(e);
            }
        }
        boolean updated = false;
        for (IMappingRule rule : this.rules) {
            updated |= rule.updateDomain(g, map, domainElement, rangeElement);
        }
        return updated;
    }

    @Override
    public boolean updateRange(ReadGraph g, IFunction<Resource, Object> map, Resource domainElement, Object rangeElement) throws MappingException {
        if (LOGGER.isInfoEnabled()) {
            try {
                LOGGER.trace("SimpleLinkType.updateRange " + NameUtils.getSafeName((ReadGraph)g, (Resource)domainElement) + " " + rangeElement.toString());
            }
            catch (DatabaseException e) {
                throw new MappingException(e);
            }
        }
        boolean updated = false;
        for (IMappingRule rule : this.rules) {
            updated |= rule.updateRange(g, map, domainElement, rangeElement);
        }
        return updated;
    }
}

