/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.UnionAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.UnionType;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.ExportExtensionPoint;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.Exporter;
import org.simantics.export.core.intf.Publisher;
import org.simantics.export.core.manager.Content;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.strings.AlphanumComparator;

public class ExporterUtils {
    public static Comparator<Content> CONTENT_COMPARATOR = new Comparator<Content>(){

        @Override
        public int compare(Content o1, Content o2) {
            int c = AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.url, (Object)o2.url);
            if (c != 0) {
                return c;
            }
            c = AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.formatId, (Object)o2.formatId);
            if (c != 0) {
                return c;
            }
            return 0;
        }
    };

    public static Variant getPublisherLocationOptions(ExportContext ctx, String publisherId, Variant options) throws ExportException {
        try {
            Publisher publisher = ctx.eep.getPublisher(publisherId);
            Variant locationOptions = options.getComponent((ChildReference)new LabelReference(publisher.label()));
            return locationOptions;
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsKey(Preferences pref, String key) {
        try {
            String[] stringArray = pref.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String x = stringArray[n2];
                if (x.equals(key)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getPrefString(Preferences pref, String key) {
        if (pref == null) {
            return null;
        }
        if (!ExporterUtils.containsKey(pref, key)) {
            return null;
        }
        return pref.get(key, null);
    }

    public static String getPrefString(Preferences pref1, Preferences pref2, String key) {
        if (pref1 != null && ExporterUtils.containsKey(pref1, key)) {
            return pref1.get(key, null);
        }
        if (pref2 != null && ExporterUtils.containsKey(pref2, key)) {
            return pref2.get(key, null);
        }
        return null;
    }

    public static Integer getPrefInteger(Preferences pref1, Preferences pref2, String key) {
        if (pref1 != null && ExporterUtils.containsKey(pref1, key)) {
            return pref1.getInt(key, -1);
        }
        if (pref2 != null && ExporterUtils.containsKey(pref2, key)) {
            return pref2.getInt(key, -1);
        }
        return null;
    }

    public static Boolean getPrefBoolean(Preferences pref1, Preferences pref2, String key) {
        if (pref1 != null && ExporterUtils.containsKey(pref1, key)) {
            return pref1.getBoolean(key, false);
        }
        if (pref2 != null && ExporterUtils.containsKey(pref2, key)) {
            return pref2.getBoolean(key, false);
        }
        return null;
    }

    public static Double getPrefDouble(Preferences pref1, Preferences pref2, String key) {
        if (pref1 != null && ExporterUtils.containsKey(pref1, key)) {
            return pref1.getDouble(key, 0.0);
        }
        if (pref2 != null && ExporterUtils.containsKey(pref2, key)) {
            return pref2.getDouble(key, 0.0);
        }
        return null;
    }

    public static void setPrefString(Preferences pref, String key, String value) {
        if (pref == null) {
            return;
        }
        if (value == null) {
            pref.remove(key);
        } else {
            pref.put(key, value);
        }
    }

    public static void setPrefInt(Preferences pref, String key, Integer value) {
        if (pref == null) {
            return;
        }
        if (value == null) {
            pref.remove(key);
        } else {
            pref.putInt(key, value.intValue());
        }
    }

    public static void setPrefdouble(Preferences pref, String key, Double value) {
        if (pref == null) {
            return;
        }
        if (value == null) {
            pref.remove(key);
        } else {
            pref.putDouble(key, value.doubleValue());
        }
    }

    public static boolean setUnionValue(Accessor ra, ChildReference ref, String tagName) {
        int tag;
        UnionType ut;
        UnionAccessor ua;
        block7: {
            if (tagName == null) {
                return false;
            }
            ua = (UnionAccessor)ra.getComponent(ref);
            ut = ua.type();
            tag = ut.getComponentIndex2(tagName);
            if (tag >= 0) break block7;
            return false;
        }
        try {
            Component c = ut.components[tag];
            Binding cb = Bindings.getMutableBinding((Datatype)c.type);
            Object o = cb.createDefault();
            ua.setComponentValue(tag, cb, o);
            return true;
        }
        catch (ReferenceException referenceException) {
            return false;
        }
        catch (AccessorConstructionException e) {
            e.printStackTrace();
            return false;
        }
        catch (AccessorException e) {
            e.printStackTrace();
            return false;
        }
        catch (BindingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean setUnionValue(Accessor ra, ChildReference ref, int tag) {
        if (tag < 0) {
            return false;
        }
        try {
            UnionAccessor ua = (UnionAccessor)ra.getComponent(ref);
            UnionType ut = ua.type();
            Component c = ut.components[tag];
            Binding cb = Bindings.getMutableBinding((Datatype)c.type);
            Object o = cb.createDefault();
            ua.setComponentValue(tag, cb, o);
            return true;
        }
        catch (ReferenceException referenceException) {
            return false;
        }
        catch (AccessorConstructionException e) {
            e.printStackTrace();
            return false;
        }
        catch (AccessorException e) {
            e.printStackTrace();
            return false;
        }
        catch (BindingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getUnionValue(Accessor ra, ChildReference ref) {
        try {
            UnionAccessor ua = (UnionAccessor)ra.getComponent(ref);
            UnionType ut = ua.type();
            int tag = ua.getTag();
            return ut.components[tag].name;
        }
        catch (ReferenceException referenceException) {
            return null;
        }
        catch (AccessorConstructionException e) {
            e.printStackTrace();
            return null;
        }
        catch (AccessorException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getUnionInt(Accessor ra, ChildReference ref) {
        try {
            UnionAccessor ua = (UnionAccessor)ra.getComponent(ref);
            int tag = ua.getTag();
            return tag;
        }
        catch (ReferenceException referenceException) {
            return -1;
        }
        catch (AccessorConstructionException e) {
            e.printStackTrace();
            return -1;
        }
        catch (AccessorException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String getString(Variant location, ChildReference ref) {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)location);
            return (String)ra.getValue(ref, (Binding)Bindings.STRING);
        }
        catch (AccessorConstructionException accessorConstructionException) {
            return null;
        }
        catch (AccessorException accessorException) {
            return null;
        }
    }

    public static Boolean getBoolean(Variant location, ChildReference ref) {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)location);
            return (Boolean)ra.getValue(ref, (Binding)Bindings.BOOLEAN);
        }
        catch (AccessorConstructionException accessorConstructionException) {
            return null;
        }
        catch (AccessorException accessorException) {
            return null;
        }
    }

    public static Comparator<Content> createExportPriorityComparator(final ExportExtensionPoint eep) {
        return new Comparator<Content>(){

            @Override
            public int compare(Content c1, Content c2) {
                int p1 = Integer.MAX_VALUE;
                Exporter[] exporterArray = eep.getExporters(c1.formatId, c1.contentTypeId);
                int n = exporterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Exporter e = exporterArray[n2];
                    p1 = Math.min(p1, e.getExportPriority());
                    ++n2;
                }
                int p2 = Integer.MAX_VALUE;
                Exporter[] exporterArray2 = eep.getExporters(c2.formatId, c2.contentTypeId);
                int n3 = exporterArray2.length;
                n = 0;
                while (n < n3) {
                    Exporter e = exporterArray2[n];
                    p2 = Math.min(p2, e.getExportPriority());
                    ++n;
                }
                return Integer.signum(p1 - p2);
            }
        };
    }

    public static MapList<Content, Content> filterByUri(MapList<Content, Content> map, String contentUri) {
        if (map == null) {
            return null;
        }
        MapList result = new MapList();
        for (Content key : map.getKeys()) {
            if (!key.url.equals(contentUri)) continue;
            result.addAll((Object)key, (Collection)map.getValuesUnsafe((Object)key));
        }
        return result;
    }

    public static MapList<String, Content> toStringMap(MapList<Content, Content> map) {
        if (map == null) {
            return null;
        }
        MapList result = new MapList();
        for (Content key : map.getKeys()) {
            result.addAll((Object)key.url, (Collection)map.getValuesUnsafe((Object)key));
        }
        return result;
    }

    public static List<Content> filterContents(Collection<Content> contents, String contentTypeId, String formatId) {
        if (contents == null) {
            return null;
        }
        ArrayList<Content> result = new ArrayList<Content>(contents.size());
        for (Content content : contents) {
            if (contentTypeId != null && !content.contentTypeId.equals(contentTypeId) || formatId != null && !content.formatId.equals(formatId)) continue;
            result.add(content);
        }
        return result;
    }

    public static List<String> toUris(Collection<Content> contents) {
        ArrayList<String> result = new ArrayList<String>(contents.size());
        for (Content content : contents) {
            result.add(content.url);
        }
        return result;
    }

    public static List<Content> sortContent(List<Content> content) {
        Collections.sort(content, CONTENT_COMPARATOR);
        return content;
    }

    public static List<Content> sortedContent(List<Content> content) {
        ArrayList<Content> sorted = new ArrayList<Content>(content);
        ExporterUtils.sortContent(sorted);
        return sorted;
    }
}

