/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.VariableBase;
import java.util.Map;

public class Division
implements IExpression {
    public IExpression exp1;
    public IExpression exp2;

    public Division(IExpression exp1, IExpression exp2) {
        this.exp1 = exp1;
        this.exp2 = exp2;
    }

    public String toString() {
        return String.valueOf(this.exp1) + " / " + String.valueOf(this.exp2);
    }

    private Array arrayDiv(Array a, final Double d) {
        return a.copy(new Array.Modifier(){

            @Override
            public Object modify(Object o) {
                if (o instanceof Double) {
                    return (Double)o / d;
                }
                throw new IllegalStateException();
            }
        });
    }

    @Override
    public Object evaluate(IEnvironment environment) {
        Object left = this.exp1.evaluate(environment);
        Object right = this.exp2.evaluate(environment);
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Double && right instanceof Double) {
            return (Double)left / (Double)right;
        }
        if (left instanceof Array && right instanceof Double) {
            return this.arrayDiv((Array)left, (Double)right);
        }
        if (left instanceof Double && right instanceof Array) {
            return this.arrayDiv((Array)right, (Double)left);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public IExpression withBase(IFrame frame, String prefix) {
        return new Division(this.exp1.withBase(frame, prefix), this.exp2.withBase(frame, prefix));
    }

    @Override
    public Object getPossibleConstant() {
        return null;
    }

    @Override
    public IExpression rewrite(IFrame frame, Map<String, VariableBase> copies) {
        this.exp1 = this.exp1.rewrite(frame, copies);
        this.exp2 = this.exp2.rewrite(frame, copies);
        return this;
    }

    @Override
    public void accept(IExpression.ExpressionVisitor visitor) {
        visitor.visit(this);
        this.exp1.accept(visitor);
        this.exp2.accept(visitor);
    }
}

