/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.logging.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.simantics.logging.LogConfigurator;
import org.simantics.logging.LoggerLevel;
import org.simantics.logging.ui.Activator;

public class LoggerManagementDialog
extends TrayDialog {
    private static final String DIALOG = LoggerManagementDialog.class.getSimpleName();
    private static final String[] LEVELS = new String[]{"ERROR", "WARN", "INFO", "DEBUG", "TRACE"};
    private static final Map<String, Integer> LEVEL_TO_INDEX = new HashMap<String, Integer>();
    private int APPLY_ID = 1025;
    private String APPLY_LABEL = JFaceResources.getString((String)"apply");
    private TableViewer tableViewer;
    private List<LoggerLevel> configuration;
    private IDialogSettings dialogBoundsSettings;
    private Consumer<List<LoggerLevel>> applyFunction;
    private final AtomicReference<ViewerFilter[]> filtersToSet = new AtomicReference();
    private final Runnable setFilters = () -> {
        ViewerFilter[] fs;
        if (!this.tableViewer.getTable().isDisposed() && (fs = (ViewerFilter[])this.filtersToSet.getAndSet(null)) != null) {
            this.tableViewer.getTable().setRedraw(false);
            this.tableViewer.setFilters(fs);
            this.tableViewer.getTable().setRedraw(true);
        }
    };

    static {
        int i = 0;
        while (i < LEVELS.length) {
            LEVEL_TO_INDEX.put(LEVELS[i], i);
            ++i;
        }
    }

    public LoggerManagementDialog(Shell shell, Consumer<List<LoggerLevel>> applyFunction) {
        super(shell);
        this.reloadConfiguration();
        this.applyFunction = applyFunction;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.dialogBoundsSettings = settings.getSection(DIALOG);
        if (this.dialogBoundsSettings == null) {
            this.dialogBoundsSettings = settings.addNewSection(DIALOG);
        }
    }

    private void reloadConfiguration() {
        this.configuration = LogConfigurator.listConfiguredLoggers();
        this.addEmptyRow();
    }

    private void addEmptyRow() {
        this.configuration.add(new LoggerLevel("", LEVELS[2]));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Manage Loggers");
        newShell.setMinimumSize(800, 600);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, this.APPLY_ID, this.APPLY_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            super.buttonPressed(1);
        } else if (buttonId == this.APPLY_ID) {
            if (this.applyFunction != null) {
                this.applyFunction.accept(this.configuration);
                this.reloadConfiguration();
                this.setInput();
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(1).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Composite tableComposite = new Composite(composite, 0);
        TableColumnLayout tcl = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcl);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        this.tableViewer = new TableViewer(tableComposite, 67586);
        Display display = this.getShell().getDisplay();
        Font systemFont = display.getSystemFont();
        Font italic = FontDescriptor.createFrom((Font)systemFont).setStyle(2).createFont((Device)display);
        Font bold = FontDescriptor.createFrom((Font)systemFont).setStyle(1).createFont((Device)display);
        this.tableViewer.getTable().addDisposeListener(e -> {
            italic.dispose();
            bold.dispose();
        });
        final Function<LoggerLevel, Font> fontFunction = l -> {
            if (l.isLoggerDefined()) {
                if (l.levelChanged()) {
                    return bold;
                }
                return systemFont;
            }
            return italic;
        };
        TableViewerColumn column1 = new TableViewerColumn(this.tableViewer, 0);
        column1.getColumn().setWidth(300);
        column1.getColumn().setText("Logger");
        column1.getColumn().setToolTipText("Package Name of Logger");
        column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                LoggerLevel l = (LoggerLevel)cell.getElement();
                cell.setText(l.getName());
                cell.setFont((Font)fontFunction.apply(l));
            }
        });
        column1.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            CellEditor editor;
            {
                this.editor = new TextCellEditor((Composite)LoggerManagementDialog.this.tableViewer.getTable());
            }

            protected CellEditor getCellEditor(Object element) {
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                LoggerLevel l = (LoggerLevel)element;
                return !l.isLoggerDefined();
            }

            protected Object getValue(Object element) {
                return ((LoggerLevel)element).getName();
            }

            protected void setValue(Object element, Object value) {
                boolean sameNameExists;
                LoggerLevel l = (LoggerLevel)element;
                String s = ((String)value).trim();
                boolean bl = sameNameExists = !s.isEmpty() && LoggerManagementDialog.this.configuration.stream().anyMatch(ll -> ll != l && ll.getName().equals(s));
                if (sameNameExists) {
                    return;
                }
                String previousName = l.getName();
                l.setName(s);
                if (s.isEmpty()) {
                    int index = LoggerManagementDialog.this.configuration.indexOf(l);
                    if (index >= 0 && index < LoggerManagementDialog.this.configuration.size() - 1) {
                        LoggerManagementDialog.this.configuration.remove(index);
                    }
                } else if (previousName.isEmpty()) {
                    LoggerManagementDialog.this.addEmptyRow();
                }
                LoggerManagementDialog.this.setInput();
            }
        });
        TableViewerColumn column2 = new TableViewerColumn(this.tableViewer, 0);
        column2.getColumn().setWidth(100);
        column2.getColumn().setText("Log Level");
        column2.getColumn().setToolTipText("Logging Level for Package and Subpackages");
        column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                LoggerLevel l = (LoggerLevel)cell.getElement();
                cell.setText(l.getLevel());
                cell.setFont((Font)fontFunction.apply(l));
            }
        });
        column2.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)LoggerManagementDialog.this.tableViewer.getTable(), LEVELS, 8){

                    protected Control createControl(Composite parent) {
                        CCombo combo = (CCombo)super.createControl(parent);
                        combo.getDisplay().asyncExec(() -> {
                            if (!combo.isDisposed()) {
                                combo.setListVisible(true);
                            }
                        });
                        return combo;
                    }
                };
            }

            protected Object getValue(Object element) {
                LoggerLevel l = (LoggerLevel)element;
                return LEVEL_TO_INDEX.get(l.getLevel());
            }

            protected void setValue(Object element, Object value) {
                LoggerLevel l = (LoggerLevel)element;
                l.setLevel(LEVELS[(Integer)value]);
                this.getViewer().update(element, null);
            }
        });
        tcl.setColumnData((Widget)column1.getColumn(), (ColumnLayoutData)new ColumnWeightData(5, 300));
        tcl.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 150));
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.getTable().addListener(1, e -> {
            if (e.keyCode == 127) {
                List s = this.tableViewer.getStructuredSelection().toList();
                Predicate<Object> removable = l -> {
                    LoggerLevel ll = (LoggerLevel)l;
                    return ll.isLoggerDefined() && !ll.getName().isEmpty();
                };
                if (s.stream().allMatch(removable)) {
                    s.forEach(this.configuration::remove);
                    this.setInput();
                }
            }
        });
        Text filterText = new Text(composite, 0x800800);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filterText);
        filterText.setToolTipText("Package Name Filter");
        filterText.moveAbove((Control)tableComposite);
        filterText.addModifyListener(e -> {
            final String filter = filterText.getText().trim().toLowerCase();
            ViewerFilter[] filters = new ViewerFilter[]{};
            if (!filter.isEmpty()) {
                filters = new ViewerFilter[]{new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        LoggerLevel l = (LoggerLevel)element;
                        return !l.isLoggerDefined() || l.levelChanged() ? true : l.getName().toLowerCase().contains(filter);
                    }
                }};
            }
            this.scheduleSetFilters(filters);
        });
        this.setInput();
        return composite;
    }

    private void setInput() {
        this.tableViewer.setInput((Object)this.configuration.toArray(new LoggerLevel[this.configuration.size()]));
    }

    public List<LoggerLevel> getConfiguration() {
        return this.configuration;
    }

    protected void scheduleSetFilters(ViewerFilter[] array) {
        this.filtersToSet.set(array);
        this.getShell().getDisplay().timerExec(250, this.setFilters);
    }
}

