/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types.util;

import java.util.Comparator;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TUnion;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.util.TConComparator;

public enum TypeComparator implements Comparator<Type>
{
    INSTANCE;


    @Override
    public int compare(Type t1, Type t2) {
        int id2;
        t1 = Types.canonical(t1);
        t2 = Types.canonical(t2);
        int id1 = t1.getClassId();
        if (id1 < (id2 = t2.getClassId())) {
            return -1;
        }
        if (id1 > id2) {
            return 1;
        }
        switch (id1) {
            case 1: {
                TApply p1 = (TApply)t1;
                TApply p2 = (TApply)t2;
                int cur = this.compare(p1.function, p2.function);
                if (cur != 0) {
                    return cur;
                }
                return this.compare(p1.parameter, p2.parameter);
            }
            case 2: {
                return TConComparator.INSTANCE.compare((TCon)t1, (TCon)t2);
            }
            case 3: {
                return 0;
            }
            case 4: {
                TPred p1 = (TPred)t1;
                TPred p2 = (TPred)t2;
                int cur = TConComparator.INSTANCE.compare(p1.typeClass, p2.typeClass);
                if (cur != 0) {
                    return cur;
                }
                cur = p1.parameters.length - p2.parameters.length;
                if (cur != 0) {
                    return cur;
                }
                int i = 0;
                while (i < p1.parameters.length) {
                    cur = this.compare(p1.parameters[i], p2.parameters[i]);
                    if (cur != 0) {
                        return cur;
                    }
                    ++i;
                }
                return 0;
            }
            case 0: {
                TFun p1 = (TFun)t1;
                TFun p2 = (TFun)t2;
                int cur = this.compare(p1.domain, p2.domain);
                if (cur != 0) {
                    return cur;
                }
                cur = this.compare(p1.range, p2.range);
                if (cur != 0) {
                    return cur;
                }
                return this.compare(p1.effect, p2.effect);
            }
            case 7: {
                TUnion p1 = (TUnion)t1;
                TUnion p2 = (TUnion)t2;
                int cur = p1.effects.length - p2.effects.length;
                if (cur != 0) {
                    return cur;
                }
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }
}

