/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.html;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.simantics.scl.compiler.markdown.html.HierarchicalDocumentationRef;
import org.simantics.scl.compiler.markdown.html.HtmlDocumentationGeneration;
import org.simantics.scl.compiler.module.repository.ModuleRepository;

public class GenerateAllHtmlDocumentation {
    public static void generate(ModuleRepository moduleRepository, Path directory) throws IOException {
        HierarchicalDocumentationRef root = HierarchicalDocumentationRef.generateTree(moduleRepository.getSourceRepository());
        GenerateAllHtmlDocumentation.generate(moduleRepository, directory, root.getChildren(), 0, root);
        GenerateAllHtmlDocumentation.generateIndex(directory, 0, "StandardLibrary/Prelude.html");
    }

    private static void generateIndex(Path directory, int level, String url) throws IOException {
        Path documentationFile = directory.resolve("index.html");
        int i = 0;
        while (i < level) {
            url = "../" + (String)url;
            ++i;
        }
        String content = "<html><head><meta http-equiv=\"refresh\" content=\"1;url=" + (String)url + "\"><script type=\"text/javascript\">window.location.href = \"" + (String)url + "\"</script></head><body>If you are not redirected automatically, <a href=\"" + (String)url + "\">follow the link</a>.</body></html>";
        Files.write(documentationFile, content.getBytes(), new OpenOption[0]);
    }

    private static void generate(ModuleRepository moduleRepository, Path directory, List<HierarchicalDocumentationRef> refs, int level, HierarchicalDocumentationRef root) throws IOException {
        String navigation = GenerateAllHtmlDocumentation.generateNavigation(level, root);
        for (HierarchicalDocumentationRef ref : refs) {
            List<HierarchicalDocumentationRef> children;
            String name = ref.getName();
            String documentationName = ref.getDocumentationName();
            if (documentationName != null) {
                String documentation = HtmlDocumentationGeneration.generate(moduleRepository, documentationName, navigation);
                Path documentationFile = directory.resolve(name + ".html");
                Files.write(documentationFile, documentation.getBytes(), new OpenOption[0]);
            }
            if ((children = ref.getChildren()).isEmpty()) continue;
            Path childDirectory = directory.resolve(name);
            if (!Files.exists(childDirectory, new LinkOption[0])) {
                Files.createDirectory(childDirectory, new FileAttribute[0]);
            }
            GenerateAllHtmlDocumentation.generate(moduleRepository, childDirectory, children, level + 1, root);
            if (documentationName != null) {
                GenerateAllHtmlDocumentation.generateIndex(childDirectory, 1, ref.getName() + ".html");
                continue;
            }
            GenerateAllHtmlDocumentation.generateIndex(childDirectory, level + 1, "StandardLibrary/Prelude.html");
        }
    }

    private static String generateNavigation(int level, HierarchicalDocumentationRef root) {
        StringBuilder b = new StringBuilder();
        GenerateAllHtmlDocumentation.generateNavigation(b, level, root.getChildren());
        return b.toString();
    }

    private static void generateNavigation(StringBuilder b, int level, List<HierarchicalDocumentationRef> refs) {
        b.append("<ul>");
        for (HierarchicalDocumentationRef ref : refs) {
            List<HierarchicalDocumentationRef> children;
            b.append("<li>");
            Object documentationName = ref.getDocumentationName();
            if (documentationName != null) {
                if (!((String)documentationName).contains("/")) {
                    documentationName = "StandardLibrary/" + (String)documentationName;
                }
                b.append("<a href=\"");
                int i = 0;
                while (i < level) {
                    b.append("../");
                    ++i;
                }
                b.append((String)documentationName);
                b.append(".html\">");
            }
            b.append(ref.getName());
            if (documentationName != null) {
                b.append("</a>");
            }
            if ((children = ref.getChildren()) != null) {
                GenerateAllHtmlDocumentation.generateNavigation(b, level, children);
            }
            b.append("</li>");
        }
        b.append("</ul>");
    }
}

