/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.transformations;

import gnu.trove.procedure.TObjectObjectProcedure;
import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.query.QMapping;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.relations.LocalRelation;
import org.simantics.scl.compiler.elaboration.rules.SectionName;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;

public class DecomposedRule {
    final TransformationRule rule;
    final ArrayList<Query> sourceQueries = new ArrayList();
    final ArrayList<QMapping> sourceMappings = new ArrayList();
    final ArrayList<Query> targetQueries = new ArrayList();
    final ArrayList<QMapping> targetMappings = new ArrayList();
    LocalRelation ruleMatchingRelation;

    private DecomposedRule(TransformationRule rule) {
        this.rule = rule;
    }

    public static DecomposedRule decompose(final TypingContext context, TransformationRule rule, final boolean forwardDirection) {
        final DecomposedRule result = new DecomposedRule(rule);
        rule.forEachSection(new TObjectObjectProcedure<SectionName, Query[]>(){

            public boolean execute(SectionName sectionName, Query[] queries) {
                switch (forwardDirection ? sectionName.forwardRole : sectionName.backwardRole) {
                    case MATCH: {
                        Query[] queryArray = queries;
                        int n = queries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Query query = queryArray[n2];
                            if (query instanceof QMapping) {
                                QMapping mapping = (QMapping)query;
                                result.sourceMappings.add(mapping);
                            } else {
                                result.sourceQueries.add(query.copy(context));
                            }
                            ++n2;
                        }
                        break;
                    }
                    case ENFORCE: 
                    case ENFORCE_FIRST_TIME: {
                        Query[] queryArray = queries;
                        int n = queries.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Query query = queryArray[n3];
                            if (query instanceof QMapping) {
                                QMapping mapping = (QMapping)query;
                                result.targetMappings.add(mapping);
                            } else {
                                result.targetQueries.add(query.copy(context));
                            }
                            ++n3;
                        }
                        break;
                    }
                }
                return true;
            }
        });
        return result;
    }
}

