/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.AmbiguousNameException;

public class ERecord
extends ASTExpression {
    public static final boolean DEBUG = false;
    public final EVar constructor;
    public final FieldAssignment[] fields;

    public ERecord(EVar constructor, FieldAssignment[] fields) {
        this.constructor = constructor;
        this.fields = fields;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this.resolve(context, false);
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return this.resolve(context, true);
    }

    public Expression resolve(TranslationContext context, boolean asPattern) {
        SCLValue constructorValue;
        try {
            constructorValue = context.resolveRecordConstructor(this.location, this.constructor.name);
        }
        catch (AmbiguousNameException e) {
            context.getErrorLog().log(this.constructor.location, e.getMessage());
            return new EError(this.constructor.location);
        }
        if (constructorValue == null) {
            context.getErrorLog().log(this.constructor.location, "Couldn't resolve the record constructor " + this.constructor.name + ".");
            return new EError(this.constructor.location);
        }
        String[] parameterNames = constructorValue.parameterNames;
        if (parameterNames == null) {
            context.getErrorLog().log(this.constructor.location, "Value " + this.constructor.name + " is not a record constructor.");
            return new EError(this.constructor.location);
        }
        Expression[] parameters = ERecord.translateFieldsToFunctionParameters(context, this.fields, parameterNames, false);
        if (parameters == null) {
            return new EError(this.location);
        }
        if (asPattern) {
            int i = 0;
            while (i < parameters.length) {
                Expression parameter = parameters[i];
                parameters[i] = parameter == null ? Expressions.blank(null) : parameter.resolveAsPattern(context);
                ++i;
            }
        } else {
            boolean error = false;
            int i = 0;
            while (i < parameters.length) {
                Expression parameter = parameters[i];
                if (parameter == null) {
                    TranslationContext.ExistentialFrame frame = context.getCurrentExistentialFrame();
                    if (frame == null || frame.disallowNewExistentials) {
                        context.getErrorLog().log(this.location, "Field " + parameterNames[i] + " not defined.");
                        error = true;
                    } else {
                        parameters[i] = frame.createBlank(this.location);
                    }
                } else {
                    parameters[i] = parameter.resolve(context);
                }
                ++i;
            }
            if (error) {
                return new EError(this.location);
            }
        }
        EApply result = new EApply((Expression)new EConstant(constructorValue), parameters);
        result.setLocationDeep(this.location);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static Expression[] translateFieldsToFunctionParameters(TranslationContext context, FieldAssignment[] fields, String[] fieldNames, boolean chrLiteral) {
        recordMap = new THashMap(fields.length);
        error = false;
        wildcardField = null;
        var10_7 = fields;
        var9_8 = fields.length;
        var8_11 = 0;
        while (var8_11 < var9_8) {
            field = var10_7[var8_11];
            if (field.value != null) ** GOTO lbl33
            actualName = field.name;
            if (actualName.equals("..")) {
                if (wildcardField != null) {
                    context.getErrorLog().log(field.location, "The record has more than one wildcard.");
                }
                wildcardField = field;
            } else {
                if (actualName.charAt(0) == '?') {
                    actualName = actualName.substring(1);
                }
                bestMatch = null;
                bestMatchLength = 0;
                i = 0;
                while (i < fieldNames.length) {
                    fieldName = fieldNames[i];
                    if (actualName.startsWith(fieldName) && fieldName.length() > bestMatchLength) {
                        bestMatch = fieldName;
                        bestMatchLength = fieldName.length();
                    }
                    ++i;
                }
                if (bestMatch == null) {
                    context.getErrorLog().log(field.location, "Invalid shorthand field " + field.name + " is defined twice.");
                    error = true;
                }
                field.value = new EVar(field.location, field.name);
                field.name = bestMatch;
lbl33:
                // 2 sources

                if (recordMap.put((Object)field.name, (Object)field) != null) {
                    context.getErrorLog().log(field.location, "Field " + field.name + " is defined more than once.");
                    error = true;
                }
            }
            ++var8_11;
        }
        if (error) {
            return null;
        }
        parameters = new Expression[fieldNames.length];
        i = 0;
        while (i < fieldNames.length) {
            assignment = (FieldAssignment)recordMap.remove((Object)fieldNames[i]);
            if (assignment != null) {
                parameters[i] = assignment.value;
            } else if (wildcardField != null) {
                variableName = fieldNames[i];
                if (chrLiteral) {
                    variableName = "?" + (String)variableName;
                }
                expandedVar = new EVar(wildcardField.location, (String)variableName);
                parameters[i] = expandedVar;
                context.addExpandedFromWildcard(expandedVar);
            }
            ++i;
        }
        if (!recordMap.isEmpty()) {
            for (FieldAssignment field : recordMap.values()) {
                context.getErrorLog().log(field.location, "Field " + field.name + " is not defined in the constructor.");
            }
            return null;
        }
        return parameters;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            FieldAssignment[] fieldAssignmentArray = this.fields;
            int n = this.fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldAssignment field = fieldAssignmentArray[n2];
                if (field.value != null) {
                    field.value.setLocationDeep(loc);
                }
                ++n2;
            }
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

