/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.OpcodeMnemonics;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class JavaMathOperation
extends FunctionValue {
    public static final JavaMathOperation IADD = new JavaMathOperation(96, (Type)Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation ISUB = new JavaMathOperation(100, (Type)Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IMUL = new JavaMathOperation(104, (Type)Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IDIV = new JavaMathOperation(108, (Type)Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IREM = new JavaMathOperation(112, (Type)Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation INEG = new JavaMathOperation(116, (Type)Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IAND = new JavaMathOperation(126, (Type)Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IOR = new JavaMathOperation(128, (Type)Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IXOR = new JavaMathOperation(130, (Type)Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation ISHL = new JavaMathOperation(120, (Type)Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation ISHR = new JavaMathOperation(122, (Type)Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation IUSHR = new JavaMathOperation(124, (Type)Types.INTEGER, Types.INTEGER, Types.INTEGER);
    public static final JavaMathOperation LADD = new JavaMathOperation(97, (Type)Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LSUB = new JavaMathOperation(101, (Type)Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LMUL = new JavaMathOperation(105, (Type)Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LDIV = new JavaMathOperation(109, (Type)Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LREM = new JavaMathOperation(113, (Type)Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LNEG = new JavaMathOperation(117, (Type)Types.LONG, Types.LONG);
    public static final JavaMathOperation LAND = new JavaMathOperation(127, (Type)Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LOR = new JavaMathOperation(129, (Type)Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LXOR = new JavaMathOperation(131, (Type)Types.LONG, Types.LONG, Types.LONG);
    public static final JavaMathOperation LSHL = new JavaMathOperation(121, (Type)Types.LONG, Types.LONG, Types.INTEGER);
    public static final JavaMathOperation LSHR = new JavaMathOperation(123, (Type)Types.LONG, Types.LONG, Types.INTEGER);
    public static final JavaMathOperation LUSHR = new JavaMathOperation(125, (Type)Types.LONG, Types.LONG, Types.INTEGER);
    public static final JavaMathOperation FADD = new JavaMathOperation(98, (Type)Types.FLOAT, Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation FSUB = new JavaMathOperation(102, (Type)Types.FLOAT, Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation FMUL = new JavaMathOperation(106, (Type)Types.FLOAT, Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation FDIV = new JavaMathOperation(110, (Type)Types.FLOAT, Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation FREM = new JavaMathOperation(114, (Type)Types.FLOAT, Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation FNEG = new JavaMathOperation(118, (Type)Types.FLOAT, Types.FLOAT);
    public static final JavaMathOperation DADD = new JavaMathOperation(99, (Type)Types.DOUBLE, Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation DSUB = new JavaMathOperation(103, (Type)Types.DOUBLE, Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation DMUL = new JavaMathOperation(107, (Type)Types.DOUBLE, Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation DDIV = new JavaMathOperation(111, (Type)Types.DOUBLE, Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation DREM = new JavaMathOperation(115, (Type)Types.DOUBLE, Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation DNEG = new JavaMathOperation(119, (Type)Types.DOUBLE, Types.DOUBLE);
    public static final JavaMathOperation LCMP = new JavaMathOperation(148, (Type)Types.LONG, Types.LONG, Types.INTEGER);
    public static final JavaMathOperation FCMPG = new JavaMathOperation(150, (Type)Types.FLOAT, Types.FLOAT, Types.INTEGER);
    public static final JavaMathOperation FCMPL = new JavaMathOperation(149, (Type)Types.FLOAT, Types.FLOAT, Types.INTEGER);
    public static final JavaMathOperation DCMPG = new JavaMathOperation(152, (Type)Types.DOUBLE, Types.DOUBLE, Types.INTEGER);
    public static final JavaMathOperation DCMPL = new JavaMathOperation(151, (Type)Types.DOUBLE, Types.DOUBLE, Types.INTEGER);
    public static final JavaMathOperation SADD = new JavaMathOperation(96, (Type)Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SSUB = new JavaMathOperation(100, (Type)Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SMUL = new JavaMathOperation(104, (Type)Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SDIV = new JavaMathOperation(108, (Type)Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SREM = new JavaMathOperation(112, (Type)Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SNEG = new JavaMathOperation(116, (Type)Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SAND = new JavaMathOperation(126, (Type)Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SOR = new JavaMathOperation(128, (Type)Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation SXOR = new JavaMathOperation(130, (Type)Types.SHORT, Types.SHORT, Types.SHORT);
    public static final JavaMathOperation BADD = new JavaMathOperation(96, (Type)Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BSUB = new JavaMathOperation(100, (Type)Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BMUL = new JavaMathOperation(104, (Type)Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BDIV = new JavaMathOperation(108, (Type)Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BREM = new JavaMathOperation(112, (Type)Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BNEG = new JavaMathOperation(116, (Type)Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BAND = new JavaMathOperation(126, (Type)Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BOR = new JavaMathOperation(128, (Type)Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation BXOR = new JavaMathOperation(130, (Type)Types.BYTE, Types.BYTE, Types.BYTE);
    public static final JavaMathOperation CADD = new JavaMathOperation(96, (Type)Types.CHARACTER, Types.CHARACTER, Types.INTEGER);
    public static final JavaMathOperation CSUB = new JavaMathOperation(100, (Type)Types.INTEGER, Types.CHARACTER, Types.CHARACTER);
    public static final JavaMathOperation[] OPCODES = new JavaMathOperation[]{IADD, ISUB, IMUL, IDIV, IREM, INEG, IAND, IOR, IXOR, ISHL, ISHR, IUSHR, LADD, LSUB, LMUL, LDIV, LREM, LNEG, LAND, LOR, LXOR, LSHL, LSHR, LUSHR, FADD, FSUB, FMUL, FDIV, FREM, FNEG, DADD, DSUB, DMUL, DDIV, DREM, DNEG, LCMP, FCMPG, FCMPL, DCMPG, DCMPL};
    int opcode;

    private JavaMathOperation(int opcode, Type returnType, Type ... parameterTypes) {
        super(TVar.EMPTY_ARRAY, Types.NO_EFFECTS, returnType, parameterTypes);
        this.opcode = opcode;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        mb.push(parameters, this.parameterTypes);
        mb.math(this.opcode);
        return this.getReturnType();
    }

    public String getMnemonic() {
        return OpcodeMnemonics.MNEMONICS[this.opcode & 0xFF];
    }

    public String toString() {
        return this.getMnemonic();
    }
}

