/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal.contributions.search;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.swt.IFocusService;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.workbench.search.ISearchService;
import org.simantics.workbench.search.SearchQuery;

public class SearchTrim
extends Composite {
    private static final String SEARCH_TEXT_FOCUS_CONTROL_ID = "org.simantics.workbench.search.text";
    public static final String KEY_TRIM = "SearchTrim";
    private final LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
    private final boolean disabled = false;
    protected final Text searchText = new Text((Composite)this, 0x800A80);

    public SearchTrim(Composite parent) {
        super(parent, 0);
        this.searchText.setToolTipText("Enter Search Criteria for Active Model");
        GridDataFactory.fillDefaults().hint(100, -1).grab(true, true).applyTo((Control)this.searchText);
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    SearchTrim.this.nameAndTypeQuery((e.stateMask & 0x40000) == 0 ? ISearchService.ResultBrowser.VIEW : ISearchService.ResultBrowser.EDITOR);
                }
            }
        });
        if (PlatformUI.isWorkbenchRunning()) {
            IFocusService service = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
            service.addFocusTracker((Control)this.searchText, SEARCH_TEXT_FOCUS_CONTROL_ID);
        }
        if ((this.searchText.getStyle() & 0x200) == 0) {
            Label searchButton = new Label((Composite)this, 0);
            searchButton.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
            searchButton.setImage((Image)this.resourceManager.get((DeviceResourceDescriptor)BundleUtils.getImageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"/icons/magnifier.png")));
            searchButton.moveAbove((Control)this.searchText);
            searchButton.setToolTipText("Search Active Model Contents");
            GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).numColumns(3).applyTo((Composite)this);
        } else {
            GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).numColumns(2).applyTo((Composite)this);
        }
        Label filler = new Label((Composite)this, 0);
        GridDataFactory.swtDefaults().grab(true, false).minSize(3, -1).applyTo((Control)filler);
        final Shell shell = parent.getShell();
        shell.setData(KEY_TRIM, (Object)this.searchText);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                shell.setData(SearchTrim.KEY_TRIM, null);
            }
        });
    }

    protected void nameQuery(ISearchService.ResultBrowser browserType) {
        String originalInput = this.searchText.getText();
        String query = originalInput;
        if (query.trim().isEmpty()) {
            return;
        }
        query = this.filter(query);
        SearchQuery searchQuery = new SearchQuery(originalInput);
        searchQuery.setSearchFlag("NameSearch", "on");
        this.performQuery(searchQuery, browserType);
    }

    protected void typeQuery(ISearchService.ResultBrowser browserType) {
        String originalInput = this.searchText.getText();
        String query = originalInput;
        if (query.trim().isEmpty()) {
            return;
        }
        SearchQuery searchQuery = new SearchQuery(originalInput);
        searchQuery.setSearchFlag("TypesSearch", "on");
        this.performQuery(searchQuery, browserType);
    }

    protected void nameAndTypeQuery(ISearchService.ResultBrowser browserType) {
        String originalInput = this.searchText.getText();
        String query = originalInput;
        if (query.trim().isEmpty()) {
            return;
        }
        SearchQuery searchQuery = new SearchQuery(originalInput);
        searchQuery.setSearchFlag("NameSearch", "on");
        searchQuery.setSearchFlag("TypesSearch", "on");
        this.performQuery(searchQuery, browserType);
    }

    protected String filter(String query) {
        if (!((String)query).endsWith("*")) {
            query = (String)query + "*";
        }
        query = ((String)query).replaceAll("'", "\"");
        return query;
    }

    protected void performQuery(SearchQuery query, ISearchService.ResultBrowser browserType) {
        ISearchService searchService = (ISearchService)PlatformUI.getWorkbench().getService(ISearchService.class);
        searchService.performQuery(query, browserType, true);
    }
}

