/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services.adaption;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.set.hash.THashSet;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.adaption.Adapter;
import org.simantics.db.adaption.AdaptionService;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptionService2
implements AdaptionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdaptionService2.class);
    THashMap<Pair<Class<?>, Class<?>>, AdapterDeclaration<?>> adapters = new THashMap();

    private <T> AdapterDeclaration<T> getDeclaration(Class<T> targetClass, Class<?> contextClass) {
        Pair key = new Pair(targetClass, contextClass);
        AdapterDeclaration<T> decl = (AdapterDeclaration<T>)this.adapters.get((Object)key);
        if (decl == null) {
            decl = new AdapterDeclaration<T>(targetClass);
            this.adapters.put((Object)key, decl);
        }
        return decl;
    }

    public <T, C> void getAdapter(AsyncReadGraph graph, final Resource r, Class<C> contextClass, Class<T> targetClass, final boolean possible, final AsyncProcedure<Adapter<T, C>> procedure) {
        final Pair key = new Pair(targetClass, contextClass);
        final AdapterDeclaration decl = (AdapterDeclaration)this.adapters.get((Object)key);
        if (decl == null) {
            if (possible) {
                procedure.execute(graph, null);
            } else {
                procedure.exception(graph, (Throwable)new AdaptionException("There are no adapters declared or defined for class " + String.valueOf(targetClass) + "."));
            }
        } else {
            Adapter adapter = decl.directAdapter(r);
            if (adapter != null) {
                procedure.execute(graph, adapter);
            } else {
                graph.forPossibleObject(r, ((Layer0)graph.getService(Layer0.class)).InstanceOf, (AsyncProcedure)new AsyncProcedure<Resource>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        procedure.exception(graph, (Throwable)new AdaptionException("Problems in reading types for resource. ", throwable));
                    }

                    public void execute(AsyncReadGraph graph, Resource singleType) {
                        if (singleType != null) {
                            AdaptionService2.this.getSingleTypeAdapter(graph, decl, key, r, singleType, possible, procedure);
                        } else {
                            AdaptionService2.this.getSingleSuperTypeAdapter(graph, decl, key, r, r, possible, procedure);
                        }
                    }
                });
            }
        }
    }

    public <T, C> void adapt(AsyncReadGraph graph, final Resource r, final C context, Class<C> contextClass, Class<T> targetClass, final boolean possible, final AsyncProcedure<T> procedure) {
        this.getAdapter(graph, r, contextClass, targetClass, possible, new AsyncProcedure<Adapter<T, C>>(){

            public void execute(AsyncReadGraph graph, Adapter<T, C> result) {
                if (result == null) {
                    if (possible) {
                        procedure.execute(graph, null);
                    } else {
                        procedure.exception(graph, (Throwable)new AdaptionException("Internal error. getAdapter returned null and possible was false."));
                    }
                } else {
                    result.adapt(graph, r, context, procedure);
                }
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

    public <T, C> T adapt(ReadGraph g, Resource r, C context, Class<C> contextClass, Class<T> targetClass, boolean possible) throws DatabaseException {
        Adapter adapter = this.getAdapter(g, r, context, contextClass, targetClass, possible);
        if (adapter == null) {
            return null;
        }
        return (T)g.syncRequest((graph, procedure) -> adapter.adapt(graph, r, context, procedure));
    }

    private <T, C> Adapter<T, C> getAdapter(ReadGraph g, Resource r, C context, Class<C> contextClass, Class<T> targetClass, boolean possible) throws DatabaseException {
        Pair key = new Pair(targetClass, contextClass);
        AdapterDeclaration decl = (AdapterDeclaration)this.adapters.get((Object)key);
        if (decl == null) {
            if (possible) {
                return null;
            }
            throw new AdaptionException("There are no adapters declared or defined for class " + String.valueOf(targetClass) + ".");
        }
        Adapter adapter = decl.directAdapter(r);
        if (adapter != null) {
            return adapter;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource singleType = g.getPossibleObject(r, L0.InstanceOf);
        if (singleType != null) {
            return this.getSingleTypeAdapter(g, decl, key, r, singleType, possible);
        }
        return this.getSingleSuperTypeAdapter(g, decl, key, r, r, possible);
    }

    private <T, C> void getSingleTypeAdapter(AsyncReadGraph graph, final AdapterDeclaration<T> decl, final Pair<Class<T>, Class<?>> key, final Resource instance, Resource type, final boolean possible, final AsyncProcedure<Adapter<T, C>> procedure) {
        Adapter adapter = (Adapter)decl.typeAdapters.get((Object)type);
        if (adapter != null) {
            procedure.execute(graph, (Object)adapter);
        } else {
            graph.forPossibleObject(type, ((Layer0)graph.getService(Layer0.class)).Inherits, (AsyncProcedure)new AsyncProcedure<Resource>(){

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    procedure.exception(graph, (Throwable)new AdaptionException("Problems in reading super types for resource. ", throwable));
                }

                public void execute(AsyncReadGraph graph, Resource singleSuperType) {
                    if (singleSuperType != null) {
                        AdaptionService2.this.getSingleTypeAdapter(graph, decl, key, instance, singleSuperType, possible, procedure);
                    } else {
                        graph.asyncRequest(new SingleTypeAdapter(decl, key, instance, possible), procedure);
                    }
                }
            });
        }
    }

    private <T, C> Adapter<T, C> getSingleTypeAdapter(ReadGraph graph, AdapterDeclaration<T> decl, Pair<Class<T>, Class<?>> key, Resource instance, Resource type, boolean possible) throws DatabaseException {
        Adapter adapter = (Adapter)decl.typeAdapters.get((Object)type);
        if (adapter != null) {
            return adapter;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource singleSuperType = graph.getPossibleObject(type, L0.Inherits);
        if (singleSuperType != null) {
            return this.getSingleTypeAdapter(graph, decl, key, instance, singleSuperType, possible);
        }
        return (Adapter)graph.syncRequest(new SingleTypeAdapter(decl, key, instance, possible), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    private <T, C> void getSingleSuperTypeAdapter(AsyncReadGraph graph, final AdapterDeclaration<T> decl, final Pair<Class<T>, Class<?>> key, final Resource type, Resource superType, final boolean possible, final AsyncProcedure<Adapter<T, C>> procedure) {
        Adapter adapter = (Adapter)decl.instanceAdapters.get((Object)superType);
        if (adapter != null) {
            procedure.execute(graph, (Object)adapter);
        } else {
            graph.forPossibleObject(superType, ((Layer0)graph.getService(Layer0.class)).Inherits, (AsyncProcedure)new AsyncProcedure<Resource>(){

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    procedure.exception(graph, (Throwable)new AdaptionException("Problems in reading super types for resource. ", throwable));
                }

                public void execute(AsyncReadGraph graph, Resource singleSuperType) {
                    if (singleSuperType != null) {
                        AdaptionService2.this.getSingleSuperTypeAdapter(graph, decl, key, type, singleSuperType, possible, procedure);
                    } else {
                        graph.asyncRequest(new SingleSuperTypeAdapter(decl, key, type, possible), procedure);
                    }
                }
            });
        }
    }

    private <T, C> Adapter<T, C> getSingleSuperTypeAdapter(ReadGraph graph, AdapterDeclaration<T> decl, Pair<Class<T>, Class<?>> key, Resource type, Resource superType, boolean possible) throws DatabaseException {
        Adapter adapter = (Adapter)decl.instanceAdapters.get((Object)superType);
        if (adapter != null) {
            return adapter;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource singleSuperType = graph.getPossibleObject(superType, L0.Inherits);
        if (singleSuperType != null) {
            return this.getSingleSuperTypeAdapter(graph, decl, key, type, singleSuperType, possible);
        }
        return (Adapter)graph.syncRequest(new SingleSuperTypeAdapter(decl, key, type, possible));
    }

    public <T> void adaptNew(final AsyncReadGraph g, final Resource r, final Class<T> clazz, final boolean possible, final AsyncProcedure<T> procedure) {
        g.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Pair key = new Pair((Object)clazz, Resource.class);
                AdapterDeclaration decl = (AdapterDeclaration)AdaptionService2.this.adapters.get((Object)key);
                if (decl == null) {
                    if (possible) {
                        procedure.execute(g, null);
                    } else {
                        procedure.exception(g, (Throwable)new AdaptionException("There are no adapters declared or defined for class " + String.valueOf(clazz) + "."));
                    }
                } else {
                    try {
                        procedure.execute(g, decl.adaptNew(graph, r, possible));
                    }
                    catch (AdaptionException e) {
                        if (possible) {
                            procedure.execute(g, null);
                        } else {
                            procedure.exception(g, (Throwable)e);
                        }
                    }
                    catch (ValidationException e) {
                        procedure.exception(g, (Throwable)e);
                    }
                    catch (DatabaseException e2) {
                        procedure.exception(g, (Throwable)new ServiceException((Throwable)e2));
                    }
                }
            }
        });
    }

    public <T> void addInstanceAdapter(Resource resource, Class<T> targetClass, Adapter<T, ?> adapter) {
        this.addInstanceAdapter(resource, targetClass, Resource.class, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addInstanceAdapter(Resource resource, Class<T> targetClass, Class<?> contextClass, Adapter<T, ?> adapter) {
        AdaptionService2 adaptionService2 = this;
        synchronized (adaptionService2) {
            this.getDeclaration(targetClass, contextClass).instanceAdapters.put((Object)resource, adapter);
        }
    }

    public <T> Adapter<T, ?> removeInstanceAdapter(Resource resource, Class<T> targetClass) {
        return this.removeInstanceAdapter(resource, targetClass, Resource.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Adapter<T, ?> removeInstanceAdapter(Resource resource, Class<T> targetClass, Class<?> contextClass) {
        AdaptionService2 adaptionService2 = this;
        synchronized (adaptionService2) {
            return (Adapter)this.getDeclaration(targetClass, contextClass).instanceAdapters.remove((Object)resource);
        }
    }

    public <T> void removeInstanceAdapter(Resource resource, Class<T> targetClass, Adapter<T, ?> adapter) {
        this.removeInstanceAdapter(resource, targetClass, Resource.class, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void removeInstanceAdapter(Resource resource, Class<T> targetClass, Class<?> contextClass, Adapter<T, ?> adapter) {
        AdaptionService2 adaptionService2 = this;
        synchronized (adaptionService2) {
            AdapterDeclaration<T> decl = this.getDeclaration(targetClass, contextClass);
            Adapter existing = (Adapter)decl.instanceAdapters.get((Object)resource);
            if (existing == adapter) {
                decl.instanceAdapters.remove((Object)resource);
            }
        }
    }

    public <T> void addAdapter(Resource type, Class<T> targetClass, Adapter<T, ?> adapter) {
        this.addAdapter(type, targetClass, Resource.class, adapter);
    }

    public <T> void addAdapter(Resource type, Class<T> targetClass, Class<?> contextClass, Adapter<T, ?> adapter) {
        this.getDeclaration(targetClass, contextClass).typeAdapters.put((Object)type, adapter);
    }

    public <T> void declareAdapter(Resource type, Class<T> targetClass) {
        this.declareAdapter(type, targetClass, Resource.class);
    }

    public <T> void declareAdapter(Resource type, Class<T> targetClass, Class<?> contextClass) {
        this.getDeclaration(targetClass, contextClass).baseTypes.add((Object)type);
    }

    public static String safeName(ReadGraph g, Resource r) throws DatabaseException {
        return NameUtils.getSafeName((ReadGraph)g, (Resource)r, (boolean)true);
    }

    static class AdapterDeclaration<T> {
        Class<T> clazz;
        THashMap<Resource, Adapter<T, ?>> typeAdapters = new THashMap();
        THashMap<Resource, Adapter<T, ?>> instanceAdapters = new THashMap();
        THashSet<Resource> baseTypes = new THashSet();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getDescription(final ReadGraph g) {
            final StringBuilder b = new StringBuilder();
            b.append("The following adapters have been defined for ");
            b.append(this.clazz.getCanonicalName());
            b.append("\n");
            this.typeAdapters.forEachEntry(new TObjectObjectProcedure<Resource, Adapter<T, ?>>(){

                public boolean execute(Resource arg0, Adapter<T, ?> arg1) {
                    b.append("    type ");
                    try {
                        b.append((String)g.syncRequest((Read)new ResourceToPossibleURI(arg0)));
                    }
                    catch (DatabaseException e) {
                        LOGGER.error("Unexpected ResourceToPossibleURI failure", (Throwable)e);
                    }
                    b.append(" : ");
                    b.append(arg1);
                    b.append('\n');
                    return true;
                }
            });
            AdapterDeclaration adapterDeclaration = this;
            synchronized (adapterDeclaration) {
                this.instanceAdapters.forEachEntry(new TObjectObjectProcedure<Resource, Adapter<T, ?>>(){

                    public boolean execute(Resource arg0, Adapter<T, ?> arg1) {
                        b.append("    resource ");
                        try {
                            b.append((String)g.syncRequest((Read)new ResourceToPossibleURI(arg0)));
                        }
                        catch (DatabaseException e) {
                            LOGGER.error("Unexpected ResourceToPossibleURI failure", (Throwable)e);
                        }
                        b.append(" : ");
                        b.append(arg1);
                        b.append('\n');
                        return true;
                    }
                });
            }
            return b.toString();
        }

        public AdapterDeclaration(Class<T> clazz) {
            this.clazz = clazz;
        }

        <C> void inheritedAdapter(AsyncReadGraph graph, Resource type, AsyncProcedure<AdapterResult<T, C>> procedure) {
            graph.asyncRequest(new GetInheritedAdapter(type, this), procedure);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Adapter<T, ?> directAdapter(Resource r) {
            Adapter ret;
            AdapterDeclaration adapterDeclaration = this;
            synchronized (adapterDeclaration) {
                ret = (Adapter)this.instanceAdapters.get((Object)r);
            }
            return ret;
        }

        <C> Adapter<T, C> findAdapter(ReadGraph g, Resource r, boolean possible) throws DatabaseException {
            Adapter result = (Adapter)g.syncRequest(new FindAdapter(r, this));
            if (result != null) {
                return result;
            }
            if (possible) {
                return null;
            }
            for (Resource dt : this.baseTypes) {
                if (!g.isInstanceOf(r, dt)) continue;
                throw new AdaptionException("Couldn't find a " + String.valueOf(this.clazz) + "-adapter for resource " + AdaptionService2.safeName(g, r) + " although it is instance of " + AdaptionService2.safeName(g, dt) + "\n" + this.getDescription(g));
            }
            throw new AdaptionException("Couldn't find a " + String.valueOf(this.clazz) + "-adapter for resource " + AdaptionService2.safeName(g, r) + ". This is because the resource is not instance of any type which the adapter is declared to.\n" + this.getDescription(g));
        }

        <C> T adapt(ReadGraph g, Resource r, C context, boolean possible) throws DatabaseException {
            Object result = g.syncRequest(new Adapt<C>(r, context));
            if (result != null) {
                return (T)result;
            }
            if (possible) {
                return null;
            }
            for (Resource dt : this.baseTypes) {
                if (!g.isInstanceOf(r, dt)) continue;
                throw new AdaptionException("Couldn't find a " + String.valueOf(this.clazz) + "-adapter for resource " + AdaptionService2.safeName(g, r) + " although it is instance of " + AdaptionService2.safeName(g, dt) + "\n" + this.getDescription(g));
            }
            throw new AdaptionException("Couldn't find a " + String.valueOf(this.clazz) + "-adapter for resource " + AdaptionService2.safeName(g, r) + ". This is because the resource is not instance of any type which the adapter is declared to.\n" + this.getDescription(g));
        }

        T adaptNew(ReadGraph g, Resource r, boolean possible) throws DatabaseException {
            Object result = new Adapt<Resource>(r, r).perform(g);
            if (result != null) {
                return result;
            }
            if (possible) {
                return null;
            }
            for (Resource dt : this.baseTypes) {
                if (!g.isInstanceOf(r, dt)) continue;
                throw new AdaptionException("Couldn't find a " + String.valueOf(this.clazz) + "-adapter for resource " + AdaptionService2.safeName(g, r) + " although it is instance of " + AdaptionService2.safeName(g, dt) + "\n" + this.getDescription(g));
            }
            throw new AdaptionException("Couldn't find a " + String.valueOf(this.clazz) + "-adapter for resource " + AdaptionService2.safeName(g, r) + ". This is because the resource is not instance of any type which the adapter is declared to.\n" + this.getDescription(g));
        }

        class Adapt<C>
        implements Read<T> {
            Resource resource;
            C context;

            public Adapt(Resource resource, C context) {
                this.resource = resource;
                this.context = context;
            }

            AdapterDeclaration<T> getDeclaration() {
                return AdapterDeclaration.this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Adapter<T, C> findAdapter(Resource r, ReadGraph g) throws DatabaseException {
                Adapter adapter;
                Adapter adapter2;
                Adapt adapt = this;
                synchronized (adapt) {
                    adapter2 = (Adapter)AdapterDeclaration.this.instanceAdapters.get((Object)r);
                }
                if (adapter2 != null) {
                    return adapter2;
                }
                Layer0 b = Layer0.getInstance((ReadGraph)g);
                AdapterResult adapterResult = null;
                for (Resource t : g.getObjects(r, b.InstanceOf)) {
                    adapter = (Adapter)AdapterDeclaration.this.typeAdapters.get((Object)t);
                    if (adapter != null) {
                        if (adapterResult == null) {
                            adapterResult = new AdapterResult(adapter, t);
                            continue;
                        }
                        if (adapterResult.type.equals(t) || g.isInheritedFrom(adapterResult.type, t)) continue;
                        if (g.isInheritedFrom(t, adapterResult.type)) {
                            adapterResult = new AdapterResult(adapter, t);
                            continue;
                        }
                        throw new AdaptionException("Resource " + AdaptionService2.safeName(g, r) + " has conflicting " + String.valueOf(AdapterDeclaration.this.clazz) + "-adapters from " + AdaptionService2.safeName(g, t) + " and " + AdaptionService2.safeName(g, adapterResult.type));
                    }
                    AdapterResult temp = (AdapterResult)g.syncRequest(new GetInheritedAdapter(t, AdapterDeclaration.this));
                    if (temp == null) continue;
                    if (adapterResult == null) {
                        adapterResult = temp;
                        continue;
                    }
                    if (adapterResult.type.equals(temp.type) || g.isInheritedFrom(adapterResult.type, temp.type)) continue;
                    if (g.isInheritedFrom(temp.type, adapterResult.type)) {
                        adapterResult = temp;
                        continue;
                    }
                    throw new AdaptionException("Resource " + AdaptionService2.safeName(g, r) + " has conflicting " + String.valueOf(AdapterDeclaration.this.clazz) + "-adapters from " + AdaptionService2.safeName(g, temp.type) + " and " + AdaptionService2.safeName(g, adapterResult.type));
                }
                if (adapterResult != null) {
                    return adapterResult.adapter;
                }
                for (Resource t : g.getObjects(r, b.Inherits)) {
                    adapter = this.findAdapter(t, g);
                    if (adapter == null) continue;
                    return adapter;
                }
                for (Resource t : g.getObjects(r, b.SubrelationOf)) {
                    adapter = this.findAdapter(t, g);
                    if (adapter == null) continue;
                    return adapter;
                }
                return null;
            }

            public T perform(ReadGraph g) throws DatabaseException {
                Adapter adapter = this.findAdapter(this.resource, g);
                if (adapter == null) {
                    return null;
                }
                return g.syncRequest((graph, procedure) -> adapter.adapt(graph, this.resource, this.context, procedure));
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null) {
                    return false;
                }
                if (other.getClass() != Adapt.class) {
                    return false;
                }
                return ((Adapt)other).resource.equals(this.resource) && ((Adapt)other).context.equals(this.context) && ((Adapt)other).getDeclaration() == this.getDeclaration();
            }

            public int hashCode() {
                return this.resource.hashCode() + 31 * (this.getClass().hashCode() + 41 * this.context.hashCode() + 71 * this.getDeclaration().hashCode());
            }
        }

        static class AdapterResult<T, C> {
            Adapter<T, C> adapter;
            Resource type;

            public AdapterResult(Adapter<T, C> adapter, Resource type) {
                this.adapter = adapter;
                this.type = type;
            }
        }

        static class FindAdapter<T, C>
        extends BinaryRead<Resource, AdapterDeclaration<T>, Adapter<T, C>> {
            public FindAdapter(Resource resource, AdapterDeclaration<T> decl) {
                super((Object)resource, decl);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Adapter<T, C> findAdapter(Resource r, ReadGraph g) throws DatabaseException {
                Adapter<T, C> adapter;
                Adapter adapter2;
                FindAdapter findAdapter = this;
                synchronized (findAdapter) {
                    adapter2 = (Adapter)((AdapterDeclaration)this.parameter2).instanceAdapters.get((Object)r);
                }
                if (adapter2 != null) {
                    return adapter2;
                }
                Layer0 b = Layer0.getInstance((ReadGraph)g);
                AdapterResult<T, C> adapterResult = null;
                for (Resource t : g.getObjects(r, b.InstanceOf)) {
                    adapter = (Adapter<T, C>)((AdapterDeclaration)this.parameter2).typeAdapters.get((Object)t);
                    if (adapter != null) {
                        if (adapterResult == null) {
                            adapterResult = new AdapterResult<T, C>(adapter, t);
                            continue;
                        }
                        if (adapterResult.type.equals(t) || g.isInheritedFrom(adapterResult.type, t)) continue;
                        if (g.isInheritedFrom(t, adapterResult.type)) {
                            adapterResult = new AdapterResult<T, C>(adapter, t);
                            continue;
                        }
                        throw new AdaptionException("Resource " + AdaptionService2.safeName(g, r) + " has conflicting " + String.valueOf(((AdapterDeclaration)this.parameter2).clazz) + "-adapters from " + AdaptionService2.safeName(g, t) + " and " + AdaptionService2.safeName(g, adapterResult.type));
                    }
                    AdapterResult<T, C> temp = (AdapterResult<T, C>)g.syncRequest(new GetInheritedAdapter(t, (AdapterDeclaration)this.parameter2), (AsyncProcedure)TransientCacheAsyncListener.instance());
                    if (temp == null) continue;
                    if (adapterResult == null) {
                        adapterResult = temp;
                        continue;
                    }
                    if (adapterResult.type.equals(temp.type) || g.isInheritedFrom(adapterResult.type, temp.type)) continue;
                    if (g.isInheritedFrom(temp.type, adapterResult.type)) {
                        adapterResult = temp;
                        continue;
                    }
                    throw new AdaptionException("Resource " + AdaptionService2.safeName(g, r) + " has conflicting " + String.valueOf(((AdapterDeclaration)this.parameter2).clazz) + "-adapters from " + AdaptionService2.safeName(g, temp.type) + " and " + AdaptionService2.safeName(g, adapterResult.type));
                }
                if (adapterResult != null) {
                    return adapterResult.adapter;
                }
                for (Resource t : g.getObjects(r, b.Inherits)) {
                    adapter = this.findAdapter(t, g);
                    if (adapter == null) continue;
                    return adapter;
                }
                for (Resource t : g.getObjects(r, b.SubrelationOf)) {
                    adapter = this.findAdapter(t, g);
                    if (adapter == null) continue;
                    return adapter;
                }
                return null;
            }

            public Adapter<T, C> perform(ReadGraph g) throws DatabaseException {
                return this.findAdapter((Resource)this.parameter, g);
            }
        }

        static class GetInheritedAdapter<T, C>
        extends BinaryRead<Resource, AdapterDeclaration<T>, AdapterResult<T, C>> {
            public GetInheritedAdapter(Resource type, AdapterDeclaration<T> decl) {
                super((Object)type, decl);
            }

            AdapterDeclaration<T> getDeclaration() {
                return (AdapterDeclaration)this.parameter2;
            }

            public String toString() {
                return "GetInheritedAdapter|" + String.valueOf(this.parameter) + "|" + String.valueOf(this.parameter2);
            }

            public AdapterResult<T, C> perform(ReadGraph g) throws DatabaseException {
                Layer0 b = Layer0.getInstance((ReadGraph)g);
                AdapterResult result = null;
                for (Resource supertype : g.getObjects((Resource)this.parameter, b.Inherits)) {
                    Adapter adapter = (Adapter)((AdapterDeclaration)this.parameter2).typeAdapters.get((Object)supertype);
                    if (adapter != null) {
                        if (result == null) {
                            result = new AdapterResult(adapter, supertype);
                            continue;
                        }
                        if (result.type.equals(supertype) || g.isInheritedFrom(result.type, supertype)) continue;
                        if (g.isInheritedFrom(supertype, result.type)) {
                            result = new AdapterResult(adapter, supertype);
                            continue;
                        }
                        throw new AdaptionException("Type " + AdaptionService2.safeName(g, (Resource)this.parameter) + " inherits conflicting adapters from " + AdaptionService2.safeName(g, supertype) + " and " + AdaptionService2.safeName(g, result.type));
                    }
                    AdapterResult temp = (AdapterResult)g.syncRequest(new GetInheritedAdapter<T, C>(supertype, (AdapterDeclaration)this.parameter2), (AsyncProcedure)TransientCacheAsyncListener.instance());
                    if (temp == null) continue;
                    if (result == null) {
                        result = temp;
                        continue;
                    }
                    if (result.type.equals(temp.type) || g.isInheritedFrom(result.type, temp.type)) continue;
                    if (g.isInheritedFrom(temp.type, result.type)) {
                        result = temp;
                        continue;
                    }
                    throw new AdaptionException("Type " + AdaptionService2.safeName(g, (Resource)this.parameter) + " inherits conflicting adapters from " + AdaptionService2.safeName(g, temp.type) + " and " + AdaptionService2.safeName(g, result.type));
                }
                return result;
            }
        }
    }

    private static class SingleSuperTypeAdapter<T, C>
    extends TernaryRead<Pair<Class<T>, Class<?>>, Resource, Boolean, Adapter<T, C>> {
        private final AdapterDeclaration<T> decl;

        SingleSuperTypeAdapter(AdapterDeclaration<T> decl, Pair<Class<T>, Class<?>> key, Resource type, Boolean possible) {
            super(key, (Object)type, (Object)possible);
            this.decl = decl;
        }

        public Adapter<T, C> perform(ReadGraph graph) throws DatabaseException {
            return this.decl.findAdapter(graph, (Resource)this.parameter2, (Boolean)this.parameter3);
        }
    }

    private static class SingleTypeAdapter<T, C>
    extends TernaryRead<Pair<Class<T>, Class<?>>, Resource, Boolean, Adapter<T, C>> {
        private final AdapterDeclaration<T> decl;

        SingleTypeAdapter(AdapterDeclaration<T> decl, Pair<Class<T>, Class<?>> key, Resource instance, Boolean possible) {
            super(key, (Object)instance, (Object)possible);
            this.decl = decl;
        }

        public Adapter<T, C> perform(ReadGraph graph) throws DatabaseException {
            return this.decl.findAdapter(graph, (Resource)this.parameter2, (Boolean)this.parameter3);
        }
    }
}

