/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.IntAllocatorI;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;

final class TableIntArraySet {
    public static final int HeaderSize = 1;
    private static final int SIZE_OFFSET = -1;

    TableIntArraySet() {
    }

    static int create(int[] ints, IntAllocatorI allocator) throws DatabaseException {
        int LENGTH = ints.length * 2;
        if (LENGTH < 1) {
            throw new DatabaseException("Illegal argument to create TableIntArraySet.");
        }
        int newBase = allocator.allocate(LENGTH + 1) + 1;
        int[] table = allocator.getTable();
        table[newBase + -1] = -LENGTH;
        int i = 0;
        while (i < ints.length) {
            if (ints[i] == 0) {
                throw new DatabaseException("Illegal value to create TableIntArraySet.");
            }
            table[newBase + i] = ints[i];
            ++i;
        }
        i = ints.length;
        while (i < LENGTH) {
            table[newBase + i] = 0;
            ++i;
        }
        return newBase;
    }

    static boolean isArraySet(int[] table, int base) {
        return table[base + -1] < 0;
    }

    static Ints getIntsIfValueNotFound(int[] table, int base, int aValue) {
        int REAL_SIZE = -table[base + -1];
        assert (REAL_SIZE > 0);
        Ints it = new Ints();
        int i = 0;
        while (i < REAL_SIZE) {
            if (table[base + i] == 0) break;
            if (aValue == table[base + i]) {
                it.found = true;
                return it;
            }
            ++i;
        }
        int size = i;
        assert (size > 0);
        it.ints = new int[size + 1];
        i = 0;
        while (i < size) {
            it.ints[i] = table[base + i];
            ++i;
        }
        it.ints[i] = aValue;
        return it;
    }

    static int addInt(int[] table, int base, int object, IntAllocatorI allocator) {
        int size = -table[base + -1];
        assert (size > 0);
        int i = 0;
        while (i < size) {
            if (object == table[base + i]) {
                return 0;
            }
            if (table[base + i] == 0) break;
            ++i;
        }
        if (i < size) {
            assert (table[base + i] == 0);
            table[base + i] = object;
            return base;
        }
        int newSize = size + 1;
        int newBase = allocator.allocate(newSize + 1) + 1;
        int[] newTable = allocator.getTable();
        newTable[newBase + -1] = -newSize;
        System.arraycopy(table, base, newTable, newBase, size);
        newTable[newBase + size] = object;
        return newBase;
    }

    static int removeInt(int[] table, int base, int object) {
        int size = -table[base + -1];
        assert (size > 0);
        int i = 0;
        while (i < size) {
            if (object == table[base + i]) break;
            if (table[base + i] == 0) {
                return i;
            }
            ++i;
        }
        if (i == size) {
            return i;
        }
        int end = size - 1;
        while (end > i) {
            if (table[base + end] != 0) break;
            --end;
        }
        table[base + i] = table[base + end];
        table[base + end] = 0;
        return end;
    }

    static int removeIntLast(int[] table, int base) throws DatabaseException {
        int size = TableIntArraySet.getSize(table, base);
        if (size != 1) {
            throw new DatabaseException("Illegal call of TableIntArraySet.removeLastint");
        }
        int t = table[base];
        table[base] = 0;
        return t;
    }

    static int getSize(int[] table, int base) {
        int size = -table[base + -1];
        assert (size > 0);
        int i = 0;
        while (i < size) {
            if (table[base + i] == 0) break;
            ++i;
        }
        return i;
    }

    static int getAllocatedSize(int[] table, int base) {
        int size = -table[base + -1];
        assert (size > 0);
        return size + 1;
    }

    static void foreachInt(int[] table, int base, ReadGraphImpl graph, SyncMultiProcedure<Resource> procedure, Modifier modifier) throws DatabaseException {
        int size = -table[base + -1];
        assert (size > 0);
        int i = 0;
        while (i < size) {
            int pRef = table[base + i];
            if (pRef == 0) break;
            int key = modifier.execute(pRef);
            procedure.execute((ReadGraph)graph, (Object)new ResourceImpl(graph.getResourceSupport(), key));
            ++i;
        }
        procedure.finished((ReadGraph)graph);
    }

    static <C> void foreachInt(int[] table, int base, ReadGraphImpl graph, C context, SyncContextMultiProcedure<C, Resource> procedure, Modifier modifier) throws DatabaseException {
        int size = -table[base + -1];
        assert (size > 0);
        int i = 0;
        while (i < size) {
            int pRef = table[base + i];
            if (pRef == 0) break;
            int key = modifier.execute(pRef);
            procedure.execute((ReadGraph)graph, context, (Object)new ResourceImpl(graph.getResourceSupport(), key));
            ++i;
        }
        procedure.finished((ReadGraph)graph, context);
    }

    static int getSingleInt(int[] table, int base, Modifier modifier) throws DatabaseException {
        int result = 0;
        int size = -table[base + -1];
        assert (size > 0);
        int i = 0;
        while (i < size) {
            int pRef = table[base + i];
            if (pRef == 0) break;
            int key = modifier.execute(pRef);
            result = result == 0 ? key : -1;
            ++i;
        }
        return result;
    }

    static <Context> boolean foreachInt(int[] table, int base, ClusterI.ObjectProcedure<Context> procedure, Context context, Modifier modifier) throws DatabaseException {
        int size = -table[base + -1];
        assert (size > 0);
        int i = 0;
        while (i < size) {
            int pRef = table[base + i];
            if (pRef == 0) break;
            int key = modifier == null ? pRef : modifier.execute(pRef);
            if (procedure.execute(context, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static class Ints {
        int[] ints = null;
        boolean found = false;

        Ints() {
        }
    }
}

