/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ExternalValueException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procore.cluster.BitUtility;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.ClusterTraitsSmall;
import org.simantics.db.procore.cluster.CompleteTable;
import org.simantics.db.procore.cluster.ObjectTable;
import org.simantics.db.procore.cluster.OutOfSpaceException;
import org.simantics.db.procore.cluster.PredicateTable;
import org.simantics.db.procore.cluster.ValueTableSmall;

public final class ResourceElementSmall {
    private static final boolean DEBUG = false;
    private static final int DESCRIPTOR_OFFSET = 0;
    private static final int STM_OFFSET = 1;
    private static final int SIZE_OF = 2;

    static void construct(long[] table, int index) {
        int i = 0 + index;
        table[i++] = 0L;
        table[i++] = 0L;
    }

    static void destruct(long[] table, int index) {
        int i = 0 + index;
        table[i++] = 0L;
        table[i++] = 0L;
    }

    static boolean isUsed(long[] table, int index) {
        int i = 0 + index;
        if (table[i++] != 0L) {
            return true;
        }
        return table[i++] != 0L;
    }

    static int getSizeOf() {
        return 2;
    }

    static ClusterI.CompleteTypeEnum getCompleteType(long[] table, int index) {
        int i = 0 + index;
        byte bits = (byte)BitUtility.getMiddle(table[i], 62, 2);
        return ClusterI.CompleteTypeEnum.make((int)bits);
    }

    static void setCompleteType(long[] table, int index, byte data) {
        int i = 0 + index;
        table[i] = BitUtility.setMiddle(table[i], 62, 2, data);
    }

    static short getCompleteObjectRef(long[] table, int index) {
        int i = 0 + index;
        return (short)BitUtility.getMiddle(table[i], 46, 16);
    }

    static void setCompleteObjectRef(long[] table, int index, int ref) {
        if (ref > 65535) {
            throw new IllegalArgumentException();
        }
        int i = 0 + index;
        table[i] = BitUtility.setMiddle(table[i], 46, 16, ref);
    }

    static boolean completeHasMultiple(long[] table, int index) {
        boolean complete;
        int i = 0 + index;
        int completeRefAndType = BitUtility.getMiddle(table[i], 46, 18);
        boolean bl = complete = completeRefAndType >>> 16 != 0;
        return !complete && completeRefAndType != 0;
    }

    static boolean completeIsFirstStatement(long[] table, int index) {
        int i = 0 + index;
        int completeRefAndType = BitUtility.getMiddle(table[i], 46, 18);
        return completeRefAndType == 0;
    }

    static boolean completeIsSameStatement(long[] table, int index, int refAndType) {
        int i = 0 + index;
        int completeRefAndType = BitUtility.getMiddle(table[i], 46, 18);
        return completeRefAndType == refAndType;
    }

    static int completeGetRefAndType(long[] table, int index) {
        int i = 0 + index;
        return BitUtility.getMiddle(table[i], 46, 18);
    }

    static void completeSetRefAndType(long[] table, int index, int refAndType) {
        int i = 0 + index;
        table[i] = BitUtility.setMiddle(table[i], 46, 18, refAndType);
    }

    static int completeMakeObjectRefAndType(short oRef, ClusterI.CompleteTypeEnum completeType) {
        return oRef & 0xFFFF | completeType.getValue() << 16;
    }

    static short completeGetObjectSetIndex(long[] table, int index) {
        int i = 0 + index;
        return (short)BitUtility.getMiddle(table[i], 46, 16);
    }

    static int completeGetStatementCountApproximation(long[] table, int index) {
        int i = 0 + index;
        int cType = BitUtility.getMiddle(table[i], 62, 2);
        if (cType != 0) {
            return 1;
        }
        int cRef = BitUtility.getMiddle(table[i], 46, 16);
        if (cRef != 0) {
            return 2;
        }
        return 0;
    }

    static int getValueIndex(long[] table, int index) {
        int i = 0 + index;
        int valueIndex = BitUtility.getMiddle(table[i], 24, 22);
        return valueIndex;
    }

    static void setValueIndex(long[] table, int index, int valueIndex) {
        int i = 0 + index;
        table[i] = BitUtility.setMiddle(table[i], 24, 22, valueIndex);
    }

    static int getPredicateIndex(long[] table, int index) {
        int i = 0 + index;
        int predicateIndex = BitUtility.getMiddle(table[i], 0, 24);
        return predicateIndex;
    }

    static void setPredicateIndex(long[] table, int index, int predicateIndex) {
        int i = 0 + index;
        table[i] = BitUtility.setMiddle(table[i], 0, 24, predicateIndex);
    }

    static short getStm1Predicate(long[] table, int index) {
        int i = 1 + index;
        short predicateIndex = BitUtility.getLowShort(table[i]);
        return predicateIndex;
    }

    static void setStm1Predicate(long[] table, int index, short predicateIndex) {
        int i = 1 + index;
        table[i] = BitUtility.setLowShort(table[i], predicateIndex);
    }

    static short getStm1Object(long[] table, int index) {
        int i = 1 + index;
        short objectIndex = (short)BitUtility.getMiddle(table[i], 16, 16);
        return objectIndex;
    }

    static void setStm1Object(long[] table, int index, short objectIndex) {
        int i = 1 + index;
        table[i] = BitUtility.setMiddle(table[i], 16, 16, objectIndex);
    }

    static short getStm2Predicate(long[] table, int index) {
        int i = 1 + index;
        short predicateIndex = (short)BitUtility.getMiddle(table[i], 32, 16);
        return predicateIndex;
    }

    static void setStm2Predicate(long[] table, int index, short predicateIndex) {
        int i = 1 + index;
        table[i] = BitUtility.setMiddle(table[i], 32, 16, predicateIndex);
    }

    static short getStm2Object(long[] table, int index) {
        int i = 1 + index;
        short objectIndex = (short)BitUtility.getMiddle(table[i], 48, 16);
        return objectIndex;
    }

    static void setStm2Object(long[] table, int index, short objectIndex) {
        int i = 1 + index;
        table[i] = BitUtility.setMiddle(table[i], 48, 16, objectIndex);
    }

    public static byte[] getValue(ValueTableSmall valueTable, long[] table, int index) throws DatabaseException {
        int valueIndex = ResourceElementSmall.getValueIndex(table, index);
        if (valueIndex == 0) {
            return null;
        }
        if (0x3FFFFF == valueIndex) {
            throw new ExternalValueException("Value stored externally. index=" + index);
        }
        return valueTable.getValue(valueIndex);
    }

    static boolean hasValue(long[] table, int index) {
        int valueIndex = ResourceElementSmall.getValueIndex(table, index);
        return valueIndex != 0;
    }

    static boolean removeValue(ValueTableSmall valueTable, long[] table, int index) {
        int valueIndex = ResourceElementSmall.getValueIndex(table, index);
        if (valueIndex == 0) {
            return false;
        }
        if (0x3FFFFF != valueIndex) {
            valueTable.removeValue(valueIndex);
        }
        ResourceElementSmall.setValueIndex(table, index, 0);
        return true;
    }

    public static void setValue(ValueTableSmall valueTable, long[] table, int index, byte[] value, int length) throws OutOfSpaceException {
        int oldIndex = ResourceElementSmall.getValueIndex(table, index);
        if (0x3FFFFF == oldIndex) {
            oldIndex = 0;
        }
        if (length > Short.MAX_VALUE) {
            throw new OutOfSpaceException("Out of space for value. size=" + length);
        }
        int newIndex = valueTable.setValue(oldIndex, value, 0, length);
        if (newIndex != oldIndex) {
            if (newIndex > 0x3FFFFF) {
                ResourceElementSmall.setValueIndex(table, index, 0);
                throw new OutOfSpaceException("Out of space for values. index=" + newIndex);
            }
            ResourceElementSmall.setValueIndex(table, index, newIndex);
        }
    }

    public static boolean isValueEx(ValueTableSmall valueTable, long[] table, int index) {
        int vIndex = ResourceElementSmall.getValueIndex(table, index);
        return 0x3FFFFF == vIndex;
    }

    public static void setValueEx(ValueTableSmall valueTable, long[] table, int index) {
        ResourceElementSmall.setValueIndex(table, index, 0x3FFFFF);
    }

    public static <Context> boolean foreachPredicate(long[] table, int index, ClusterI.PredicateProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier, CompleteTable ct) throws DatabaseException {
        int key;
        boolean broken;
        ClusterI.CompleteTypeEnum completeType;
        boolean broken2;
        short completeRef = ResourceElementSmall.getCompleteObjectRef(table, index);
        if (completeRef != 0 && (ResourceElementSmall.completeHasMultiple(table, index) ? (broken2 = ct.foreachPredicate(completeRef, procedure, context, support, modifier)) : ClusterI.CompleteTypeEnum.NotComplete != (completeType = ResourceElementSmall.getCompleteType(table, index)) && (broken = procedure.execute(context, key = ClusterTraitsBase.getCompleteTypeResourceKeyFromEnum((ClusterI.CompleteTypeEnum)completeType), 0)))) {
            return true;
        }
        if (ResourceElementSmall.getPredicateIndex(table, index) != 0) {
            return false;
        }
        int p1 = ResourceElementSmall.getStm1Predicate(table, index);
        if (p1 == 0) {
            return false;
        }
        int externalRef = modifier == null ? p1 : modifier.execute(p1);
        if (procedure.execute(context, externalRef, 0)) {
            return true;
        }
        short p2 = ResourceElementSmall.getStm2Predicate(table, index);
        if (p2 == 0 || p1 == p2) {
            return false;
        }
        externalRef = modifier == null ? (int)p2 : modifier.execute((int)p2);
        return procedure.execute(context, externalRef, 0);
    }

    public static int getSingleObject(long[] table, int index, ClusterSupport support, short pRef, final ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct, Modifier modifier) throws DatabaseException {
        short p2;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            short completeRef = ResourceElementSmall.getCompleteObjectRef(table, index);
            if (completeRef == 0) {
                return 0;
            }
            if (ResourceElementSmall.completeHasMultiple(table, index)) {
                ClusterI.ObjectProcedure<Short> proc = new ClusterI.ObjectProcedure<Short>(){

                    public boolean execute(Short context, int completeRefAndType) throws DatabaseException {
                        ClusterI.CompleteTypeEnum ct = ClusterTraitsSmall.completeRefAndTypeGetType(completeRefAndType);
                        if (ct == pCompleteType) {
                            if (context != 0) {
                                context = 0;
                                return true;
                            }
                            context = ClusterTraitsSmall.completeRefAndTypeGetRef(completeRefAndType);
                        }
                        return true;
                    }
                };
                Short objectRef = 0;
                ct.foreachComplete(completeRef, proc, objectRef, support, modifier);
                return modifier.execute((int)objectRef.shortValue());
            }
            ClusterI.CompleteTypeEnum rCompleteType = ResourceElementSmall.getCompleteType(table, index);
            if (pCompleteType != rCompleteType) {
                return 0;
            }
            return modifier.execute((int)completeRef);
        }
        short p1 = ResourceElementSmall.getStm1Predicate(table, index);
        if (p1 == 0) {
            return 0;
        }
        int result = 0;
        if (pRef == p1) {
            short o1 = ResourceElementSmall.getStm1Object(table, index);
            result = modifier.execute((int)o1);
        }
        if ((p2 = ResourceElementSmall.getStm2Predicate(table, index)) == 0 || pRef != p2) {
            return result;
        }
        if (result != 0) {
            return -1;
        }
        short o2 = ResourceElementSmall.getStm2Object(table, index);
        return modifier.execute((int)o2);
    }

    public static void foreachObject(long[] table, int index, final ReadGraphImpl graph, final SyncMultiProcedure<Resource> procedure, ClusterSupport support, int pRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct, final Modifier modifier) throws DatabaseException {
        short p2;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            short completeRef = ResourceElementSmall.getCompleteObjectRef(table, index);
            if (completeRef == 0) {
                procedure.finished((ReadGraph)graph);
                return;
            }
            if (ResourceElementSmall.completeHasMultiple(table, index)) {
                ClusterI.ObjectProcedure<Object> proc = new ClusterI.ObjectProcedure<Object>(){

                    public boolean execute(Object _context, int objectRef) throws DatabaseException {
                        procedure.execute((ReadGraph)graph, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute(objectRef)));
                        return false;
                    }
                };
                ct.foreachComplete(completeRef, proc, null, support, modifier);
            } else {
                ClusterI.CompleteTypeEnum rCompleteType = ResourceElementSmall.getCompleteType(table, index);
                if (pCompleteType != rCompleteType) {
                    procedure.finished((ReadGraph)graph);
                    return;
                }
                procedure.execute((ReadGraph)graph, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute((int)completeRef)));
            }
            procedure.finished((ReadGraph)graph);
            return;
        }
        short p1 = ResourceElementSmall.getStm1Predicate(table, index);
        if (p1 == 0) {
            procedure.finished((ReadGraph)graph);
            return;
        }
        if (pRef == p1) {
            short o1 = ResourceElementSmall.getStm1Object(table, index);
            procedure.execute((ReadGraph)graph, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute((int)o1)));
        }
        if ((p2 = ResourceElementSmall.getStm2Predicate(table, index)) == 0 || pRef != p2) {
            procedure.finished((ReadGraph)graph);
            return;
        }
        short o2 = ResourceElementSmall.getStm2Object(table, index);
        procedure.execute((ReadGraph)graph, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute((int)o2)));
        procedure.finished((ReadGraph)graph);
    }

    public static <C> void foreachObject(long[] table, int index, final ReadGraphImpl graph, final C context, final SyncContextMultiProcedure<C, Resource> procedure, ClusterSupport support, int pRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct, final Modifier modifier) throws DatabaseException {
        short p2;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            short completeRef = ResourceElementSmall.getCompleteObjectRef(table, index);
            if (completeRef == 0) {
                procedure.finished((ReadGraph)graph, context);
                return;
            }
            if (ResourceElementSmall.completeHasMultiple(table, index)) {
                ClusterI.ObjectProcedure<Object> proc = new ClusterI.ObjectProcedure<Object>(){

                    public boolean execute(Object _context, int objectRef) throws DatabaseException {
                        procedure.execute((ReadGraph)graph, context, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute(objectRef)));
                        return false;
                    }
                };
                ct.foreachComplete(completeRef, proc, null, support, modifier);
            } else {
                ClusterI.CompleteTypeEnum rCompleteType = ResourceElementSmall.getCompleteType(table, index);
                if (pCompleteType != rCompleteType) {
                    procedure.finished((ReadGraph)graph, context);
                    return;
                }
                procedure.execute((ReadGraph)graph, context, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute((int)completeRef)));
            }
            procedure.finished((ReadGraph)graph, context);
            return;
        }
        short p1 = ResourceElementSmall.getStm1Predicate(table, index);
        if (p1 == 0) {
            procedure.finished((ReadGraph)graph, context);
            return;
        }
        if (pRef == p1) {
            short o1 = ResourceElementSmall.getStm1Object(table, index);
            procedure.execute((ReadGraph)graph, context, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute((int)o1)));
        }
        if ((p2 = ResourceElementSmall.getStm2Predicate(table, index)) == 0 || pRef != p2) {
            procedure.finished((ReadGraph)graph, context);
            return;
        }
        short o2 = ResourceElementSmall.getStm2Object(table, index);
        procedure.execute((ReadGraph)graph, context, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute((int)o2)));
        procedure.finished((ReadGraph)graph, context);
    }

    public static <Context> boolean foreachObject(long[] table, int index, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier, short pRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct) throws DatabaseException {
        short p2;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            int completeRef = ResourceElementSmall.getCompleteObjectRef(table, index);
            if (completeRef == 0) {
                return false;
            }
            if (ResourceElementSmall.completeHasMultiple(table, index)) {
                return ct.foreachObject(completeRef, procedure, context, support, modifier, pCompleteType);
            }
            ClusterI.CompleteTypeEnum completeType = ResourceElementSmall.getCompleteType(table, index);
            if (pCompleteType != completeType) {
                return false;
            }
            int externalRef = completeRef;
            if (modifier != null) {
                externalRef = modifier.execute(externalRef);
            }
            return procedure.execute(context, externalRef);
        }
        short p1 = ResourceElementSmall.getStm1Predicate(table, index);
        if (p1 == 0) {
            return false;
        }
        if (pRef == p1) {
            int o1 = ResourceElementSmall.getStm1Object(table, index);
            int externalRef = modifier == null ? o1 : modifier.execute(o1);
            if (procedure.execute(context, externalRef)) {
                return true;
            }
        }
        if ((p2 = ResourceElementSmall.getStm2Predicate(table, index)) == 0 || pRef != p2) {
            return false;
        }
        int o2 = ResourceElementSmall.getStm2Object(table, index);
        int externalRef = modifier == null ? o2 : modifier.execute(o2);
        return procedure.execute(context, externalRef);
    }

    static boolean isEmpty(long[] table, int index) {
        return ResourceElementSmall.getStatementCountApproximation(table, index) == 0 && !ResourceElementSmall.hasValue(table, index);
    }

    static int getStatementCountApproximation(long[] table, int index) {
        int n = ResourceElementSmall.completeGetStatementCountApproximation(table, index);
        short p1 = ResourceElementSmall.getStm1Predicate(table, index);
        if (p1 == 0) {
            return n;
        }
        short p2 = ResourceElementSmall.getStm2Predicate(table, index);
        if (p2 == 0) {
            return n + 1;
        }
        int predicateIndex = ResourceElementSmall.getPredicateIndex(table, index);
        if (predicateIndex == 0) {
            return n + 2;
        }
        return n + 3;
    }

    static int addStatement(long[] table, int index, short pRef, short oRef, PredicateTable pt, ObjectTable ot, ClusterI.CompleteTypeEnum completeType, CompleteTable ct) throws DatabaseException {
        assert (pRef != 0);
        assert (oRef != 0);
        if (ClusterI.CompleteTypeEnum.NotComplete != completeType) {
            int coRefAndType = ResourceElementSmall.completeMakeObjectRefAndType(oRef, completeType);
            if (ResourceElementSmall.completeIsFirstStatement(table, index)) {
                ResourceElementSmall.completeSetRefAndType(table, index, coRefAndType);
            } else {
                int nRef;
                if (ResourceElementSmall.completeIsSameStatement(table, index, coRefAndType)) {
                    return -1;
                }
                if (ResourceElementSmall.completeHasMultiple(table, index)) {
                    int coSetIndex = ResourceElementSmall.completeGetObjectSetIndex(table, index) & 0xFFFF;
                    nRef = ct.addComplete(coSetIndex, coRefAndType);
                    if (nRef == 0) {
                        return -1;
                    }
                    if (nRef >= 65536) {
                        ct.removeComplete(coSetIndex, coRefAndType);
                        throw new OutOfSpaceException("Out of space for complete objects. index=" + nRef);
                    }
                } else {
                    int coRefAndTypeOld = ResourceElementSmall.completeGetRefAndType(table, index);
                    nRef = ct.createCompleteArraySet(coRefAndTypeOld, coRefAndType);
                    if (nRef >= 65536) {
                        throw new OutOfSpaceException("Out of space for complete objects. index=" + nRef);
                    }
                    ResourceElementSmall.setCompleteType(table, index, (byte)0);
                }
                ResourceElementSmall.setCompleteObjectRef(table, index, nRef);
            }
            return 0;
        }
        short p1 = ResourceElementSmall.getStm1Predicate(table, index);
        short o1 = ResourceElementSmall.getStm1Object(table, index);
        if (p1 == 0) {
            ResourceElementSmall.setStm1Predicate(table, index, pRef);
            ResourceElementSmall.setStm1Object(table, index, oRef);
            return 0;
        }
        if (p1 == pRef && o1 == oRef) {
            return -1;
        }
        short p2 = ResourceElementSmall.getStm2Predicate(table, index);
        short o2 = ResourceElementSmall.getStm2Object(table, index);
        if (p2 == 0) {
            ResourceElementSmall.setStm2Predicate(table, index, pRef);
            ResourceElementSmall.setStm2Object(table, index, oRef);
            return 0;
        }
        if (p2 == pRef && o2 == oRef) {
            return -1;
        }
        int predicateIndex = ResourceElementSmall.getPredicateIndex(table, index);
        if (predicateIndex == 0) {
            if (p1 == p2) {
                int objectIndex = ot.createObjectSet(o1 & 0xFFFF, o2 & 0xFFFF);
                assert (objectIndex != 0);
                int[] os = new int[]{ClusterTraits.statementIndexMake(objectIndex)};
                int[] ps = new int[]{p1 & 0xFFFF};
                predicateIndex = pt.createPredicateSet(ps, os);
            } else {
                int[] os = new int[]{o1 & 0xFFFF, o2 & 0xFFFF};
                int[] ps = new int[]{p1 & 0xFFFF, p2 & 0xFFFF};
                predicateIndex = pt.createPredicateSet(ps, os);
            }
            assert (predicateIndex != 0);
            ResourceElementSmall.setPredicateIndex(table, index, predicateIndex);
        }
        assert (predicateIndex != 0);
        return predicateIndex;
    }

    static boolean removeStatement(long[] table, int index, short pRef, short oRef, ClusterI.CompleteTypeEnum completeType, CompleteTable ct) throws DatabaseException {
        assert (pRef != 0);
        assert (oRef != 0);
        if (completeType != ClusterI.CompleteTypeEnum.NotComplete) {
            short completeRef = ResourceElementSmall.getCompleteObjectRef(table, index);
            if (completeRef == 0) {
                return false;
            }
            int refAndType = ResourceElementSmall.completeMakeObjectRefAndType(oRef, completeType);
            if (ResourceElementSmall.completeIsSameStatement(table, index, refAndType)) {
                ResourceElementSmall.completeSetRefAndType(table, index, 0);
                return true;
            }
            if (ResourceElementSmall.completeHasMultiple(table, index)) {
                int newSize;
                int oldSize = ct.getCompleteSetSize(completeRef);
                if (oldSize == (newSize = ct.removeComplete(completeRef, refAndType))) {
                    return false;
                }
                if (newSize == 1) {
                    int cRef = ct.removeLast(completeRef);
                    ResourceElementSmall.completeSetRefAndType(table, index, cRef);
                }
                return true;
            }
            return false;
        }
        short p1 = ResourceElementSmall.getStm1Predicate(table, index);
        short o1 = ResourceElementSmall.getStm1Object(table, index);
        if (p1 == 0) {
            return false;
        }
        short p2 = ResourceElementSmall.getStm2Predicate(table, index);
        short o2 = ResourceElementSmall.getStm2Object(table, index);
        if (p1 == pRef && o1 == oRef) {
            ResourceElementSmall.setStm1Predicate(table, index, p2);
            ResourceElementSmall.setStm1Object(table, index, o2);
            ResourceElementSmall.setStm2Predicate(table, index, (short)0);
            ResourceElementSmall.setStm2Object(table, index, (short)0);
            return true;
        }
        if (p2 == 0) {
            return false;
        }
        if (p2 == pRef && o2 == oRef) {
            ResourceElementSmall.setStm2Predicate(table, index, (short)0);
            ResourceElementSmall.setStm2Object(table, index, (short)0);
            return true;
        }
        return false;
    }
}

