/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import java.util.Arrays;
import org.simantics.db.procore.cluster.Allocator;

class ByteAllocator
extends Allocator {
    private byte[] backup = null;
    private byte[] memory;
    static final int Reserved = 0;
    static final int HeaderSize = 1;

    ByteAllocator releaseMemory() {
        this.backup = null;
        this.memory = null;
        return null;
    }

    ByteAllocator(byte[] bytes, int size) {
        this.memory = bytes;
        this.setSize(size);
    }

    byte[] getBackup() {
        return this.backup;
    }

    byte[] getMemory() {
        return this.memory;
    }

    int getReserved() {
        return this.memory[0];
    }

    void setReserved(byte a) {
        this.memory[0] = a;
    }

    @Override
    int getCapacity() {
        return this.memory.length;
    }

    @Override
    void resizeMemory(int capacity) {
        assert (capacity >= 1);
        assert (this.backup == null);
        this.memory = Arrays.copyOf(this.memory, capacity);
    }

    @Override
    void backupResize(int capacity, int size, int copySize) {
        assert (capacity >= 1);
        assert (capacity >= copySize);
        assert (capacity >= size);
        if (size < 0) {
            size = this.getSize();
        } else if (size < 1) {
            size = 1;
        }
        assert (size <= capacity);
        if (copySize < 0) {
            copySize = size;
        }
        assert (copySize <= size);
        assert (copySize <= this.getSize());
        assert (this.backup == null);
        this.backup = this.memory;
        this.memory = new byte[capacity];
        this.setSize(size);
        System.arraycopy(this.backup, 0, this.memory, 0, copySize);
    }

    @Override
    void backupFree() {
        this.backup = null;
    }

    void dump() {
        int i = 0;
        while (i < this.getSize()) {
            short t = (short)(this.memory[i] & 0xFF);
            System.out.println("bytes[" + i + "]=" + t);
            ++i;
        }
        System.out.println("bytes capacity=" + this.memory.length);
    }
}

