/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterStream;
import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.OperationImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SynchronizeContextI;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.TreeMapBinding;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.Metadata;
import org.simantics.db.Operation;
import org.simantics.db.Session;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.CommitMetadata;
import org.simantics.db.common.MetadataUtils;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.request.WriteTraits;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.TransactionPolicySupport;

public class TransactionToken
implements GraphSession.Listener {
    private boolean DEBUG = false;
    private Session session;
    private GraphSession graphSession;
    private AtomicLong id;
    private long lastChangeSetId;
    private OperationImpl lastOperation = null;
    private Type type;
    private int pending = 0;
    private boolean combine = false;
    static Serializer METADATA_SERIALIZER = Bindings.getSerializerUnchecked((Binding)new TreeMapBinding((Binding)Bindings.STRING, (Binding)Bindings.BYTE_ARRAY));

    TransactionToken(TransactionPolicySupport tps, Session session, GraphSession graphSession, TransactionToken old) {
        this.session = session;
        this.graphSession = graphSession;
        this.type = Type.Null;
        this.id = new AtomicLong();
        this.id.set(0L);
        long firstChangeSetId = graphSession.getFirstChangeSetId();
        this.lastChangeSetId = old != null && old.lastChangeSetId > firstChangeSetId ? old.lastChangeSetId : firstChangeSetId;
        graphSession.setListener(this);
    }

    void startReadTransaction(int thread) throws DatabaseException {
        if (this.DEBUG) {
            System.out.println("DEBUG: Start read transaction " + String.valueOf(this.graphSession));
        }
        if (Type.Null == this.type) {
            this.id.set(this.graphSession.askReadTransaction(thread));
            if (this.DEBUG && ++this.pending != 1) {
                System.out.println("kraa: read beg pending=" + this.pending);
            }
            this.type = Type.Read;
        }
    }

    void stopReadTransaction() throws DatabaseException {
        if (this.DEBUG) {
            System.out.println("DEBUG: Stop read transaction " + String.valueOf(this.graphSession));
        }
        if (Type.Null == this.type) {
            return;
        }
        this.endTransaction(false);
        if (this.DEBUG && --this.pending != 0) {
            System.out.println("kraa: read end pending=" + this.pending);
        }
    }

    void startWriteTransaction(int thread) throws DatabaseException {
        if (this.DEBUG) {
            System.out.println("DEBUG: Start write transaction " + String.valueOf(this.graphSession));
        }
        if (Type.Null == this.type) {
            this.id.set(this.graphSession.askWriteTransaction(thread, 0L));
            if (this.DEBUG && ++this.pending != 1) {
                System.out.println("kraa: write beg pending=" + this.pending);
            }
        } else if (Type.Read == this.type) {
            this.id.set(this.graphSession.askWriteTransaction(thread, this.id.get()));
            if (this.DEBUG && ++this.pending != 1) {
                System.out.println("kraa: write beg pending=" + this.pending);
            }
        }
        this.type = Type.Write;
    }

    void cancelBegin(WriteSupport writeSupport, SynchronizeContextI context, ClusterStream clusterStream) throws DatabaseException {
        if (this.DEBUG) {
            System.out.println("DEBUG: CancelBegin " + String.valueOf(this.graphSession));
        }
        if (Type.Null == this.type) {
            return;
        }
        if (Type.Read == this.type) {
            throw new ValidationException("Illegal token type.");
        }
        TreeMap metadata = writeSupport.getMetadata();
        boolean empty = clusterStream.reallyFlush();
        if (empty) {
            boolean noMetadata;
            boolean bl = noMetadata = !this.hasMetadata(metadata);
            if (noMetadata) {
                return;
            }
        }
        byte[] data = this.makeContext(null, metadata);
        this.graphSession.cancelCommit(this.id.get(), this.lastChangeSetId, data, context);
        ++this.lastChangeSetId;
        if (this.DEBUG) {
            System.out.println("DEBUG: CancelBegin cancelled cs=" + this.lastChangeSetId);
        }
        clusterStream.accept();
        writeSupport.commitDone(null, this.lastChangeSetId);
    }

    void cancelEnd(WriteSupport writeSupport, WriteTraits writeTraits, ClusterStream clusterStream) throws DatabaseException {
        if (clusterStream.reallyFlush()) {
            return;
        }
        TreeMap metadata = writeSupport.getMetadata();
        byte[] data = this.makeContext(null, metadata);
        this.graphSession.acceptCommit(this.id.get(), this.lastChangeSetId, data);
        ++this.lastChangeSetId;
        if (this.DEBUG) {
            System.out.println("DEBUG CancelEnd accepted commit cs=" + this.lastChangeSetId);
        }
        clusterStream.accept();
        writeSupport.commitDone(writeTraits, this.lastChangeSetId);
    }

    void setCombine(boolean a) {
        this.combine = a;
    }

    private boolean hasMetadata(TreeMap<String, byte[]> metadata) {
        if (metadata == null) {
            return false;
        }
        if (metadata.size() == 0) {
            return false;
        }
        return metadata.size() != 1 || !MetadataUtils.hasMetadata(metadata, CommentMetadata.class);
    }

    void commitWriteTransaction(WriteSupport writeSupport, WriteTraits writeTraits, ClusterStream clusterStream, Operation dummy) throws DatabaseException {
        CommentMetadata cm;
        if (this.DEBUG) {
            System.out.println("DEBUG: Commit write transaction " + String.valueOf(this.graphSession));
        }
        if (Type.Null == this.type) {
            return;
        }
        if (Type.Read == this.type) {
            throw new ValidationException("Illegal transaction type.");
        }
        if (this.id.get() == 0L) {
            throw new ValidationException("Illegal transaction id.");
        }
        TreeMap metadata = writeSupport.getMetadata();
        boolean empty = clusterStream.reallyFlush();
        if (empty) {
            boolean noMetadata;
            boolean bl = noMetadata = !this.hasMetadata(metadata);
            if (noMetadata) {
                List ext = this.graphSession.undoContext.getPendingExternals();
                if (!ext.isEmpty()) {
                    CommentMetadata cm2 = (CommentMetadata)writeSupport.getMetadata(CommentMetadata.class);
                    writeSupport.addMetadata((Metadata)cm2.add("Automatically generated comment for empty commit with external undo operation(s)."));
                    metadata = writeSupport.getMetadata();
                    Logger.defaultLogError((String)"A generated comment was added into a commit with only some external undo operation(s).");
                } else {
                    this.graphSession.undoContext.cancelCommit();
                    return;
                }
            }
        }
        if ((cm = (CommentMetadata)writeSupport.getMetadata(CommentMetadata.class)).size() == 0) {
            writeSupport.addMetadata((Metadata)cm.add(writeTraits.toString()));
        }
        metadata = writeSupport.getMetadata();
        OperationImpl op = this.combine ? this.lastOperation : null;
        this.combine = true;
        byte[] data = this.makeContext(op, metadata);
        this.graphSession.acceptCommit(this.id.get(), this.lastChangeSetId, data);
        ++this.lastChangeSetId;
        if (this.DEBUG) {
            System.out.println("DEBUG Accpeted commit cs=" + this.lastChangeSetId);
        }
        clusterStream.accept();
        writeSupport.commitDone(writeTraits, this.lastChangeSetId);
        long opid = op == null ? this.lastChangeSetId : op.getId();
        this.lastOperation = new OperationImpl(opid, this.lastChangeSetId, this.graphSession.undoContext.getPendingExternals());
        this.graphSession.undoContext.commitOk((Operation)this.lastOperation);
        if (this.DEBUG) {
            System.out.println("DEBUG: Accepted operation id=" + this.lastOperation.getId() + " cs=" + this.lastOperation.getCSId() + ".");
        }
    }

    void stopWriteTransaction() throws DatabaseException {
        if (this.DEBUG) {
            System.out.println("DEBUG: Stop write transaction begin " + String.valueOf(this.graphSession));
        }
        if (Type.Null == this.type) {
            return;
        }
        if (Type.Read == this.type) {
            throw new ValidationException("Illegal transaction type.");
        }
        this.graphSession.undoContext.cancelCommit();
        this.endTransaction(true);
        if (this.DEBUG && --this.pending != 0) {
            System.out.println("kraa: write end pending=" + this.pending);
        }
        if (this.DEBUG) {
            System.out.println("DEBUG: Stop write transaction end " + String.valueOf(this.graphSession));
        }
    }

    void closing() throws DatabaseException {
        if (Type.Null == this.type || this.id.get() == 0L) {
            return;
        }
        this.endTransaction(true);
        if (this.DEBUG && --this.pending != 0) {
            System.out.println("kraa: closing pending=" + this.pending);
        }
    }

    void close() {
        block4: {
            if (this.id.get() != 0L) {
                try {
                    this.endTransaction(true);
                    if (this.DEBUG && --this.pending != 0) {
                        System.out.println("kraa: closing pending=" + this.pending);
                    }
                }
                catch (DatabaseException e) {
                    if (!this.DEBUG) break block4;
                    System.out.println("Close did not finish cleanly.");
                    e.printStackTrace();
                }
            }
        }
    }

    public Operation getLastOperation() {
        return this.lastOperation;
    }

    public long getHeadRevisionId() {
        return this.lastChangeSetId;
    }

    private byte[] makeContext(Operation op, TreeMap<String, byte[]> properties) {
        if (properties == null) {
            properties = new TreeMap();
        }
        long csid = op != null ? op.getId() : 0L;
        properties.put(CommitMetadata.class.getName(), new CommitMetadata(csid).serialise(this.session));
        properties.put("opid", Long.toString(csid).getBytes());
        try {
            return METADATA_SERIALIZER.serialize(properties);
        }
        catch (SerializationException e) {
            e.printStackTrace();
            return new byte[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTransaction(boolean write) throws DatabaseException {
        if (this.DEBUG) {
            System.out.println("DEBUG: TransactionToken.end begin " + String.valueOf(this.graphSession));
        }
        try {
            this.graphSession.endTransaction(this.id.get(), write);
        }
        catch (Throwable throwable) {
            this.type = Type.Null;
            this.id.set(0L);
            TransactionToken transactionToken = this;
            synchronized (transactionToken) {
                this.notify();
            }
            throw throwable;
        }
        this.type = Type.Null;
        this.id.set(0L);
        TransactionToken transactionToken = this;
        synchronized (transactionToken) {
            this.notify();
        }
        if (this.DEBUG) {
            System.out.println("DEBUG: TransactionToken.end end " + String.valueOf(this.graphSession));
        }
    }

    private void updateLastChangeSetId(long csid) {
        if (this.DEBUG) {
            System.out.println("DEBUG: TransactionToken: Update last cs=" + this.lastChangeSetId + " new=" + csid + " " + String.valueOf(this.graphSession) + " " + String.valueOf(this));
        }
        if (this.lastChangeSetId > csid) {
            return;
        }
        this.lastChangeSetId = csid;
    }

    public static void testEmpty() {
        double totalTime = 0.0;
        int j = 0;
        while (j < 20) {
            long start = System.nanoTime();
            int i = 0;
            while (i < 500) {
                ++i;
            }
            long end = System.nanoTime();
            double time = (double)(end - start) * 1.0E-9;
            totalTime += time;
            ++j;
        }
        double speed = 10000.0 / totalTime;
        String t = "Speed was " + speed + " ops per second.";
        System.out.println(t);
    }

    @Override
    public void onChangeSetId(int thread, long csid, boolean refresh) {
        long ocsid = this.lastChangeSetId;
        this.updateLastChangeSetId(csid);
        if (refresh && csid > ocsid && this.id.get() == 0L) {
            this.refresh(thread, ocsid);
        }
    }

    private void refresh(int thread, long csid) {
        try {
            if (this.session instanceof SessionImplSocket) {
                ClusterUID[] clusterUID = this.graphSession.getRefresh2(csid);
                ((SessionImplSocket)this.session).refresh(thread, clusterUID, csid);
            }
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    static enum Type {
        Null,
        Read,
        Write;

    }
}

