/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClientChangesImpl;
import fi.vtt.simantics.procore.internal.ClusterCollector;
import fi.vtt.simantics.procore.internal.ClusterCollectorSupport;
import fi.vtt.simantics.procore.internal.ClusterCollectorSupportImpl;
import fi.vtt.simantics.procore.internal.ClusterControlImpl;
import fi.vtt.simantics.procore.internal.ClusterWriteOnly;
import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.WriteState;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.simantics.db.ClusterCreator;
import org.simantics.db.Database;
import org.simantics.db.exception.ClusterDoesNotExistException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ClusterTranslator;
import org.simantics.db.impl.IClusterTable;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procore.cluster.ClusterBig;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterSmall;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.service.ClusterCollectorPolicy;
import org.simantics.db.service.ClusterUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterTable
implements IClusterTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTable.class);
    private static final boolean VALIDATE_SIZE = false;
    private static final byte IMMUTABLE_DONTKNOW = 0;
    private static final byte IMMUTABLE_FALSE = 1;
    private static final byte IMMUTABLE_TRUE = 2;
    int maximumBytes = 0x8000000;
    int limit = (int)(0.8 * (double)this.maximumBytes);
    private final AtomicLong timeCounter = new AtomicLong(1L);
    private final SessionImplSocket sessionImpl;
    private final ArrayList<ClusterI> writeOnlyClusters = new ArrayList();
    private final TIntHashSet writeOnlyInvalidates = new TIntHashSet();
    private static final int ARRAY_SIZE = ClusterTraits.getClusterArraySize();
    private final ClusterImpl[] clusterArray = new ClusterImpl[ARRAY_SIZE];
    private final byte[] immutables = new byte[ARRAY_SIZE];
    private final boolean[] virtuals = new boolean[ARRAY_SIZE];
    private ClusterCollectorPolicy collectorPolicy;
    private boolean dirtySizeInBytes = true;
    private long sizeInBytes = 0L;
    private final Clusters clusters;
    private SizeProcedure sizeProcedure = new SizeProcedure();
    private ClusterCollectorSupport collectorSupport = new ClusterCollectorSupportImpl(this);
    ClusterCollectorImpl collector = new ClusterCollectorImpl(this.collectorSupport);
    private long newResourceClusterId = -1L;
    public static final int CLUSTER_FILL_SIZE = ClusterTraitsBase.getMaxNumberOfResources();
    int counter = 0;
    static long loadTime = 0L;
    TLongIntHashMap clusterLoadHistogram = new TLongIntHashMap();
    int clusterLoadCounter = 0;
    Map<Long, ClusterImpl> prefetch = new HashMap<Long, ClusterImpl>();

    ClusterUID makeClusterUID(long clusterId) {
        return this.clusters.makeClusterUID(clusterId);
    }

    public ClusterUID getClusterUIDByResourceKey(int resourceKey) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        return this.clusterArray[clusterKey].clusterUID;
    }

    ClusterTable(SessionImplSocket sessionImpl, File folderPath) {
        this.sessionImpl = sessionImpl;
        this.clusters = new Clusters();
    }

    void dispose() {
        this.clusters.clear();
    }

    public void setCollectorPolicy(ClusterCollectorPolicy policy) {
        this.collectorPolicy = policy;
    }

    private void setAllocateSize(double percentage) {
        percentage = Math.max(percentage, 0.05);
        percentage = Math.min(percentage, 0.5);
        this.maximumBytes = (int)Math.floor(percentage * (double)Runtime.getRuntime().maxMemory());
    }

    private double estimateProperAllocation(ClusterCollectorSupport support) {
        long max = Runtime.getRuntime().maxMemory();
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long realFree = max - total + free;
        long current = support.getCurrentSize();
        long inUseTotal = max - realFree;
        long inUseOther = inUseTotal - current;
        double otherUsePercentage = (double)inUseOther / (double)max;
        double aimFree = 0.2;
        double estimate = 1.0 - otherUsePercentage - aimFree;
        estimate = Math.min(estimate, 0.5);
        estimate = Math.max(estimate, 0.05);
        return estimate;
    }

    void checkCollect() {
        this.collector.collect();
    }

    synchronized ClusterImpl getClusterByClusterId(long clusterId) {
        return this.clusters.getClusterByClusterId(clusterId);
    }

    ClusterBase getClusterByClusterKey(int clusterKey) {
        return this.clusterArray[clusterKey];
    }

    synchronized ClusterImpl makeProxy(ClusterUID clusterUID, long clusterId) {
        if (clusterUID.second != clusterId) {
            throw new RuntimeDatabaseException("Illegal id for cluster=" + String.valueOf(clusterUID) + " id=" + clusterId);
        }
        return this.clusters.makeProxy(clusterUID);
    }

    synchronized ClusterImpl makeCluster(long clusterId, boolean writeOnly) {
        this.checkCollect();
        ClusterImpl proxy = this.clusters.getClusterByClusterId(clusterId);
        if (proxy != null) {
            return proxy;
        }
        ClusterUID clusterUID = ClusterUID.make((long)0L, (long)clusterId);
        int clusterKey = this.clusters.nextIndex();
        if (writeOnly) {
            proxy = new ClusterWriteOnly(clusterUID, clusterKey, this.sessionImpl);
            this.writeOnlyClusters.add((ClusterI)proxy);
            return this.clusters.create(proxy);
        }
        ClusterImpl cluster = ClusterImpl.make(clusterUID, clusterKey, (ClusterSupport)this.sessionImpl.clusterTranslator);
        this.clusters.create(cluster);
        if (!cluster.isLoaded()) {
            LOGGER.error("", (Throwable)new Exception("Bug in ClusterTable.makeCluster(long, boolean), cluster not loaded"));
        }
        this.clusters.registerImportance(cluster);
        if (this.collectorPolicy != null) {
            this.collectorPolicy.added((ClusterCollectorPolicy.CollectorCluster)cluster);
        }
        return cluster;
    }

    synchronized void replaceCluster(ClusterI cluster_) {
        ClusterImpl cluster = (ClusterImpl)cluster_;
        this.checkCollect();
        int clusterKey = cluster.getClusterKey();
        ClusterImpl existing = this.clusterArray[clusterKey];
        if (existing.hasVirtual()) {
            cluster.markVirtual();
        }
        if (existing.cc != null) {
            if (existing.isLoaded()) {
                new Exception("Trying to replace cluster with pending changes " + String.valueOf(existing.getClusterUID())).printStackTrace();
            } else {
                cluster.cc = existing.cc;
                cluster.cc.adopt(cluster);
                cluster.foreignLookup = existing.foreignLookup;
                cluster.change = existing.change;
            }
        }
        this.clusters.removeImportance(existing);
        if (this.collectorPolicy != null) {
            this.collectorPolicy.removed((ClusterCollectorPolicy.CollectorCluster)existing);
        }
        this.clusters.replace(cluster);
        if (!cluster.isLoaded()) {
            LOGGER.error("", (Throwable)new Exception("Bug in ClusterTable.replaceCluster(ClusterI), cluster not loaded"));
        }
        this.clusters.registerImportance(cluster);
        if (this.collectorPolicy != null) {
            this.collectorPolicy.added((ClusterCollectorPolicy.CollectorCluster)cluster);
        }
        if (!this.dirtySizeInBytes) {
            if (existing != cluster) {
                this.adjustCachedSize(-existing.getCachedSize(), (ClusterI)existing);
            }
            cluster.getCachedSize();
        }
    }

    synchronized void release(ClusterCollectorPolicy.CollectorCluster cluster) {
        this.release(cluster.getClusterId());
    }

    synchronized void release(long clusterId) {
        ClusterImpl clusterImpl = this.clusters.getClusterByClusterId(clusterId);
        if (clusterImpl == null) {
            return;
        }
        this.clusters.removeImportance(clusterImpl);
        if (!clusterImpl.isLoaded() || clusterImpl.isEmpty()) {
            return;
        }
        this.clusters.freeProxy(clusterImpl);
        if (this.collectorPolicy != null) {
            this.collectorPolicy.removed((ClusterCollectorPolicy.CollectorCluster)clusterImpl);
        }
        if (this.sessionImpl.writeState != null) {
            this.sessionImpl.clusterStream.flush(clusterImpl.clusterUID);
        }
        if (!this.dirtySizeInBytes) {
            this.adjustCachedSize(-clusterImpl.getCachedSize(), (ClusterI)clusterImpl);
        }
    }

    synchronized void compact(long id) {
        ClusterImpl impl = this.clusters.getClusterByClusterId(id);
        if (impl != null) {
            impl.compact();
        }
    }

    void updateSize() {
    }

    double getLoadProbability() {
        return 1.0;
    }

    long getSizeInBytes() {
        if (this.dirtySizeInBytes) {
            this.sizeProcedure.clear();
            this.clusters.forEachValue(this.sizeProcedure);
            this.sizeInBytes = this.sizeProcedure.result;
            this.setDirtySizeInBytes(false);
        }
        return this.sizeInBytes;
    }

    public void setDirtySizeInBytes(boolean value) {
        this.dirtySizeInBytes = value;
    }

    ClusterControlImpl.ClusterStateImpl getState() {
        final ClusterControlImpl.ClusterStateImpl result = new ClusterControlImpl.ClusterStateImpl();
        this.clusters.forEachEntry(new TLongObjectProcedure<ClusterImpl>(){

            public boolean execute(long arg0, ClusterImpl arg1) {
                if (arg1 == null) {
                    return true;
                }
                if (arg1.isLoaded() && !arg1.isEmpty()) {
                    result.ids.add(new ImportanceEntry(arg1));
                }
                return true;
            }
        });
        return result;
    }

    void restoreState(ClusterControlImpl.ClusterStateImpl state) {
        ClusterControlImpl.ClusterStateImpl current = this.getState();
        for (ClusterCollectorPolicy.CollectorCluster id : current.ids) {
            if (state.ids.contains(id)) continue;
            this.collectorSupport.release(id);
        }
    }

    void gc() {
        this.collector.collect();
    }

    ClusterImpl getNewResourceCluster(ClusterSupport cs, GraphSession graphSession, boolean writeOnly) throws DatabaseException {
        ClusterImpl result = null;
        if (-1L == this.newResourceClusterId) {
            this.newResourceClusterId = graphSession.newClusterId();
            result = this.getClusterByClusterIdOrMake(this.newResourceClusterId, writeOnly);
        } else {
            ClusterImpl cluster = this.getClusterByClusterIdOrThrow(this.newResourceClusterId);
            if (cluster.getNumberOfResources(cs) >= CLUSTER_FILL_SIZE) {
                this.newResourceClusterId = graphSession.newClusterId();
                cluster = this.getClusterByClusterIdOrMake(this.newResourceClusterId, writeOnly);
            }
            result = cluster;
        }
        return this.ensureLoaded(result);
    }

    void flushCluster(GraphSession graphSession) {
        this.newResourceClusterId = -1L;
    }

    void writeOnlyInvalidate(ClusterI impl) {
        this.writeOnlyInvalidates.add(impl.getClusterKey());
    }

    void removeWriteOnlyClusters() {
        for (ClusterI proxy : this.writeOnlyClusters) {
            if (!(proxy instanceof ClusterImpl)) {
                throw new RuntimeDatabaseException("ClusterTable corrupted.");
            }
            this.clusters.freeProxy((ClusterImpl)proxy);
        }
        this.writeOnlyClusters.clear();
        this.writeOnlyInvalidates.forEach(new TIntProcedure(){

            public boolean execute(int clusterKey) {
                ClusterImpl proxy = ClusterTable.this.clusterArray[clusterKey];
                ClusterTable.this.clusters.removeImportance(proxy);
                ClusterTable.this.clusters.freeProxy(proxy);
                return true;
            }
        });
        this.writeOnlyInvalidates.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterImpl getClusterByClusterUID(ClusterUID clusterUID) {
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            return this.clusters.getClusterByClusterUID(clusterUID);
        }
    }

    public int getClusterKeyByClusterUIDOrMakeProxy(ClusterUID clusterUID) {
        return this.getClusterKeyByClusterUIDOrMakeProxy(0L, clusterUID.second);
    }

    public int getClusterKeyByClusterUIDOrMakeProxy(long id1, long id2) {
        return this.getClusterByClusterUIDOrMakeProxy((long)id1, (long)id2).clusterKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterImpl getClusterByClusterUIDOrMakeProxy(ClusterUID clusterUID) {
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            ClusterImpl clusterImpl = this.clusters.getClusterByClusterUID(clusterUID);
            if (clusterImpl == null) {
                clusterImpl = this.clusters.makeProxy(clusterUID);
            }
            return clusterImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterImpl getClusterByClusterUIDOrMakeProxy(long id1, long id2) {
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            ClusterImpl clusterImpl = this.clusters.getClusterByClusterUID(id1, id2);
            if (clusterImpl == null) {
                clusterImpl = this.clusters.makeProxy(id2);
            }
            return clusterImpl;
        }
    }

    ClusterImpl getLoadOrThrow(long clusterId) throws DatabaseException {
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            ClusterImpl proxy = this.clusters.getClusterByClusterId(clusterId);
            int clusterKey = 0;
            if (proxy != null) {
                if (proxy.isLoaded()) {
                    return proxy;
                }
                clusterKey = proxy.getClusterKey();
            }
            try {
                ClusterImpl ci;
                if (clusterKey == 0) {
                    proxy = this.clusters.makeProxy(clusterId);
                    clusterKey = proxy.getClusterKey();
                }
                if ((ci = this.tryLoad(clusterId, clusterKey)) == null) {
                    throw new ResourceNotFoundException(clusterId);
                }
                return ci;
            }
            catch (ClusterDoesNotExistException t) {
                this.clusters.removeProxy(proxy);
                throw t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterImpl getClusterByClusterIdOrMake(long clusterId, boolean writeOnly) {
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            ClusterImpl proxy = this.clusters.getClusterByClusterId(clusterId);
            if (proxy != null) {
                return proxy;
            }
            return this.makeCluster(clusterId, writeOnly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterImpl getClusterByClusterIdOrThrow(long clusterId) {
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            ClusterImpl proxy = this.clusters.getClusterByClusterId(clusterId);
            if (proxy == null) {
                throw new IllegalArgumentException("Cluster id=" + clusterId + " is not created.");
            }
            return proxy;
        }
    }

    long getClusterIdOrCreate(ClusterUID clusterUID) {
        return clusterUID.second;
    }

    final long getClusterIdByResourceKey(int resourceKey) throws DatabaseException {
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKey((int)resourceKey);
        if (ClusterTraitsBase.isVirtualClusterKey((int)clusterKey)) {
            throw new RuntimeException("Tried to get a persistent cluster for a virtual resource.");
        }
        ClusterImpl c = this.clusterArray[clusterKey];
        if (c == null) {
            throw new RuntimeException("No cluster for key " + resourceKey);
        }
        return c.getClusterId();
    }

    final long getClusterIdByResourceKeyNoThrow(int resourceKey) {
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (ClusterTraitsBase.isVirtualClusterKey((int)clusterKey)) {
            LOGGER.error("Tried to get a persistent cluster for a virtual resource. key=" + resourceKey);
            return 0L;
        }
        ClusterImpl c = this.clusterArray[clusterKey];
        if (c == null) {
            LOGGER.debug("No cluster for resource key {}, clusterKey {}", new Object[]{resourceKey, clusterKey, new Exception()});
            return 0L;
        }
        return c.getClusterId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(long csid, SessionImplSocket session, ClusterUID[] clusterUID) {
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            session.flushCounter = 0;
            session.clusterStream.reallyFlush();
            ClientChangesImpl cs = new ClientChangesImpl(session);
            if (session.clientChanges == null) {
                session.clientChanges = cs;
            }
            int i = 0;
            while (i < clusterUID.length) {
                try {
                    int clusterKey;
                    ClusterImpl oldCluster = this.clusters.getClusterByClusterUID(clusterUID[i]);
                    if (oldCluster != null && oldCluster.isLoaded() && !ClusterTraitsBase.isVirtualClusterKey((int)(clusterKey = oldCluster.getClusterKey()))) {
                        Database.Session dbSession;
                        ClusterImpl newCluster;
                        boolean big = oldCluster instanceof ClusterBig;
                        boolean small = oldCluster instanceof ClusterSmall;
                        if ((big || small) && (newCluster = (ClusterImpl)((Object)(dbSession = this.sessionImpl.graphSession.dbSession).clone(clusterUID[i], new ClusterCreator(){

                            public <T> T create(ClusterUID uid, byte[] bytes, int[] ints, long[] longs) {
                                ClusterTranslator support = ClusterTable.this.sessionImpl.clusterTranslator;
                                try {
                                    return (T)((Object)ClusterImpl.make(longs, ints, bytes, (ClusterSupport)support, support.getClusterKeyByClusterUIDOrMake(uid)));
                                }
                                catch (DatabaseException e) {
                                    e.printStackTrace();
                                    return null;
                                }
                            }
                        }))) != null) {
                            this.clusters.removeImportance(oldCluster);
                            if (this.collectorPolicy != null) {
                                this.collectorPolicy.removed((ClusterCollectorPolicy.CollectorCluster)oldCluster);
                            }
                            this.clusters.replace(newCluster);
                            if (!newCluster.isLoaded()) {
                                LOGGER.error("", (Throwable)new Exception("Bug in ClusterTable.refresh, cluster not loaded"));
                            }
                            this.clusters.registerImportance(newCluster);
                            if (this.collectorPolicy != null) {
                                this.collectorPolicy.added((ClusterCollectorPolicy.CollectorCluster)newCluster);
                            }
                            this.refreshCluster(csid, session, oldCluster, clusterUID[i], newCluster.clusterId, clusterKey);
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to load cluster in refresh.", t);
                }
                ++i;
            }
            QueryProcessor queryProcessor = session.getQueryProvider2();
            WriteGraphImpl writer = WriteGraphImpl.create((QueryProcessor)queryProcessor, (WriteSupport)session.writeSupport, null);
            SessionImplSocket.TaskHelper th = null;
            if (session.writeState == null) {
                th = new SessionImplSocket.TaskHelper("Refresh");
                session.writeState = new WriteState<Object>(writer, th.writeTraits, th.sema, th.proc);
                try {
                    session.getQueryProvider2().propagateChangesInQueryCache((ReadGraphImpl)writer);
                    session.fireMetadataListeners(writer, cs);
                    session.getQueryProvider2().listening.fireListeners((ReadGraphImpl)writer);
                    session.fireReactionsToSynchronize(cs);
                    session.fireSessionVariableChange("writes");
                    session.printDiagnostics();
                }
                finally {
                    if (th != null) {
                        session.writeState = null;
                    }
                    cs.dispose();
                }
            }
        }
    }

    final void refreshCluster(long csid, SessionImplSocket session, ClusterImpl cluster, ClusterUID clusterUID, long clusterId, int clusterKey) throws DatabaseException {
        int resource;
        Database.Session.ClusterChanges cc;
        QueryProcessor queryProcessor = session.getQueryProvider2();
        try {
            cc = session.graphSession.getClusterChanges(clusterUID, csid);
        }
        catch (Exception e) {
            LOGGER.error("Could not get cluster changes. cluster=" + String.valueOf(clusterUID), (Throwable)e);
            this.release(clusterId);
            return;
        }
        int i = 0;
        while (i < cc.getResourceIndex().length) {
            resource = ClusterTraits.createResourceKey((int)clusterKey, (int)cc.getResourceIndex()[i]);
            ClusterUID pClusterUID = new ClusterUID(cc.getPredicateFirst()[i], cc.getPredicateSecond()[i]);
            ClusterImpl pCluster = this.clusters.getClusterByClusterUID(pClusterUID);
            if (pCluster != null) {
                int pClusterKey = pCluster.getClusterKey();
                int predicate = ClusterTraits.createResourceKey((int)pClusterKey, (int)cc.getPredicateIndex()[i]);
                queryProcessor.updateStatements(resource, predicate);
            }
            ++i;
        }
        i = 0;
        while (i < cc.getValueIndex().length) {
            resource = ClusterTraits.createResourceKey((int)clusterKey, (int)cc.getValueIndex()[i]);
            queryProcessor.updateValue(resource);
            ++i;
        }
    }

    final synchronized void refreshImportance(ClusterImpl c) {
        if (c.isWriteOnly()) {
            return;
        }
        this.clusters.removeImportance(c);
        if (this.collectorPolicy != null) {
            this.collectorPolicy.removed((ClusterCollectorPolicy.CollectorCluster)c);
        }
        long newImportance = this.timeCounter();
        c.setImportance(newImportance);
        if (!c.isLoaded()) {
            LOGGER.error("", (Throwable)new Exception("Bug in ClusterTable.refreshImportance(ClusterImpl), cluster not loaded"));
        }
        this.clusters.registerImportance(c);
        if (this.collectorPolicy != null) {
            this.collectorPolicy.added((ClusterCollectorPolicy.CollectorCluster)c);
        }
    }

    public final <T extends ClusterI> T getClusterProxyByResourceKey(int resourceKey) {
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (ClusterTraitsBase.isVirtualClusterKey((int)clusterKey)) {
            throw new RuntimeException("Tried to get a persistent cluster for a virtual resource.");
        }
        ClusterImpl cluster = this.clusterArray[clusterKey];
        if (cluster == null) {
            throw new RuntimeException("No proxy for existing cluster. Resource key = " + resourceKey);
        }
        return (T)((Object)cluster);
    }

    private <T extends ClusterI> T ensureLoaded(T c) {
        ClusterImpl cluster;
        ClusterImpl cs = (ClusterImpl)c;
        try {
            cluster = this.load2(cs.getClusterId(), cs.getClusterKey());
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not load cluster", (Throwable)e);
            String msg = "Failed to load cluster " + String.valueOf(cs.getClusterUID());
            throw new RuntimeDatabaseException(msg, (Throwable)e);
        }
        return (T)((Object)cluster);
    }

    public final synchronized <T extends ClusterI> T getClusterByResourceKey(int resourceKey) {
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (ClusterTraitsBase.isVirtualClusterKey((int)clusterKey)) {
            throw new RuntimeException("Tried to get a persistent cluster for a virtual resource.");
        }
        ClusterImpl c = this.clusterArray[clusterKey];
        if (c == null) {
            return null;
        }
        if (c.isLoaded()) {
            if ((this.counter++ & 0xFFF) == 0) {
                this.refreshImportance(c);
            }
            return (T)((Object)c);
        }
        if (!(c instanceof ClusterSmall)) {
            LOGGER.error("Proxy must be instance of ClusterSmall");
            return null;
        }
        return (T)((Object)this.ensureLoaded(c));
    }

    final <T extends ClusterI> T checkedGetClusterByResourceKey(int resourceKey) {
        ClusterImpl cluster;
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (ClusterTraitsBase.isVirtualClusterKey((int)clusterKey)) {
            throw new RuntimeException("Tried to get a persistent cluster for a virtual resource.");
        }
        ClusterImpl c = this.clusterArray[clusterKey];
        if (c == null) {
            throw new RuntimeException("No cluster for resource key " + resourceKey);
        }
        if (c.isLoaded()) {
            if ((this.counter++ & 0xFFF) == 0) {
                this.refreshImportance(c);
            }
            return (T)((Object)c);
        }
        if (!(c instanceof ClusterSmall)) {
            LOGGER.error("Proxy must be instance of ClusterSmall");
            return null;
        }
        ClusterSmall cs = (ClusterSmall)c;
        try {
            cluster = this.load2(cs.getClusterId(), cs.getClusterKey());
        }
        catch (DatabaseException e) {
            int resourceIndex = resourceKey & ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
            long resourceId = ClusterTraitsBase.createResourceIdNoThrow((long)cs.getClusterId(), (int)resourceIndex);
            String msg = "Failed to load cluster " + String.valueOf(cs.getClusterUID()) + " for resource key " + resourceKey + " resourceIndex=" + resourceIndex + " resourceId=" + resourceId;
            LOGGER.error(msg, (Throwable)e);
            c.setDeleted(true, null);
            return (T)((Object)c);
        }
        return (T)((Object)cluster);
    }

    void printDebugInfo(ClusterSupport support) throws DatabaseException {
        int SIZE = this.clusters.size();
        long sum = 0L;
        int i = 1;
        while (i < SIZE) {
            ClusterImpl c = this.clusterArray[i];
            c.getNumberOfResources(support);
            long size = c.getUsedSpace();
            System.out.println("cluster=" + c.getClusterId() + " size=" + size);
            c.printDebugInfo("koss: ", support);
            sum += size;
            ++i;
        }
        System.out.println("Total number of clusters " + SIZE);
        System.out.println("Total cluster size " + sum);
    }

    public synchronized ClusterImpl load2(long clusterId, int clusterKey) throws DatabaseException {
        ClusterImpl curr = this.clusterArray[clusterKey];
        if (curr.isLoaded()) {
            return curr;
        }
        Semaphore s = new Semaphore(0);
        DatabaseException[] ex = new DatabaseException[1];
        this.load2(clusterId, clusterKey, e -> {
            databaseExceptionArray[0] = e;
            s.release();
        });
        try {
            s.acquire();
        }
        catch (InterruptedException e2) {
            LOGGER.error("unable to acquire", (Throwable)e2);
        }
        if (ex[0] != null) {
            throw ex[0];
        }
        this.validate(clusterKey);
        return this.clusterArray[clusterKey];
    }

    void validate(int clusterKey) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ClusterImpl getPrefetched() {
        Map<Long, ClusterImpl> map = this.prefetch;
        synchronized (map) {
            return null;
        }
    }

    public synchronized void load2(long clusterId, int clusterKey, Consumer<DatabaseException> runnable) {
        assert (-1L != clusterId);
        ClusterImpl cluster = null;
        DatabaseException e = null;
        try {
            ClusterUID clusterUID = this.clusters.makeClusterUID(clusterId);
            Database.Session session = this.sessionImpl.graphSession.dbSession;
            cluster = (ClusterImpl)((Object)session.clone(clusterUID, new ClusterCreator(){

                public <T> T create(ClusterUID uid, byte[] bytes, int[] ints, long[] longs) {
                    ClusterTranslator support = ClusterTable.this.sessionImpl.clusterTranslator;
                    try {
                        return (T)((Object)ClusterImpl.make(longs, ints, bytes, (ClusterSupport)support, support.getClusterKeyByClusterUIDOrMake(uid)));
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }));
        }
        catch (Throwable t) {
            LOGGER.error("Load cluster failed", t);
            e = t instanceof DatabaseException ? (DatabaseException)t : new DatabaseException("Load cluster failed.", t);
        }
        if (cluster == null) {
            runnable.accept(e);
            return;
        }
        this.replaceCluster((ClusterI)cluster);
        this.sessionImpl.onClusterLoaded(clusterId);
        runnable.accept(null);
    }

    public synchronized ClusterImpl tryLoad(long clusterId, int clusterKey) throws DatabaseException {
        assert (-1L != clusterId);
        ClusterUID clusterUID = this.clusters.makeClusterUID(clusterId);
        Database.Session session = this.sessionImpl.graphSession.dbSession;
        ClusterImpl cluster = (ClusterImpl)((Object)session.clone(clusterUID, new ClusterCreator(){

            public <T> T create(ClusterUID uid, byte[] bytes, int[] ints, long[] longs) {
                ClusterTranslator support = ClusterTable.this.sessionImpl.clusterTranslator;
                try {
                    return (T)((Object)ClusterImpl.make(longs, ints, bytes, (ClusterSupport)support, support.getClusterKeyByClusterUIDOrMake(uid)));
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }));
        if (this.clusterArray[clusterKey] == null) {
            this.clusterArray[clusterKey] = cluster;
        } else {
            this.replaceCluster((ClusterI)cluster);
        }
        this.sessionImpl.onClusterLoaded(clusterId);
        this.validate(clusterKey);
        return cluster;
    }

    public Collection<ClusterI> getClusters() {
        ArrayList<ClusterI> result = new ArrayList<ClusterI>();
        int i = 0;
        while (i < this.clusterArray.length) {
            ClusterImpl cluster = this.clusterArray[i];
            if (cluster != null) {
                result.add((ClusterI)cluster);
            }
            ++i;
        }
        return result;
    }

    public int size() {
        return this.clusters.size();
    }

    public long timeCounter() {
        return this.timeCounter.getAndIncrement();
    }

    public boolean hasVirtual(int index) {
        return this.virtuals[index];
    }

    public void markVirtual(int index) {
        this.virtuals[index] = true;
    }

    public ClusterImpl[] getClusterArray() {
        return this.clusterArray;
    }

    public boolean isImmutable(int id) {
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)id);
        byte exist = this.immutables[clusterKey];
        if (exist == 2) {
            return true;
        }
        if (exist == 1) {
            return false;
        }
        Object cluster = this.getClusterByResourceKey(id);
        if (cluster == null) {
            return false;
        }
        boolean result = cluster.getImmutable();
        this.markImmutable((ClusterI)cluster, result);
        return result;
    }

    public void markImmutable(ClusterI cluster, boolean value) {
        this.immutables[cluster.getClusterKey()] = value ? 2 : 1;
    }

    public int getClusterKeyByUID(long first, long second) throws DatabaseException {
        return this.getClusterKeyByClusterUIDOrMakeProxy(ClusterUID.make((long)first, (long)second));
    }

    public void adjustCachedSize(long l, ClusterI cluster) {
        if (l != 0L) {
            this.sizeInBytes += l;
        }
    }

    private void validateSize(String place) {
    }

    private int countImportantClusters() {
        int[] result = new int[1];
        this.clusters.hashMap.forEachEntry((cid, c) -> {
            if (ClusterTable.importantCluster(c)) {
                nArray[0] = result[0] + 1;
            }
            return true;
        });
        return result[0];
    }

    private static boolean importantCluster(ClusterImpl c) {
        return c != null && !c.isWriteOnly() && c.isLoaded();
    }

    public void purged(Collection<ClusterUID> purged) {
        for (ClusterUID uid : purged) {
            ClusterImpl cluster = this.clusters.getClusterByClusterId(uid.second);
            if (cluster != null) {
                this.clusters.removeProxy(cluster);
                this.clusters.removeImportance(cluster);
                this.clusters.purged.add(cluster.clusterId);
            }
            if (this.newResourceClusterId != uid.second) continue;
            this.newResourceClusterId = -1L;
        }
    }

    public Collection<ClusterCollectorPolicy.CollectorCluster> getCollectorClusters() {
        return this.clusters.getCollectorClusters();
    }

    class ClusterCollectorImpl
    implements ClusterCollector {
        private final ClusterCollectorSupport support;
        private ClusterCollectorPolicy policy;

        ClusterCollectorImpl(ClusterCollectorSupport support) {
            this.support = support;
        }

        ClusterCollectorPolicy setPolicy(ClusterCollectorPolicy newPolicy) {
            ClusterCollectorPolicy oldPolicy = this.policy;
            this.policy = newPolicy;
            if (this.policy != null) {
                for (ClusterCollectorPolicy.CollectorCluster id : this.support.getResidentClusters()) {
                    this.policy.added((ClusterCollectorPolicy.CollectorCluster)ClusterTable.this.getClusterByClusterId(id.getClusterId()));
                }
            }
            this.support.setPolicy(this.policy);
            return oldPolicy;
        }

        @Override
        public void collect() {
            if (this.policy != null) {
                this.release(this.policy.select());
            } else {
                int size = this.support.getCurrentSize();
                boolean dynamicAllocation = this.useDynamicAllocation();
                if (dynamicAllocation) {
                    ClusterTable.this.setAllocateSize(ClusterTable.this.estimateProperAllocation(this.support));
                }
                if (dynamicAllocation) {
                    int collectSize = ClusterTable.this.maximumBytes / 2;
                    if (ClusterTable.this.maximumBytes - size > (collectSize = Math.min(collectSize, 0x2000000))) {
                        return;
                    }
                    this.collect(collectSize += size - ClusterTable.this.maximumBytes);
                } else {
                    if (size < ClusterTable.this.maximumBytes) {
                        return;
                    }
                    this.collect(size - ClusterTable.this.limit);
                }
            }
        }

        private boolean useDynamicAllocation() {
            return "true".equalsIgnoreCase(System.getProperty("org.simantics.db.cluster.dynamicAlloc"));
        }

        @Override
        public void collect(int target) {
            if (this.policy != null) {
                this.release(this.policy.select(target));
            } else {
                ArrayList<ClusterCollectorPolicy.CollectorCluster> toRelease = new ArrayList<ClusterCollectorPolicy.CollectorCluster>();
                for (ClusterCollectorPolicy.CollectorCluster cluster : this.support.getResidentClusters()) {
                    toRelease.add(cluster);
                    long clusterSize = this.support.getClusterSize(cluster);
                    target = (int)((long)target - clusterSize);
                    if (target <= 0) break;
                }
                this.release(toRelease);
            }
        }

        void release(Collection<ClusterCollectorPolicy.CollectorCluster> toRelease) {
            for (ClusterCollectorPolicy.CollectorCluster id : toRelease) {
                this.support.release(id);
            }
        }
    }

    private class Clusters {
        public TLongHashSet purged = new TLongHashSet();
        private final TLongObjectHashMap<ClusterImpl> hashMap = new TLongObjectHashMap(2 * ARRAY_SIZE);
        private int nextIndex = 1;
        private final TreeMap<Long, ClusterCollectorPolicy.CollectorCluster> importanceMap = new TreeMap();

        private Clusters() {
            this.clear();
        }

        private void clear() {
            this.hashMap.clear();
            this.hashMap.put(0L, null);
            this.clearImportance();
        }

        private int size() {
            return this.hashMap.size();
        }

        public int nextIndex() {
            return this.nextIndex++;
        }

        private ClusterImpl getClusterByClusterId(long clusterId) {
            return (ClusterImpl)((Object)this.hashMap.get(clusterId));
        }

        private ClusterImpl getClusterByClusterUID(ClusterUID clusterUID) {
            return this.getClusterByClusterId(clusterUID.second);
        }

        private ClusterImpl getClusterByClusterUID(long id1, long id2) {
            return this.getClusterByClusterId(id2);
        }

        private ClusterImpl makeProxy(long clusterId) {
            return this.makeProxy(ClusterUID.make((long)0L, (long)clusterId));
        }

        private ClusterImpl makeProxy(ClusterUID clusterUID) {
            ClusterImpl proxy = (ClusterImpl)((Object)this.hashMap.get(clusterUID.second));
            if (proxy != null) {
                return proxy;
            }
            int clusterKey = this.nextIndex();
            ClusterSmall sentinel = new ClusterSmall(clusterUID, clusterKey, ClusterTable.this, (ClusterSupport)ClusterTable.this.sessionImpl.clusterTranslator);
            if (sentinel.clusterId != sentinel.clusterUID.second) {
                throw new RuntimeDatabaseException("ClusterTable corrupted.");
            }
            this.create(sentinel);
            return sentinel;
        }

        private void replace(ClusterImpl proxy) {
            ClusterImpl old = ClusterTable.this.clusterArray[proxy.clusterKey];
            this.create(proxy);
            if (old != null) {
                if (old.clusterKey != proxy.clusterKey) {
                    throw new RuntimeDatabaseException("ClusterTable corrupted.");
                }
                if (old.clusterId != proxy.clusterId) {
                    throw new RuntimeDatabaseException("ClusterTable corrupted.");
                }
                if (!old.clusterUID.equals((Object)proxy.clusterUID)) {
                    throw new RuntimeDatabaseException("ClusterTable corrupted.");
                }
            }
        }

        private ClusterSmall freeProxy(ClusterImpl proxy) {
            ClusterImpl clusterImpl = (ClusterImpl)((Object)this.hashMap.get(proxy.clusterId));
            if (clusterImpl == null) {
                throw new RuntimeDatabaseException("ClusterTable corrupted.");
            }
            if (proxy.clusterId != clusterImpl.clusterId) {
                throw new RuntimeDatabaseException("ClusterTable corrupted.");
            }
            if (proxy.clusterKey != clusterImpl.clusterKey) {
                throw new RuntimeDatabaseException("ClusterTable corrupted.");
            }
            ClusterSmall sentinel = new ClusterSmall(this.makeClusterUID(proxy.clusterId), proxy.clusterKey, ClusterTable.this, (ClusterSupport)ClusterTable.this.sessionImpl.clusterTranslator);
            return (ClusterSmall)this.create(sentinel);
        }

        private ClusterImpl create(ClusterImpl clusterImpl) {
            this.hashMap.put(clusterImpl.clusterId, (Object)clusterImpl);
            ClusterTable.this.clusterArray[clusterImpl.clusterKey] = clusterImpl;
            return clusterImpl;
        }

        private void forEachValue(TObjectProcedure<ClusterImpl> procedure) {
            this.hashMap.forEachValue(procedure);
        }

        private void forEachEntry(TLongObjectProcedure<ClusterImpl> procedure) {
            this.hashMap.forEachEntry(procedure);
        }

        private ClusterUID makeClusterUID(long clusterId) {
            return ClusterUID.make((long)0L, (long)clusterId);
        }

        private void removeProxy(ClusterImpl proxy) {
            this.hashMap.remove(proxy.clusterId);
            ClusterTable.this.clusterArray[proxy.clusterKey] = null;
        }

        public void clearImportance() {
            this.importanceMap.clear();
        }

        public Collection<ClusterCollectorPolicy.CollectorCluster> getCollectorClusters() {
            return this.importanceMap.values();
        }

        public void registerImportance(ClusterImpl cluster) {
            ClusterCollectorPolicy.CollectorCluster exist = this.importanceMap.put(cluster.getImportance(), new ImportanceEntry(cluster));
            if (exist != null) {
                throw new IllegalStateException("Importance bookkeeping corrupted for cluster " + cluster.getClusterId());
            }
            if (this.purged.contains(cluster.getClusterId())) {
                throw new IllegalStateException("Cluster has been purged " + cluster.getClusterId());
            }
        }

        public void removeImportance(ClusterCollectorPolicy.CollectorCluster cluster) {
            long importance = cluster.getImportance();
            if (importance == 0L) {
                return;
            }
            if (this.importanceMap.remove(cluster.getImportance()) == null) {
                throw new IllegalStateException("Importance bookkeeping corrupted for cluster " + cluster.getClusterId());
            }
        }

        public int importanceMapSize() {
            return this.importanceMap.size();
        }

        private void printMaps(String place) {
            int ihms = ClusterTable.this.countImportantClusters();
            System.out.println("## printMaps(" + place + ") - " + this.importanceMap.size() + " - (" + ihms + "/" + ClusterTable.this.clusters.hashMap.size() + ")");
            System.out.println("importanceMap (" + this.importanceMap.size() + "):");
            this.importanceMap.forEach((importance, ie) -> System.out.format("\t%d: %s%n", importance, ie.toString()));
            System.out.println("clusters.hashMap (" + ihms + "/" + ClusterTable.this.clusters.hashMap.size() + "):");
            ClusterTable.this.clusters.hashMap.forEachEntry((cid, c) -> {
                boolean important = ClusterTable.importantCluster(c);
                boolean wo = c != null && c.isWriteOnly();
                boolean empty = c != null && c.isEmpty();
                boolean loaded = c != null && c.isLoaded();
                System.out.format("\t%s: %d - %s (writeOnly=%b, empty=%b, loaded=%b)%n", important ? " I" : "NI", cid, c, wo, empty, loaded);
                return true;
            });
        }
    }

    static class ImportanceEntry
    implements ClusterCollectorPolicy.CollectorCluster {
        public final long importance;
        public final long clusterId;

        public ImportanceEntry(ClusterImpl impl) {
            this(impl.getImportance(), impl.getClusterId());
        }

        public ImportanceEntry(long importance, long clusterId) {
            this.importance = importance;
            this.clusterId = clusterId;
        }

        public long getImportance() {
            return this.importance;
        }

        public long getClusterId() {
            return this.clusterId;
        }

        public String toString() {
            return "CID " + this.clusterId;
        }
    }

    class SizeProcedure
    implements TObjectProcedure<ClusterImpl> {
        public long result = 0L;

        SizeProcedure() {
        }

        public boolean execute(ClusterImpl cluster) {
            if (cluster != null) {
                try {
                    if (cluster.isLoaded() && !cluster.isEmpty()) {
                        this.result += cluster.getCachedSize();
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Could not calculate size", t);
                }
            }
            return true;
        }

        public void clear() {
            this.result = 0L;
        }
    }
}

