/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.IPropertyTab;
import org.simantics.selectionview.IPropertyTab2;
import org.simantics.selectionview.PropertyPage;
import org.simantics.selectionview.SelectionProcessor;
import org.simantics.selectionview.StandardProperties;
import org.simantics.selectionview.StandardSelectionProcessor;
import org.simantics.selectionview.TabChangeEvent;

public class StandardPropertyPage
extends PropertyPage {
    private final Set<String> contexts;
    private StandardProperties tabs;
    private transient Consumer<String> lastTitleCallback;
    private static final int MAX_SELECTED_TABS_REMEMBERED = 20;
    private static LinkedList<TabSelection> previouslySelectedTabs = new LinkedList();
    private TabSelection tabSelection;

    public StandardPropertyPage(IWorkbenchPartSite site) {
        this(site, new TreeSet<String>());
    }

    public StandardPropertyPage(IWorkbenchPartSite site, Set<String> contexts) {
        super(site);
        this.contexts = contexts;
    }

    protected SelectionProcessor<?, ?> getSelectionProcessor() {
        return new StandardSelectionProcessor();
    }

    protected Set<String> getContexts() {
        return this.contexts;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.tabs = null;
    }

    @Override
    protected void createPageControls(Composite parent) {
        SelectionProcessor<?, ?> sp = this.getSelectionProcessor();
        Set<SelectionProcessor<?, ?>> sps = null;
        if (sp != null) {
            sps = Collections.singleton(sp);
        }
        this.tabs = new StandardProperties(this.sourceSite, this.getSite(), parent, 0, this.getContexts(), sps){

            @Override
            protected void activeTabChanged(TabChangeEvent event) {
                StandardPropertyPage.this.activeTabChanged(event);
            }

            @Override
            protected ComparableTabContributor selectInitialTab(Collection<Object> selectionContents, Collection<ComparableTabContributor> contributions) {
                return StandardPropertyPage.this.selectInitialTab(selectionContents, contributions);
            }

            @Override
            protected int getTabFolderStyle() {
                return StandardPropertyPage.this.getTabFolderStyle();
            }
        };
        this.tab = this.tabs;
        this.tab.createControl(this.tabs, this.getSessionContext());
        this.getSite().setSelectionProvider(this.tabs.getSelectionProvider());
        this.fillToolBar(this.getSite().getActionBars().getToolBarManager());
        this.fillDropDownMenu(this.getSite().getActionBars().getMenuManager());
    }

    @Override
    public void updatePartName(ISelection forSelection, Consumer<String> updateCallback) {
        if (!this.visible) {
            updateCallback.accept("Selection");
            return;
        }
        this.lastTitleCallback = updateCallback;
        IPropertyTab tab = this.tabs.getActiveTab();
        if (tab instanceof IPropertyTab2) {
            ((IPropertyTab2)tab).updatePartName(updateCallback);
        } else {
            super.updatePartName(forSelection, updateCallback);
        }
    }

    protected int getTabFolderStyle() {
        return 0x800400;
    }

    protected ComparableTabContributor selectInitialTab(Collection<Object> selectionContents, Collection<ComparableTabContributor> contributions) {
        this.tabSelection = TabSelection.make(contributions);
        Iterator it = previouslySelectedTabs.iterator();
        while (it.hasNext()) {
            TabSelection t = (TabSelection)it.next();
            if (!t.equals(this.tabSelection)) continue;
            this.tabSelection = t;
            it.remove();
            previouslySelectedTabs.addFirst(t);
            for (ComparableTabContributor contrib : contributions) {
                if (!Objects.equals(contrib.getLabel(), t.selected)) continue;
                return contrib;
            }
            return null;
        }
        this.tabSelection.setSelected(contributions.iterator().next().getLabel());
        previouslySelectedTabs.addFirst(this.tabSelection);
        while (previouslySelectedTabs.size() > 20) {
            previouslySelectedTabs.removeLast();
        }
        return null;
    }

    protected void activeTabChanged(TabChangeEvent event) {
        IPropertyTab tab;
        if (this.tabSelection != null) {
            this.tabSelection.setSelected(event.getNewTabLabel());
        }
        if ((tab = event.getNewTab()) instanceof IPropertyTab2 && this.lastTitleCallback != null) {
            ((IPropertyTab2)tab).updatePartName(this.lastTitleCallback);
        }
    }

    static class TabSelection {
        private final String[] tabLabels;
        private String selected;

        public static TabSelection make(Collection<ComparableTabContributor> contribs) {
            String[] labels = new String[contribs.size()];
            int i = 0;
            for (ComparableTabContributor contrib : contribs) {
                labels[i++] = contrib.getLabel();
            }
            return new TabSelection(labels);
        }

        public TabSelection(String ... tabLabels) {
            this.tabLabels = tabLabels;
        }

        public String getSelected() {
            return this.selected;
        }

        public void setSelected(String label) {
            String[] stringArray = this.tabLabels;
            int n = this.tabLabels.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                if (l.equals(label)) {
                    this.selected = label;
                    break;
                }
                ++n2;
            }
        }

        public int hashCode() {
            return Arrays.hashCode(this.tabLabels);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TabSelection other = (TabSelection)obj;
            return Arrays.equals(this.tabLabels, other.tabLabels);
        }

        public String toString() {
            return this.getClass().getName() + "[" + Arrays.toString(this.tabLabels) + " - " + this.selected + "]";
        }
    }
}

