/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;
import org.simantics.history.impl.FileHistory;
import org.simantics.history.impl.FlushPolicy;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.modeling.subscription.SubscriptionCollectionResult;
import org.simantics.modeling.subscription.VariableSetListener;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.data.DatasourceAdapter;
import org.simantics.simulation.data.VariableHandle;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.trend.configuration.TrendSamplingFormats;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.IThreadWorkQueue;

public class ModelHistoryCollector {
    static final String BUNDLE_ID = "org.simantics.modeling";
    private Session session;
    private HistoryManager history;
    private Resource model;
    private IDynamicExperiment dynamicExperiment;
    ILog logger;
    private Supplier<Read<SubscriptionCollectionResult>> subscriptionFunction;
    Runnable loadCallback;
    IThreadWorkQueue loadThread;
    private VariableSetListener variableListener;
    Semaphore initMutex = new Semaphore(0);
    final ItemCollector itemCollector = new ItemCollector();
    private static ThreadLocal<Map<Object, Collection<SamplingFormat>>> samplingFormatCaches = new ThreadLocal<Map<Object, Collection<SamplingFormat>>>(){

        @Override
        protected Map<Object, Collection<SamplingFormat>> initialValue() {
            return new WeakHashMap<Object, Collection<SamplingFormat>>();
        }
    };

    public static ModelHistoryCollector createCollector(IDynamicExperiment dynamicExperiment, HistoryManager history, ILog log, Supplier<Read<SubscriptionCollectionResult>> subscriptionRequestFunction, Runnable loadCallback) throws DatabaseException, IOException {
        return ModelHistoryCollector.createCollector(dynamicExperiment, history, log, subscriptionRequestFunction, loadCallback, null);
    }

    public static ModelHistoryCollector createCollector(IDynamicExperiment dynamicExperiment, HistoryManager history, ILog log, Supplier<Read<SubscriptionCollectionResult>> subscriptionRequestFunction, Runnable loadCallback, IThreadWorkQueue loadThread) throws DatabaseException, IOException {
        ModelHistoryCollector data = new ModelHistoryCollector();
        data.history = history;
        data.model = dynamicExperiment.getModel();
        data.dynamicExperiment = dynamicExperiment;
        data.logger = log;
        data.subscriptionFunction = subscriptionRequestFunction;
        data.loadCallback = loadCallback;
        data.loadThread = loadThread;
        return data;
    }

    private ModelHistoryCollector() {
    }

    public void initialize(RequestProcessor processor, double startTime) throws DatabaseException, HistoryException, InterruptedException {
        this.initialize(processor, startTime, false);
    }

    public void initialize(RequestProcessor processor, double startTime, boolean listenToVariableSet) throws DatabaseException, HistoryException, InterruptedException {
        this.session = processor.getSession();
        this.itemCollector.init(this.history, this.dynamicExperiment, startTime, this.model);
        this.refresh0(processor, listenToVariableSet);
    }

    public void refresh() throws HistoryException, DatabaseException, InterruptedException {
        this.refresh0((RequestProcessor)this.session, false);
    }

    public File getWorkarea() {
        return this.history instanceof FileHistory ? ((FileHistory)this.history).getWorkarea() : null;
    }

    public HistoryManager getHistoryManager() {
        return this.itemCollector.history;
    }

    private void refresh0(RequestProcessor processor, boolean listenToVariableSet) throws HistoryException, DatabaseException, InterruptedException {
        if (listenToVariableSet) {
            if (this.variableListener == null) {
                this.variableListener = new VariableSetListener(this);
                this.initMutex = new Semaphore(0);
                processor.syncRequest(this.subscriptionFunction.get(), (Listener)this.variableListener);
                this.initMutex.acquire();
            }
        } else if (this.variableListener == null) {
            SubscriptionCollectionResult variables = (SubscriptionCollectionResult)((Object)processor.syncRequest(this.subscriptionFunction.get()));
            if (!variables.getStatus().isOK() && this.logger != null) {
                this.logger.log((IStatus)variables.getStatus());
            }
            this.itemCollector.load(variables.getSubscriptions());
            if (this.loadCallback != null) {
                this.loadCallback.run();
            }
        }
    }

    public void dispose() {
        if (this.variableListener != null) {
            this.variableListener.dispose();
            this.variableListener = null;
        }
        this.itemCollector.dispose();
    }

    public void primeInitialSubscription(ReadGraph graph) throws DatabaseException {
        SubscriptionCollectionResult variables = (SubscriptionCollectionResult)((Object)graph.syncRequest(this.subscriptionFunction.get()));
        HashSet<Pair> variableIds = new HashSet<Pair>();
        for (Bean bean : variables.getSubscriptions()) {
            String variableId = (String)bean.getFieldUnchecked("variableId");
            variableIds.add(Pair.make((Object)bean, (Object)variableId));
        }
        Datasource datasource = this.dynamicExperiment.getDatasource();
        for (Pair ids : variableIds) {
            Datatype type = datasource.getType((String)ids.second);
            Binding valueBinding = Bindings.getBinding((Datatype)type);
            VariableHandle handle = datasource.openHandle((Bean)ids.first, (String)ids.second, valueBinding);
            try {
                try {
                    handle.getValue();
                }
                catch (AccessorException e) {
                    this.logger.log((IStatus)new Status(4, "org.simantics.simulation", e.getLocalizedMessage(), (Throwable)e));
                    handle.dispose();
                    continue;
                }
            }
            catch (Throwable throwable) {
                handle.dispose();
                throw throwable;
            }
            handle.dispose();
        }
    }

    private static Collection<SamplingFormat> resolveSamplingFormats(Map<Object, Collection<SamplingFormat>> cache, SubscriptionItem item, Datatype type, String unit) {
        if (type instanceof BooleanType) {
            Double cacheKey = item.interval;
            List formats = cache.get(cacheKey);
            if (formats == null) {
                formats = TrendSamplingFormats.createBinarySamplingFormats((double)item.interval);
                cache.put(cacheKey, formats);
            }
            return formats;
        }
        if (type instanceof NumberType) {
            Tuple3 cacheKey = new Tuple3((Object)item.interval, (Object)item.deadband, (Object)unit);
            List formats = cache.get(cacheKey);
            if (formats == null) {
                formats = TrendSamplingFormats.createAnalogSamplingFormats((double)item.interval, (double)item.deadband, (String)unit);
                cache.put(cacheKey, formats);
            }
            return formats;
        }
        SamplingFormat format = new SamplingFormat();
        format.formatId = "custom";
        RecordType f = new RecordType();
        format.format = f;
        f.addComponent("time", (Datatype)Datatypes.DOUBLE);
        f.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        f.addComponent("quality", (Datatype)Datatypes.BYTE);
        f.addComponent("value", type);
        format.interval = item.interval;
        format.deadband = item.deadband;
        return Collections.singleton(format);
    }

    public static List<SubscriptionItem> sampledSubscriptionItems(List<SubscriptionItem> rawItems) {
        Map<Object, Collection<SamplingFormat>> cache = samplingFormatCaches.get();
        ArrayList<SubscriptionItem> result = new ArrayList<SubscriptionItem>(rawItems.size() * 6);
        for (SubscriptionItem item : rawItems) {
            SubscriptionItem[] his;
            String groupItemId = item.id;
            Datatype type = item.format;
            String unit = item.formatId;
            Collection<SamplingFormat> formats = ModelHistoryCollector.resolveSamplingFormats(cache, item, type, unit);
            SubscriptionItem[] subscriptionItemArray = his = SubscriptionItem.createItems((SubscriptionItem)item, (String)groupItemId, (String)item.groupId, formats);
            int n = his.length;
            int n2 = 0;
            while (n2 < n) {
                SubscriptionItem hi = subscriptionItemArray[n2];
                hi.groupItemId = groupItemId;
                result.add(hi);
                ++n2;
            }
        }
        return result;
    }

    public Collector getCollector() {
        return this.itemCollector.collector;
    }

    public static class ItemCollector {
        IDynamicExperiment experiment;
        Datasource source;
        HistoryManager history;
        Collector collector;
        DatasourceAdapter adapter;
        Resource model;

        public synchronized void init(HistoryManager history, IDynamicExperiment experiment, double startTime, Resource model) {
            this.experiment = experiment;
            this.source = experiment.getDatasource();
            this.history = history;
            this.collector = History.createCollector((HistoryManager)this.history, (FlushPolicy)FlushPolicy.NoFlush);
            this.model = model;
        }

        public synchronized void load(List<SubscriptionItem> items) throws HistoryException, DatabaseException {
            if (this.isDisposed()) {
                return;
            }
            ExperimentState oldState = this.experiment.getState();
            if (oldState == ExperimentState.RUNNING) {
                this.experiment.changeState(ExperimentState.STOPPED);
            }
            try {
                ItemManager im = new ItemManager(items);
                if (this.collector == null) {
                    this.collector = History.createCollector((HistoryManager)this.history);
                }
                SubscriptionItem[] subscriptionItemArray = this.collector.getItems();
                int n = subscriptionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SubscriptionItem subscriptionItem = subscriptionItemArray[n2];
                    String id = (String)subscriptionItem.getFieldUnchecked("id");
                    Bean newItem = im.get(id);
                    if (newItem == null) {
                        subscriptionItem.enabled = false;
                        this.collector.setItem((Bean)subscriptionItem);
                    }
                    ++n2;
                }
                for (Bean bean : items) {
                    this.collector.setItem(bean);
                }
                this.history.modify(items.toArray(new Bean[items.size()]));
                if (this.adapter == null) {
                    this.adapter = new DatasourceAdapter(this.collector);
                    this.source.addListener((Datasource.DatasourceListener)this.adapter);
                } else {
                    this.adapter.reset();
                }
            }
            finally {
                this.experiment.changeState(oldState);
            }
        }

        public synchronized void dispose() {
            if (this.source != null && this.adapter != null) {
                this.source.removeListener((Datasource.DatasourceListener)this.adapter);
            }
            if (this.adapter != null) {
                this.adapter.reset();
            }
            if (this.collector != null) {
                this.collector.close();
            }
            if (this.history != null) {
                this.history.close();
            }
            this.experiment = null;
        }

        public HistoryManager getCollector() {
            return this.history;
        }

        public boolean isDisposed() {
            return this.experiment == null;
        }
    }
}

