/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

public class AddSubscriptionItems
extends WriteRequest {
    Resource subscription;
    Collection<VariableReference> references;
    public List<Resource> result;

    public AddSubscriptionItems(Resource subscription, Collection<VariableReference> references) {
        this.subscription = subscription;
        this.references = references;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        this.result = new ArrayList<Resource>(this.references.size());
        for (VariableReference ref : this.references) {
            Double db;
            IEclipsePreferences pn;
            Double si;
            if (ref.getVariableId() == null) continue;
            Resource subscriptionItem = graph.newResource();
            graph.claim(subscriptionItem, l0.InstanceOf, null, mr.Subscription_Item);
            graph.claim(this.subscription, l0.ConsistsOf, subscriptionItem);
            graph.claimLiteral(subscriptionItem, l0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
            if (ref.getLabel() != null) {
                graph.claimLiteral(subscriptionItem, l0.HasLabel, (Object)ref.getLabel(), (Binding)Bindings.STRING);
            }
            Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
            graph.claimLiteral(subscriptionItem, mr.Subscription_Item_VariableId, l0.RVI, (Object)ref.getVariableId(), rviBinding);
            if (ref.getDatatype() != null) {
                graph.claimLiteral(subscriptionItem, mr.Subscription_Item_Datatype, l0.DataType, (Object)ref.getDatatype(), Bindings.getBindingUnchecked(Datatype.class));
            }
            if ((si = Double.valueOf((pn = InstanceScope.INSTANCE.getNode("org.simantics.modeling")).getDouble("subscriptionitem.interval", 0.0))) != null) {
                graph.claimLiteral(subscriptionItem, mr.Subscription_Item_SamplingInterval, (Object)si, (Binding)Bindings.DOUBLE);
            }
            if ((db = Double.valueOf(pn.getDouble("subscriptionitem.deadband", 0.0))) != null) {
                graph.claimLiteral(subscriptionItem, mr.Subscription_Item_Deadband, (Object)db, (Binding)Bindings.DOUBLE);
            }
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Created subscription item " + String.valueOf(subscriptionItem) + " [" + ref.getVariableId().toString((ReadGraph)graph) + "]"));
            this.result.add(subscriptionItem);
        }
    }
}

