/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.RelatedValue;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLScripts {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLScripts.class);
    private static final String SCL_SCRIPT_CONSOLE_ID = "org.simantics.scl.ui.scriptConsole";

    public static String canRunScript(RequestProcessor processor, Resource script) throws DatabaseException {
        return null;
    }

    private static Job createRunScriptJob(final String scriptName, final String scriptText, final CommandSession session, final SCLReportingHandler handler) {
        Job job = new Job("Run SCL Script"){

            protected IStatus run(IProgressMonitor monitor) {
                SCLScripts.runScriptWithProgress(monitor, scriptName, scriptText, session, handler);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        return job;
    }

    public static void runScriptWithProgress(String scriptName, String scriptText, CommandSession session, SCLReportingHandler handler) {
        SCLScripts.createRunScriptJob(scriptName, scriptText, session, handler).schedule();
    }

    public static void runScriptWithProgress(IProgressMonitor monitor, String scriptName, String scriptText, CommandSession session, SCLReportingHandler handler) {
        monitor.beginTask(scriptName, -1);
        try {
            session.execute((Reader)new StringReader(scriptText), handler);
        }
        finally {
            monitor.done();
        }
    }

    private static Optional<SCLReportingHandler> getCurrentReportingHandler() {
        return Optional.ofNullable((SCLReportingHandler)SCLContext.getCurrent().get((Object)"reportingHandler"));
    }

    private static Optional<SCLReportingHandler> getScriptOutputViewReportingHandler(boolean createIfNecessary) throws PartInitException {
        IViewPart adaptable = createIfNecessary ? WorkbenchUtils.showView((String)SCL_SCRIPT_CONSOLE_ID, (int)2) : WorkbenchUtils.findView((String)SCL_SCRIPT_CONSOLE_ID);
        return Optional.ofNullable(adaptable != null ? (SCLReportingHandler)adaptable.getAdapter(SCLReportingHandler.class) : null);
    }

    public static Pair<CommandSession, SCLReportingHandler> getOrCreateConsoleCommandSession() {
        return SCLScripts.getSCLConsoleCommandSession(true);
    }

    public static Pair<CommandSession, SCLReportingHandler> getSCLConsoleCommandSession(boolean createIfNecessary) {
        Optional<SCLReportingHandler> currentHandler = SCLScripts.getCurrentReportingHandler();
        if (currentHandler.isPresent()) {
            return Pair.make((Object)new CommandSession(SCLOsgi.MODULE_REPOSITORY, currentHandler.get()), (Object)currentHandler.get());
        }
        SCLReportingHandler defaultHandler = SCLReportingHandler.DEFAULT_WITHOUT_ECHO;
        if (PlatformUI.isWorkbenchRunning()) {
            try {
                Optional<SCLReportingHandler> handler = SCLScripts.getScriptOutputViewReportingHandler(createIfNecessary);
                if (handler.isPresent()) {
                    return Pair.make((Object)new CommandSession(SCLOsgi.MODULE_REPOSITORY, defaultHandler), (Object)handler.get());
                }
            }
            catch (PartInitException e) {
                LOGGER.error("Failed to open SCL Script Output view. Using new CommandSession, reporting to Logger.", (Throwable)e);
            }
        }
        return Pair.make((Object)new CommandSession(SCLOsgi.MODULE_REPOSITORY, defaultHandler), (Object)SCLReportingHandler.DEFAULT);
    }

    public static Future<String> runScript(Resource resource) throws DatabaseException {
        Object graph = SCLContext.getCurrent().get((Object)"graph");
        if (graph instanceof ReadGraph) {
            throw new DatabaseException("Cannot invoke executeSCLScript from within a database transaction");
        }
        Session s = Simantics.getSession();
        Layer0 L0 = Layer0.getInstance((RequestProcessor)s);
        String error = SCLScripts.canRunScript((RequestProcessor)s, resource);
        if (error == null) {
            final String scriptName = (String)s.syncRequest((AsyncRead)new RelatedValue(resource, L0.HasName, (Binding)Bindings.STRING));
            String scriptText = (String)s.syncRequest((AsyncRead)new RelatedValue(resource, L0.SCLScript_definition, (Binding)Bindings.STRING));
            String scriptUrl = (String)s.syncRequest((Read)new ResourceToPossibleURI(resource));
            Pair<CommandSession, SCLReportingHandler> p = SCLScripts.getOrCreateConsoleCommandSession();
            ((CommandSession)p.first).setRelativeResolutionModuleName(scriptUrl);
            final CompletableFuture<String> future = new CompletableFuture<String>();
            Job job = SCLScripts.createRunScriptJob(scriptName, scriptText, (CommandSession)p.first, (SCLReportingHandler)p.second);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void aboutToRun(IJobChangeEvent event) {
                    if (future.isCancelled()) {
                        event.getJob().cancel();
                    }
                }

                public void done(IJobChangeEvent event) {
                    IStatus r = event.getResult();
                    switch (r.getSeverity()) {
                        case 8: {
                            future.cancel(true);
                            return;
                        }
                        case 4: {
                            Throwable eex = r.getException();
                            if (eex != null) {
                                future.completeExceptionally(eex);
                            } else {
                                future.complete(String.format("Script '%s' execution failed with error: %s", scriptName, r.getMessage()));
                            }
                            return;
                        }
                        case 2: {
                            Throwable wex = r.getException();
                            if (wex != null) {
                                future.completeExceptionally(wex);
                            } else {
                                future.complete(String.format("Script '%s' execution completed with warning: %s", scriptName, r.getMessage()));
                            }
                            return;
                        }
                    }
                    future.complete(String.format("Script '%s' executed", scriptName));
                }
            });
            job.schedule();
            return future;
        }
        throw new ValidationException("Invalid SCL script: " + error);
    }
}

