/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.search;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function4;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.Pair;
import org.simantics.workbench.search.NameAndTypeRow;
import org.simantics.workbench.search.NamedResource;
import org.simantics.workbench.search.QueryResult;
import org.simantics.workbench.search.SearchData;
import org.simantics.workbench.search.SearchEngine;
import org.simantics.workbench.search.SearchQuery;
import org.simantics.workbench.search.SearchResult;
import org.simantics.workbench.search.SearchResultRow;

public final class Searching {
    static final boolean USE_PAGING = false;
    static final int MAX_PER_PAGE = 100;

    public static Collection<Map<String, Object>> performSearch(ReadGraph graph, Resource searchFunction, Resource model, String query, int maxResults) throws DatabaseException {
        Function4 f = (Function4)graph.adapt(searchFunction, Function.class);
        Collection results = (Collection)f.apply((Object)graph, (Object)model, (Object)query, (Object)maxResults);
        return results;
    }

    private static Collection<SearchEngine> listSearchEngines(MapList<Resource, Pair<SearchEngine, SearchResult>> results) {
        HashSet<SearchEngine> searchEngines = new HashSet<SearchEngine>();
        for (Pair result : results.getAllValuesSnapshot()) {
            if (result.first == null) continue;
            searchEngines.add((SearchEngine)result.first);
        }
        return searchEngines;
    }

    public static List<QueryResult> generatePage(ReadGraph graph, SearchQuery query, int maxResultsPerModel, MapList<Resource, Pair<SearchEngine, SearchResult>> results) throws IOException, TemplateException, DatabaseException {
        URL fileUrl = Searching.getSearchFileURL();
        File dataDir = Searching.getAbsoluteFile(fileUrl);
        Collection<SearchEngine> searchEngines = Searching.listSearchEngines(results);
        SearchData data = new SearchData();
        data.dataUrl = fileUrl.toString();
        data.dataDirectory = dataDir;
        data.query = query;
        data.maxResults = maxResultsPerModel;
        data.model = null;
        data.results = new SearchResult();
        data.resultCount = 0;
        data.searchEngines = searchEngines;
        int resultCount = 0;
        int resultNumber = 0;
        boolean itemsOnPreviousPage = false;
        ArrayList<QueryResult> result = new ArrayList<QueryResult>();
        QueryResult header = Searching.applyTemplate(graph, "header.ftl", data);
        QueryResult footer = Searching.applyTemplate(graph, "footer.ftl", data);
        StringBuilder body = new StringBuilder(81920);
        int totalResults = 0;
        List allResults = results.getAllValuesSnapshot();
        for (Pair entry : allResults) {
            totalResults += ((SearchResult)entry.second).rows.size();
        }
        for (Resource model : results.getKeys()) {
            List modelResults = results.getValues((Object)model);
            for (Pair entry : modelResults) {
                List<SearchResultRow> items = ((SearchResult)entry.second).rows;
                data.resultCount = resultCount = items.size();
                QueryResult content = Searching.generateResultTable(graph, query, maxResultsPerModel, data, resultNumber, resultCount, model, (SearchEngine)entry.first, (SearchResult)entry.second);
                body.append(content.getHtml());
                ++resultNumber;
                totalResults += resultCount;
            }
        }
        result.add(new QueryResult(header.getHtml(), body.toString(), footer.getHtml(), totalResults));
        if (result.size() == 0) {
            result.add(new QueryResult(header.getHtml(), body.toString(), footer.getHtml(), 0));
        }
        return result;
    }

    public static QueryResult generateResultTable(ReadGraph graph, SearchQuery query, int maxResultsPerModel, SearchData template, int resultNumber, int resultCount, Resource model, SearchEngine searchEngine, SearchResult results) throws IOException, TemplateException, DatabaseException {
        SearchData data = template.clone();
        data.resultNumber = resultNumber;
        data.query = query;
        data.maxResults = maxResultsPerModel;
        data.model = NamedResource.of(graph, model);
        data.results = results;
        data.searchEngine = searchEngine;
        return Searching.applyTemplate(graph, "searchtable.ftl", data);
    }

    private static URL getSearchFileURL() throws IOException {
        Bundle b = Platform.getBundle((String)"org.simantics.workbench.search");
        URL dataUrl = FileLocator.find((Bundle)b, (IPath)new Path("search"), null);
        if (dataUrl == null) {
            throw new IOException("Could not find search template data");
        }
        URL fileUrl = FileLocator.toFileURL((URL)dataUrl);
        return fileUrl;
    }

    private static File getAbsoluteFile(URL fileUrl) throws IOException {
        File dataDir = new File(URLDecoder.decode(fileUrl.getPath(), "UTF-8")).getAbsoluteFile();
        return dataDir;
    }

    public static QueryResult applyTemplate(ReadGraph graph, String templateName, SearchData data) throws IOException, TemplateException, DatabaseException {
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setDirectoryForTemplateLoading(data.getDataDirectory());
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS));
        Template temp = cfg.getTemplate(templateName);
        CharArrayWriter writer = new CharArrayWriter(131072);
        temp.process((Object)data, (Writer)writer);
        return new QueryResult(writer.toString(), data.results.rows.size());
    }

    public static final SearchResult generateDependenciesSearchResult(ReadGraph graph, Collection<Map<String, Object>> results) throws DatabaseException {
        HashSet<Resource> processed = new HashSet<Resource>();
        SearchResult result = new SearchResult(NameAndTypeRow.columns);
        NameLabelMode mode = NameLabelUtil.getNameLabelMode((RequestProcessor)graph);
        for (Map<String, Object> r : results) {
            Resource resource = (Resource)r.get("Resource");
            if (!processed.add(resource)) continue;
            Resource parent = (Resource)r.get("Parent");
            String name = (String)r.get("Name");
            NameAndTypeRow rst = new NameAndTypeRow();
            rst.resource = NamedResource.of(graph, resource, name);
            rst.parent = NamedResource.of(graph, parent, NameLabelUtil.modalName((ReadGraph)graph, (Resource)parent, (NameLabelMode)mode));
            Set typeResources = graph.getTypes(resource);
            Collection principalTypeResources = graph.getPrincipalTypes(resource);
            if (!typeResources.isEmpty()) {
                rst.types = new ArrayList<NamedResource>(typeResources.size());
                rst.principalTypes = new ArrayList<NamedResource>(principalTypeResources.size());
                for (Resource t : typeResources) {
                    NamedResource nr = NamedResource.of(graph, t);
                    rst.types.add(nr);
                    if (!principalTypeResources.contains(t)) continue;
                    rst.principalTypes.add(nr);
                }
            }
            result.addRow(rst);
        }
        return result;
    }
}

