/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.representation;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.RuntimeDatatypeConstructionException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.graph.representation.ByteFileReader;
import org.simantics.graph.representation.Extensions;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.InputChannel;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransferableGraphFileReader
extends ByteFileReader {
    public static final boolean DEFAULT_SHARED_VALUE_CONTEXT = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferableGraphFileReader.class);
    InputStream in = new InputStream(){

        @Override
        public int read() throws IOException {
            return TransferableGraphFileReader.this.getByte();
        }

        @Override
        public int read(byte[] b) throws IOException {
            System.arraycopy(TransferableGraphFileReader.this.safeBytes(b.length), 0, b, 0, b.length);
            return b.length;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            System.arraycopy(TransferableGraphFileReader.this.safeBytes(len), 0, b, off, len);
            return len;
        }
    };
    private static boolean init = true;
    private static final int SIZE = 262144;
    private static final int HEADER = TransferableGraphFileReader.headerSize();
    private final int header;
    private boolean shareValueContext = true;

    public static TransferableGraph1 read(File file) throws IOException {
        return TransferableGraphFileReader.read(file, true);
    }

    public static TransferableGraph1 read(InputStream input) throws IOException {
        return TransferableGraphFileReader.read(input, true);
    }

    public static TransferableGraph1 read(File file, boolean sharedValueContext) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TransferableGraphFileReader reader = new TransferableGraphFileReader(file);){
            return reader.sharedValueContext(sharedValueContext).readTG();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static TransferableGraph1 read(InputStream input, boolean sharedValueContext) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TransferableGraphFileReader reader = new TransferableGraphFileReader(input);){
            return reader.sharedValueContext(sharedValueContext).readTG();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public TransferableGraphFileReader(File file) throws IOException {
        super(file, 262144);
        if (init) {
            init = false;
            TransferableGraphFileReader r = new TransferableGraphFileReader(file, 0);
            int i = 0;
            while (i < 40000) {
                r.readTG();
                ++i;
            }
        }
        this.header = HEADER;
    }

    public TransferableGraphFileReader(InputStream stream) throws IOException {
        super(null, new InputChannel(stream), 262144);
        if (init) {
            init = false;
            TransferableGraphFileReader r = new TransferableGraphFileReader(stream, 0);
            int i = 0;
            while (i < 40000) {
                r.readTG();
                ++i;
            }
        }
        this.header = 0;
    }

    public TransferableGraphFileReader(ReadableByteChannel channel) throws IOException {
        super(null, channel, 262144);
        if (init) {
            init = false;
            TransferableGraphFileReader r = new TransferableGraphFileReader(channel, 0);
            int i = 0;
            while (i < 40000) {
                r.readTG();
                ++i;
            }
        }
        this.header = 0;
    }

    public TransferableGraphFileReader(ReadableByteChannel channel, int size) throws IOException {
        super(null, channel, 262144);
        this.header = 0;
    }

    public TransferableGraphFileReader(InputStream stream, int size) throws IOException {
        super(null, new InputChannel(stream), size);
        this.header = 0;
    }

    public TransferableGraphFileReader(File file, int size) throws IOException {
        super(file, size);
        this.header = HEADER;
    }

    public TransferableGraphFileReader sharedValueContext(boolean share) {
        this.shareValueContext = share;
        return this;
    }

    private static int headerSize() {
        try {
            return Bindings.getSerializerUnchecked(Datatype.class).serialize((Object)Datatypes.getDatatypeUnchecked(TransferableGraph1.class)).length;
        }
        catch (RuntimeSerializerConstructionException e) {
            throw new Error("Failed to determine TransferableGraph1 header size. ", e);
        }
        catch (RuntimeDatatypeConstructionException e) {
            throw new Error("Failed to determine TransferableGraph1 header size. ", e);
        }
        catch (IOException e) {
            throw new Error("Failed to determine TransferableGraph1 header size. ", e);
        }
    }

    public TransferableGraph1 readTG() throws IOException {
        if (this.getSize() == 0) {
            return null;
        }
        byte[] bytes = this.getBytes();
        DataInputStream dis = new DataInputStream(this.in);
        DataContainers.readHeader((DataInput)dis);
        Bindings.getSerializerUnchecked(Datatype.class).deserialize((DataInput)dis);
        int resourceCount = this.safeInt();
        ArrayList idcontext = new ArrayList();
        dis = new DataInputStream(this.in);
        Extensions extensions = (Extensions)Bindings.getSerializerUnchecked(Extensions.class).deserialize((DataInput)dis, idcontext);
        int identities = this.safeInt();
        Identity[] ids = new Identity[identities];
        int i = 0;
        while (i < identities) {
            byte type;
            int rid = this.safeInt();
            if ((type = bytes[this.byteIndex++]) == 1) {
                parent = this.safeInt();
                int nameLen = this.getDynamicUInt32();
                if (this.byteIndex + nameLen < 262144) {
                    ids[i] = new Identity(rid, new External(parent, this.utf(bytes, this.byteIndex, this.byteIndex + nameLen)));
                    this.byteIndex += nameLen;
                } else {
                    ids[i] = new Identity(rid, new External(parent, this.utf(this.safeBytes(nameLen), 0, nameLen)));
                }
            } else if (type == 3) {
                parent = this.safeInt();
                int nameLen = this.getDynamicUInt32();
                if (this.byteIndex + nameLen < 262144) {
                    ids[i] = new Identity(rid, new Internal(parent, this.utf(bytes, this.byteIndex, this.byteIndex + nameLen)));
                    this.byteIndex += nameLen;
                } else {
                    ids[i] = new Identity(rid, new Internal(parent, this.utf(this.safeBytes(nameLen), 0, nameLen)));
                }
            } else if (type == 0) {
                int nameLen = this.getDynamicUInt32();
                String name = this.utf(this.safeBytes(nameLen), 0, nameLen);
                int nameLen2 = this.getDynamicUInt32();
                String rType = this.utf(this.safeBytes(nameLen2), 0, nameLen2);
                ids[i] = new Identity(rid, new Root(name, rType));
            } else {
                if (type == 2) {
                    throw new UnsupportedOperationException();
                }
                throw new IllegalStateException();
            }
            ++i;
        }
        int stmLength = this.safeInt();
        int[] statements = new int[stmLength];
        int stmIndex = 0;
        while (stmIndex < stmLength) {
            statements[stmIndex++] = this.safeInt();
            int avail = 262144 - this.byteIndex >> 2;
            int allowed = Math.min(stmLength - stmIndex, avail);
            int index = this.byteIndex;
            int i2 = 0;
            while (i2 < allowed) {
                statements[stmIndex++] = (bytes[index++] & 0xFF) << 24 | (bytes[index++] & 0xFF) << 16 | (bytes[index++] & 0xFF) << 8 | bytes[index++] & 0xFF;
                ++i2;
            }
            this.byteIndex += allowed << 2;
        }
        int valueLength = this.safeInt();
        Value[] values = new Value[valueLength];
        Serializer variantSerializer = Bindings.getSerializerUnchecked((Binding)Bindings.VARIANT);
        dis = new DataInputStream(this.in);
        int i3 = 0;
        while (i3 < valueLength) {
            int resource = this.safeInt();
            if (!this.shareValueContext) {
                idcontext.clear();
            }
            Variant value = (Variant)variantSerializer.deserialize((DataInput)dis, idcontext);
            values[i3] = new Value(resource, value);
            ++i3;
        }
        return new TransferableGraph1(resourceCount, ids, statements, values, extensions.map);
    }

    public static void main(String[] args) {
        try {
            File file = new File("c:/users/antti villberg/desktop/test.apros");
            TransferableGraphFileReader reader = new TransferableGraphFileReader(file, 262144);
            reader = new TransferableGraphFileReader(file);
            long s = System.nanoTime();
            reader.readTG();
            long d = System.nanoTime() - s;
            LOGGER.warn("Duration=" + 1.0E-9 * (double)d + "s.");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

