/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.delta;

import gnu.trove.map.hash.THashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;

public class RouteGraphDelta
implements Serializable {
    private static final long serialVersionUID = 5011201407852172263L;
    ArrayList<RouteLine> linesOnlyInLeft = new ArrayList();
    ArrayList<RouteLine> linesOnlyInRight = new ArrayList();
    ArrayList<RouteLinePair> linesThatDiffer = new ArrayList();
    ArrayList<RouteLink> linksOnlyInLeft = new ArrayList();
    ArrayList<RouteLink> linksOnlyInRight = new ArrayList();
    ArrayList<RouteTerminal> terminalsOnlyInLeft = new ArrayList();
    ArrayList<RouteTerminal> terminalsOnlyInRight = new ArrayList();
    ArrayList<RouteTerminalPair> terminalsThatDiffer = new ArrayList();

    public Collection<RouteLine> getLinesOnlyInLeft() {
        return this.linesOnlyInLeft;
    }

    public Collection<RouteLine> getLinesOnlyInRight() {
        return this.linesOnlyInRight;
    }

    public ArrayList<RouteLinePair> getLinesThatDiffer() {
        return this.linesThatDiffer;
    }

    public Collection<RouteLink> getLinksOnlyInLeft() {
        return this.linksOnlyInLeft;
    }

    public Collection<RouteLink> getLinksOnlyInRight() {
        return this.linksOnlyInRight;
    }

    public ArrayList<RouteTerminal> getTerminalsOnlyInLeft() {
        return this.terminalsOnlyInLeft;
    }

    public ArrayList<RouteTerminal> getTerminalsOnlyInRight() {
        return this.terminalsOnlyInRight;
    }

    public ArrayList<RouteTerminalPair> getTerminalsThatDiffer() {
        return this.terminalsThatDiffer;
    }

    public RouteGraphDelta(RouteGraph left, RouteGraph right) {
        Object dataB;
        Object dataA;
        RouteLine b;
        RouteLink link;
        Object other;
        Object data;
        THashMap lineMap = new THashMap();
        for (RouteLine line : left.getLines()) {
            data = line.getData();
            if (data == null) {
                this.linesOnlyInLeft.add(line);
                continue;
            }
            lineMap.put(data, (Object)line);
        }
        for (RouteLine line : right.getLines()) {
            data = line.getData();
            if (data == null) {
                this.linesOnlyInRight.add(line);
                continue;
            }
            other = (RouteLine)lineMap.remove(data);
            if (other == null) {
                this.linesOnlyInRight.add(line);
                continue;
            }
            if (line.getPosition() == ((RouteLine)other).getPosition() && line.isHorizontal() == ((RouteLine)other).isHorizontal()) continue;
            this.linesThatDiffer.add(new RouteLinePair((RouteLine)other, line));
        }
        this.linesOnlyInLeft.addAll(lineMap.values());
        THashMap linkMap = new THashMap();
        for (RouteLine a : left.getLines()) {
            for (RoutePoint point : a.getPoints()) {
                if (!(point instanceof RouteLink)) continue;
                link = (RouteLink)point;
                b = link.getB();
                if (a != link.getA() || b.isTransient()) continue;
                dataA = a.getData();
                dataB = b.getData();
                if (dataA == null || dataB == null) {
                    this.linksOnlyInLeft.add(link);
                    continue;
                }
                linkMap.put((Object)new KeyPair(dataA, dataB), (Object)link);
            }
        }
        for (RouteLine a : right.getLines()) {
            for (RoutePoint point : a.getPoints()) {
                if (!(point instanceof RouteLink)) continue;
                link = (RouteLink)point;
                b = link.getB();
                if (a != link.getA() || b.isTransient()) continue;
                dataA = a.getData();
                dataB = b.getData();
                if (dataA != null && dataB != null && (linkMap.remove((Object)new KeyPair(dataA, dataB)) != null || linkMap.remove((Object)new KeyPair(dataB, dataA)) != null)) continue;
                this.linksOnlyInRight.add(link);
            }
        }
        this.linksOnlyInLeft.addAll(linkMap.values());
        THashMap terminalMap = new THashMap();
        for (RouteTerminal terminal : left.getTerminals()) {
            data = terminal.getData();
            if (data == null) {
                this.terminalsOnlyInLeft.add(terminal);
                continue;
            }
            terminalMap.put(data, (Object)terminal);
        }
        for (RouteTerminal terminal : right.getTerminals()) {
            data = terminal.getData();
            if (data == null) {
                this.terminalsOnlyInRight.add(terminal);
                continue;
            }
            other = (RouteTerminal)terminalMap.remove(data);
            if (other == null) {
                this.terminalsOnlyInRight.add(terminal);
                continue;
            }
            if (RouteGraphDelta.terminalsEqual((RouteTerminal)other, terminal)) continue;
            this.terminalsThatDiffer.add(new RouteTerminalPair((RouteTerminal)other, terminal));
        }
        this.terminalsOnlyInLeft.addAll(terminalMap.values());
    }

    private static boolean terminalsEqual(RouteTerminal left, RouteTerminal right) {
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        RouteLine leftLine = left.getLine();
        RouteLine rightLine = right.getLine();
        if (leftLine == null) {
            return rightLine == null;
        }
        if (rightLine == null) {
            return false;
        }
        Object leftData = leftLine.getData();
        Object rightData = rightLine.getData();
        if (leftData == null || rightData == null) {
            return false;
        }
        return leftData.equals(rightData);
    }

    public void print() {
        System.out.println("=== Delta ===");
        if (!(this.linesOnlyInLeft.isEmpty() && this.linksOnlyInLeft.isEmpty() && this.terminalsOnlyInLeft.isEmpty())) {
            System.out.println("Only in the left route graph:");
            for (RouteLine routeLine : this.linesOnlyInLeft) {
                System.out.println("    line " + String.valueOf(routeLine.getData()));
            }
            for (RouteLink routeLink : this.linksOnlyInLeft) {
                System.out.println("    <" + String.valueOf(routeLink.getA().getData()) + "," + String.valueOf(routeLink.getB().getData()) + ">");
            }
            for (RouteTerminal routeTerminal : this.terminalsOnlyInLeft) {
                System.out.println("    terminal " + String.valueOf(routeTerminal.getData()));
            }
        }
        if (!(this.linesOnlyInRight.isEmpty() && this.linksOnlyInRight.isEmpty() && this.terminalsOnlyInRight.isEmpty())) {
            System.out.println("Only in the right route graph:");
            for (RouteLine routeLine : this.linesOnlyInRight) {
                System.out.println("    line " + String.valueOf(routeLine.getData()));
            }
            for (RouteLink routeLink : this.linksOnlyInRight) {
                System.out.println("    <" + String.valueOf(routeLink.getA().getData()) + "," + String.valueOf(routeLink.getB().getData()) + ">");
            }
            for (RouteTerminal routeTerminal : this.terminalsOnlyInRight) {
                System.out.println("    terminal " + String.valueOf(routeTerminal.getData()));
            }
        }
        if (!this.linesThatDiffer.isEmpty() || !this.terminalsThatDiffer.isEmpty()) {
            System.out.println("Differing:");
            for (RouteLinePair routeLinePair : this.linesThatDiffer) {
                System.out.println("    " + String.valueOf(routeLinePair.left.getData()) + " <> " + String.valueOf(routeLinePair.right.getData()));
            }
            for (RouteTerminalPair routeTerminalPair : this.terminalsThatDiffer) {
                System.out.println("    " + String.valueOf(routeTerminalPair.left.getData()) + " (" + routeTerminalPair.left.getX() + "," + routeTerminalPair.left.getY() + ") <> " + String.valueOf(routeTerminalPair.right.getData()) + " (" + routeTerminalPair.right.getX() + "," + routeTerminalPair.right.getY() + ")");
            }
        }
    }

    public boolean isEmpty() {
        return this.linesOnlyInLeft.isEmpty() && this.linksOnlyInLeft.isEmpty() && this.terminalsOnlyInLeft.isEmpty() && this.linesOnlyInRight.isEmpty() && this.linksOnlyInRight.isEmpty() && this.terminalsOnlyInRight.isEmpty() && this.linesThatDiffer.isEmpty() && this.terminalsThatDiffer.isEmpty();
    }

    private static class KeyPair {
        final Object a;
        final Object b;

        public KeyPair(Object a, Object b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            return 31 * this.a.hashCode() + this.b.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != KeyPair.class) {
                return false;
            }
            KeyPair other = (KeyPair)obj;
            return this.a.equals(other.a) && this.b.equals(other.b);
        }
    }

    public static class RouteLinePair
    implements Serializable {
        private static final long serialVersionUID = 382349562756381086L;
        public final RouteLine left;
        public final RouteLine right;

        public RouteLinePair(RouteLine left, RouteLine right) {
            this.left = left;
            this.right = right;
        }
    }

    public static class RouteTerminalPair
    implements Serializable {
        private static final long serialVersionUID = 5286896101190626944L;
        public final RouteTerminal left;
        public final RouteTerminal right;

        public RouteTerminalPair(RouteTerminal left, RouteTerminal right) {
            this.left = left;
            this.right = right;
        }
    }
}

