/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.profile.impl;

import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.single.SingleSetSyncListener;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scenegraph.profile.ProfileEntry;
import org.simantics.scenegraph.profile.common.ProfileObserver;
import org.simantics.scenegraph.profile.impl.DebugPolicy;
import org.simantics.utils.datastructures.disposable.IDisposable;

public class ProfileActivationListener
extends SingleSetSyncListener<ProfileEntry> {
    final Resource runtime;
    final ProfileObserver observer;
    final IDisposable disposable;
    final Set<ProfileEntry> active = new HashSet<ProfileEntry>();

    public ProfileActivationListener(Resource runtime, ProfileObserver observer, IDisposable disposable) {
        this.runtime = runtime;
        this.observer = observer;
        this.disposable = disposable;
    }

    public boolean start(ReadGraph graph) throws DatabaseException {
        if (this.observer == null || this.observer.isDisposed()) {
            return false;
        }
        return this.runtime != null;
    }

    public void add(ReadGraph graph, ProfileEntry item) throws DatabaseException {
        this.observer.update();
        item.activate((RequestProcessor)graph, this.runtime, this.observer);
        this.active.add(item);
        if (DebugPolicy.DEBUG_PROFILE_STYLE_ACTIVATION) {
            System.out.println("ACTIVATED PROFILE ENTRY: " + String.valueOf(item));
        }
    }

    public void remove(ReadGraph graph, ProfileEntry item) throws DatabaseException {
        this.observer.update();
        this.active.remove(item);
        if (DebugPolicy.DEBUG_PROFILE_STYLE_ACTIVATION) {
            System.out.println("DE-ACTIVATING PROFILE ENTRY: " + String.valueOf(item));
        }
        item.deactivate(this.runtime, this.observer);
    }

    public void finished(ReadGraph graph) throws DatabaseException {
    }

    public void exception(ReadGraph graph, Throwable t) {
        Logger.defaultLogError((Throwable)t);
    }

    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    public void cleanup() {
        if (!this.active.isEmpty()) {
            for (ProfileEntry entry : this.active) {
                entry.deactivate(this.runtime, this.observer);
            }
            this.active.clear();
        }
    }
}

