/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers.e4;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.osgi.util.NLS;
import org.simantics.Simantics;
import org.simantics.simulation.experiment.ExperimentUtil;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.SimulationTimeUtil;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.ui.preferences.SimulationPreferenceUtil;
import org.simantics.simulation.ui.preferences.SimulationPreferences;

public class Step {
    static final String HANDLED_ITEM_ID = "org.simantics.simulation.ui.handledtoolitem.step";
    @Inject
    EModelService modelService;

    @PostConstruct
    public void updateToolTip(MApplication application) {
        MHandledItem handledItem = (MHandledItem)this.modelService.find(HANDLED_ITEM_ID, (MUIElement)application);
        if (handledItem != null) {
            Step.updateItem((MUILabel)handledItem);
        }
    }

    @CanExecute
    public boolean canExecute() {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (manager == null) {
            return false;
        }
        IExperiment experiment = manager.getActiveExperiment();
        return experiment != null;
    }

    @Execute
    public void execute() {
        SimulationPreferences prefs = SimulationPreferenceUtil.getPrefs();
        switch (prefs.stepMode) {
            case DURATION: {
                ExperimentUtil.step((double)prefs.stepDuration);
                break;
            }
            case END_TIME: {
                ExperimentUtil.stepUntil((double)prefs.stepEndTime);
            }
        }
    }

    @Inject
    @Optional
    public void updateElement(@Optional @UIEventTopic(value="org/simantics/simulation/step/*") Object changed, MApplication application) {
        MHandledItem handledItem = (MHandledItem)this.modelService.find(HANDLED_ITEM_ID, (MUIElement)application);
        if (handledItem != null) {
            Step.updateItem((MUILabel)handledItem);
        }
    }

    private static void updateItem(MUILabel item) {
        SimulationPreferences prefs = SimulationPreferenceUtil.getPrefs();
        switch (prefs.stepMode) {
            case DURATION: {
                item.setTooltip(NLS.bind((String)"Step {0} s ({1})", (Object)SimulationTimeUtil.formatSeconds((double)prefs.stepDuration), (Object)SimulationTimeUtil.formatHMSS((double)prefs.stepDuration)));
                break;
            }
            case END_TIME: {
                item.setTooltip(NLS.bind((String)"Step Until Simulation Time Reaches {0} s ({1})", (Object)SimulationTimeUtil.formatSeconds((double)prefs.stepEndTime), (Object)SimulationTimeUtil.formatHMSS((double)prefs.stepEndTime)));
            }
        }
    }
}

