/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.wizards.modules;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.graph.db.TGStatusMonitor;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.datastructures.Pair;

public class WizardModulesExportPage
extends WizardPage {
    private Text filePathField;
    private static String previouslyBrowsedFile = "";
    private Button browseDirectoriesButton;
    private Resource selectedModule;
    GraphExplorerComposite modelExplorer;
    private boolean selectionMade = false;

    public WizardModulesExportPage() {
        this("wizardModulesExportPage", null, null);
    }

    public WizardModulesExportPage(String pageName) {
        this(pageName, null, null);
    }

    public WizardModulesExportPage(String pageName, String initialPath, IStructuredSelection currentSelection) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle("Export Module");
        this.setDescription("Choose the Module and the export location, then press Finish.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createTree(workArea);
    }

    private void createProjectsRoot(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Select the export location for Module:");
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.filePathField = new Text(projectGroup, 2048);
        GridData directoryPathData = new GridData(4, 0, true, false);
        directoryPathData.widthHint = new PixelConverter((Control)this.filePathField).convertWidthInCharsToPixels(25);
        this.filePathField.setLayoutData((Object)directoryPathData);
        this.filePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                previouslyBrowsedFile = WizardModulesExportPage.this.filePathField.getText();
            }
        });
        if (previouslyBrowsedFile != null) {
            this.filePathField.setText(previouslyBrowsedFile);
            this.validatePage();
        }
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText("Browse");
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardModulesExportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
    }

    private void createTree(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Select Module to export:");
        Resource input = (Resource)Simantics.getProject().get();
        this.modelExplorer = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), null, workArea, 2052);
        this.modelExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/ExportModuleTree"});
        this.modelExplorer.finish();
        this.modelExplorer.setInput(null, (Object)input);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.modelExplorer);
        ((Tree)this.modelExplorer.getExplorer().getControl()).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WizardModulesExportPage.this.setMessage(null);
                WizardModulesExportPage.this.selectionMade = true;
                WizardModulesExportPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                WizardModulesExportPage.this.setMessage(null);
                WizardModulesExportPage.this.selectionMade = true;
                WizardModulesExportPage.this.validatePage();
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.filePathField.setFocus();
    }

    protected void handleLocationDirectoryButtonPressed() {
        String selectedFile;
        Shell shell = this.filePathField.getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        String[] ext = new String[]{"*.sysdynModule"};
        dialog.setFilterExtensions(ext);
        dialog.setText("Export Module");
        String dirName = this.filePathField.getText().trim();
        File path = new File(dirName);
        if (path.exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedFile = dialog.open()) != null) {
            this.filePathField.setText(selectedFile);
            this.validatePage();
        }
    }

    public static <T> T getExplorerResource(GraphExplorerComposite explorer, Class<T> clazz) {
        if (explorer == null) {
            return null;
        }
        ISelection selection = ((ISelectionProvider)explorer.getAdapter(ISelectionProvider.class)).getSelection();
        if (selection == null) {
            return null;
        }
        IStructuredSelection iss = (IStructuredSelection)selection;
        AdaptableHintContext inc = (AdaptableHintContext)iss.getFirstElement();
        if (inc == null) {
            return null;
        }
        Object resource = inc.getAdapter(clazz);
        return (T)resource;
    }

    public boolean createProjects() {
        final String selected = previouslyBrowsedFile;
        if (selected == null) {
            return false;
        }
        this.selectedModule = WizardModulesExportPage.getExplorerResource(this.modelExplorer, Resource.class);
        if (this.selectedModule == null) {
            return false;
        }
        String name = null;
        try {
            name = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)graph);
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource component = WizardModulesExportPage.this.selectedModule;
                    if (component == null || !graph.hasStatement(component, Layer0.getInstance((ReadGraph)graph).PartOf)) {
                        return null;
                    }
                    Resource configuration = graph.getPossibleObject(component, sr2.IsDefinedBy);
                    if (configuration == null) {
                        return null;
                    }
                    ArrayList<String> dependencies = null;
                    for (Resource r : (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, sr.Module))) {
                        if (dependencies == null) {
                            dependencies = new ArrayList<String>();
                        }
                        String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                        String instanceOf = NameUtils.getSafeName((ReadGraph)graph, (Resource)graph.getSingleObject(r, l0.InstanceOf));
                        dependencies.add(name + " : " + instanceOf);
                    }
                    if (dependencies != null && !dependencies.isEmpty()) {
                        throw new ContainsDependenciesException(dependencies);
                    }
                    String name = (String)graph.getPossibleRelatedValue(component, l0.HasName, (Binding)Bindings.STRING);
                    return name;
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        if (name == null) {
            return false;
        }
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                final Resource component = WizardModulesExportPage.this.selectedModule;
                if (component == null || !graph.hasStatement(component, Layer0.getInstance((ReadGraph)graph).PartOf)) {
                    return;
                }
                graph.asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)graph);
                        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                        Resource modulesymbol = graph.getPossibleObject(component, mr.ComponentTypeToSymbol);
                        Resource configuration = graph.getPossibleObject(component, sr2.IsDefinedBy);
                        if (!graph.hasStatement(configuration, l0.PartOf, component) && !graph.hasStatement(modulesymbol, l0.PartOf, component)) {
                            Resource previousPartof = graph.getSingleObject(configuration, l0.PartOf);
                            graph.deny(configuration, l0.PartOf);
                            graph.deny(modulesymbol, l0.PartOf);
                            graph.claim(configuration, l0.PartOf, l0.ConsistsOf, component);
                            graph.claim(modulesymbol, l0.PartOf, l0.ConsistsOf, component);
                            WizardModulesExportPage.this.export(graph, selected, component);
                            graph.deny(configuration, l0.PartOf);
                            graph.deny(modulesymbol, l0.PartOf);
                            graph.claim(configuration, l0.PartOf, l0.ConsistsOf, previousPartof);
                            graph.claim(modulesymbol, l0.PartOf, l0.ConsistsOf, previousPartof);
                        } else {
                            WizardModulesExportPage.this.export(graph, selected, component);
                        }
                    }
                }, e -> Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.sysdyn.ui", "Failed to export module, see exception for details.", (Throwable)e)));
            }
        });
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void export(WriteGraph graph, String path, Resource component) throws DatabaseException {
        l0 = Layer0.getInstance((ReadGraph)graph);
        sr = SysdynResource.getInstance((ReadGraph)graph);
        sr2 = StructuralResource2.getInstance((ReadGraph)graph);
        configuration = graph.getPossibleObject(component, sr2.IsDefinedBy);
        replacements = new ArrayList<Pair>();
        var10_9 = ((Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, sr.Enumeration))).iterator();
        while (true) {
            if (!var10_9.hasNext()) break;
            enumeration = (Resource)var10_9.next();
            if (!graph.hasStatement(enumeration, sr.Redeclaration_replacedEnumeration_Inverse)) continue;
            var12_17 = graph.getObjects(enumeration, sr.Redeclaration_replacedEnumeration_Inverse).iterator();
            while (true) {
                if (!var12_17.hasNext()) ** break;
                replacement = (Resource)var12_17.next();
                replacements.add(Pair.make((Object)enumeration, (Object)replacement));
            }
            break;
        }
        var10_9 = replacements.iterator();
        while (true) {
            if (!var10_9.hasNext()) {
                ** try [egrp 0[TRYBLOCK] [5 : 234->400)] { 
lbl22:
                // 1 sources

                break;
            }
            replacement = (Pair)var10_9.next();
            graph.deny((Resource)replacement.first, sr.Redeclaration_replacedEnumeration_Inverse, (Resource)replacement.second);
        }
        {
            block19: {
                try {
                    conf = new TransferableGraphConfiguration2((ReadGraph)graph, component);
                    try {
                        var10_9 = null;
                        var11_15 = null;
                        try {
                            tgs = (TransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf));
                            try {
                                TransferableGraphs.writeTransferableGraph((RequestProcessor)graph, (TransferableGraphSource)tgs, (File)new File(path), (TGStatusMonitor)TGStatusMonitor.NULL_MONITOR);
                                if (tgs == null) break block19;
                            }
                            catch (Throwable var10_10) {
                                if (tgs == null) throw var10_10;
                                tgs.close();
                                throw var10_10;
                            }
                            tgs.close();
                        }
                        catch (Throwable var11_16) {
                            if (var10_9 == null) {
                                var10_9 = var11_16;
                                throw var10_9;
                            }
                            if (var10_9 == var11_16) throw var10_9;
                            var10_9.addSuppressed(var11_16);
                            throw var10_9;
                        }
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.sysdyn.ui", "Failed to export module, see exception for details.", (Throwable)e));
                    }
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
lbl57:
                // 1 sources

                finally {
                    var15_20 = replacements.iterator();
                    break;
                }
            }
        }
        while (true) {
            if (!var15_20.hasNext()) {
                return;
            }
            replacement = (Pair)var15_20.next();
            graph.claim((Resource)replacement.first, sr.Redeclaration_replacedEnumeration_Inverse, (Resource)replacement.second);
        }
    }

    void validatePage() {
        if (previouslyBrowsedFile.isEmpty() || !this.selectionMade) {
            this.setPageComplete(false);
            return;
        }
        if (this.modelExplorer != null) {
            final Resource selectedResource = WizardModulesExportPage.getExplorerResource(this.modelExplorer, Resource.class);
            String root = null;
            try {
                root = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                    public String perform(ReadGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        Resource model = graph.getPossibleObject(selectedResource, l0.PartOf);
                        String rootName = NameUtils.getSafeName((ReadGraph)graph, (Resource)model);
                        return rootName;
                    }
                });
                if (root != null && root.equalsIgnoreCase("Development Project")) {
                    this.setPageComplete(false);
                    this.setMessage("Select Module under the Model.");
                    return;
                }
            }
            catch (DatabaseException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.sysdyn.ui", "Failed to validate wizard page contents, see exception for details.", (Throwable)e));
            }
        }
        this.setPageComplete(true);
    }

    class ContainsDependenciesException
    extends DatabaseException {
        private static final long serialVersionUID = -1533706136673146020L;
        private Collection<String> dependencies;

        ContainsDependenciesException(Collection<String> dependencies) {
            this.dependencies = dependencies;
        }

        public Collection<String> getDependencies() {
            return this.dependencies;
        }
    }
}

