/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.expressionParser.Token;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.ui.utils.ExpressionUtils;
import org.simantics.sysdyn.ui.utils.SyntaxError;
import org.simantics.sysdyn.ui.validation.IssueWithStringContext;
import org.simantics.sysdyn.ui.validation.References;
import org.simantics.sysdyn.ui.validation.ValidationUtils;
import org.simantics.utils.datastructures.collections.CollectionUtils;

public class DependencyFunction {
    private static Set<String> GLOBAL_VARIABLES = CollectionUtils.toSet((Object[])new String[]{"time", "startTime", "stopTime", "timeStep"});

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> dependencyValidator(ReadGraph graph, Resource component) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(component, sr.IndependentVariable)) {
            return Collections.emptyList();
        }
        if (!graph.hasStatement(component) || !graph.hasStatement(component, l0.PartOf)) {
            return Collections.emptyList();
        }
        ArrayList<Issue> result = new ArrayList<Issue>();
        Set<String> references = null;
        try {
            references = ValidationUtils.getAllReferences(graph, component).getVariableReferences();
        }
        catch (Exception e) {
            return result;
        }
        HashSet<String> dependencies = ValidationUtils.getDependencies(graph, component);
        if (dependencies != null) {
            for (String dependency : dependencies) {
                if (references != null && references.contains(dependency)) continue;
                result.add((Issue)new IssueWithStringContext(sr.Validations_UnusedDependencyIssue, component, dependency));
            }
        }
        return result;
    }

    private static Configuration getConfiguration(ReadGraph graph, Resource component) throws DatabaseException {
        Resource configuration = graph.getPossibleObject(component, Layer0.getInstance((ReadGraph)graph).PartOf);
        if (configuration == null) {
            return null;
        }
        SysdynModelManager smm = SysdynModelManager.getInstance((Session)graph.getSession());
        SysdynModel sm = smm.getModel(graph, configuration);
        if (sm == null) {
            return null;
        }
        sm.update(graph);
        return sm.getConfiguration();
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> missingDependencyValidator(ReadGraph graph, Resource component) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(component, sr.IndependentVariable)) {
            return Collections.emptyList();
        }
        if (!graph.hasStatement(component) || !graph.hasStatement(component, l0.PartOf)) {
            return Collections.emptyList();
        }
        References references = null;
        try {
            references = ValidationUtils.getAllReferences(graph, component);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        Configuration configuration = DependencyFunction.getConfiguration(graph, component);
        ArrayList<Issue> result = new ArrayList<Issue>();
        for (Resource expressionResource : references.forIndices.keySet()) {
            if (!references.forIndices.containsKey(expressionResource)) continue;
            for (Token token : references.forIndices.get(expressionResource).keySet()) {
                if (!references.references.containsKey(expressionResource) || !references.references.get(expressionResource).containsKey(token.image)) continue;
                references.references.get(expressionResource).remove(token.image);
            }
        }
        for (Resource expressionResource : references.functionReferences.keySet()) {
            for (String functionKey : references.functionReferences.get(expressionResource).keySet()) {
                List<SyntaxError> sheetErrors = ExpressionUtils.examineSheetReferences(configuration, functionKey, references.functionReferences.get(expressionResource).get(functionKey), references.expressions.get(expressionResource), references.references.get(expressionResource));
                if (sheetErrors == null) continue;
                for (SyntaxError error : sheetErrors) {
                    result.add((Issue)new IssueWithStringContext(sr.Validations_InvalidSheetReferenceIssue, component, error.getMessage(), error.getImage()));
                }
            }
        }
        Set<String> variablesReferences = references.getVariableReferences();
        if (variablesReferences == null || variablesReferences.isEmpty()) {
            return result;
        }
        String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)component);
        if (name != null && variablesReferences.contains(name)) {
            variablesReferences.remove(name);
        }
        HashSet<String> dependencies = ValidationUtils.getDependencies(graph, component);
        dependencies.addAll(GLOBAL_VARIABLES);
        for (String dependency : dependencies) {
            variablesReferences.remove(dependency);
        }
        boolean isStock = DependencyFunction.isStock(graph, component);
        for (String reference : variablesReferences) {
            ExpressionUtils.ReferenceOption option = ExpressionUtils.getReferenceOption(configuration, reference);
            switch (option) {
                case DOES_NOT_EXIST: {
                    result.add((Issue)new IssueWithStringContext(sr.Validations_NoSuchVariableIssue, component, reference));
                }
                case CAN_BE_CONNECTED: {
                    if (isStock) break;
                    result.add((Issue)new IssueWithStringContext(sr.Validations_MissingLinkIssue, component, reference));
                }
            }
        }
        for (Resource expression : references.ranges.keySet()) {
            ArrayList<SyntaxError> errors = new ArrayList<SyntaxError>();
            errors.addAll(ExpressionUtils.examineArrayRanges(graph, configuration, references.ranges.get(expression), references.forIndices.get(expression)));
            errors.addAll(ExpressionUtils.examineEnumerationReferences(configuration, references.enumerationReferences.get(expression)));
            for (SyntaxError error : errors) {
                Resource type = sr.Validations_RangeIssue;
                if ("SyntaxWarning".equals(error.getType())) {
                    type = sr.Validations_RangeWarning;
                }
                result.add((Issue)new IssueWithStringContext(type, component, error.getMessage()));
            }
        }
        return result;
    }

    private static boolean isStock(ReadGraph graph, Resource variable) throws DatabaseException {
        List<Resource> expressionList = ValidationUtils.getExpressions(graph, variable);
        if (expressionList == null || expressionList.isEmpty()) {
            return false;
        }
        for (Resource expression : expressionList) {
            if (graph.isInstanceOf(expression, SysdynResource.getInstance((ReadGraph)graph).StockExpression)) continue;
            return false;
        }
        return true;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String missingLinkIssueDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        List<String> contexts = IssueWithStringContext.getStringContexts(graph, property);
        Object result = "Missing a link to ";
        if (contexts.size() > 0) {
            result = (String)result + contexts.get(0);
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String unusedDependencyIssueDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        List<String> contexts = IssueWithStringContext.getStringContexts(graph, property);
        Object result = "Unused dependency: ";
        if (contexts.size() > 0) {
            result = (String)result + contexts.get(0);
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String noSuchVariableIssueDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        List<String> contexts = IssueWithStringContext.getStringContexts(graph, property);
        Object result = "Refers to unexisting variable ";
        if (contexts.size() > 0) {
            result = (String)result + contexts.get(0);
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String invalidSheetReferenceIssueDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        List<String> contexts = IssueWithStringContext.getStringContexts(graph, property);
        Object result = "";
        result = contexts.size() == 2 ? contexts.get(0) + ": " + contexts.get(1) : "Spreadsheet reference error";
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String rangeIssueDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        List<String> contexts = IssueWithStringContext.getStringContexts(graph, property);
        if (contexts.size() > 0) {
            return contexts.get(0);
        }
        return "Range Issue";
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String rangeWarningDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        return DependencyFunction.rangeIssueDescription(graph, converter, property);
    }
}

