/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedCombo;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ComboModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Write;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.utils.LoopUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;

public class LoopTab
extends AdjustableTab {
    private Label loopItemsLabel;
    private TrackedCombo loopItemsDropdown;
    Button auto;
    Button balancing;
    Button reinforcing;
    Button other;
    Button inside;
    Button outside;
    TrackedText loopComment;
    TrackedText polarityLocationText;
    Composite loopItems;
    Group commentGroup;
    Group rotationGroup;
    protected Resource resource;
    public static final String AUTO = "$$AUTO$$";

    public LoopTab(Object id) {
        super(id);
    }

    protected void createAndAddControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        this.composite = new Composite(body, 0);
        this.loopItems = new Composite(this.composite, 0);
        this.loopItemsLabel = new Label(this.loopItems, 4);
        this.loopItemsLabel.setText("Loop Items:");
        this.loopItemsDropdown = new TrackedCombo(this.loopItems, support, 2060);
        this.commentGroup = new Group(this.composite, 0);
        this.commentGroup.setText("Comment");
        this.auto = new Button((Composite)this.commentGroup, support, 16);
        this.auto.setText("Auto");
        this.auto.setSelectionFactory((ReadFactory)new CommentRadioSelectionFactory(AUTO));
        this.auto.addSelectionListener((SelectionListener)new CommentSelectionListener(context, AUTO));
        this.balancing = new Button((Composite)this.commentGroup, support, 16);
        this.balancing.setText("B");
        this.balancing.setSelectionFactory((ReadFactory)new CommentRadioSelectionFactory("B"));
        this.balancing.addSelectionListener((SelectionListener)new CommentSelectionListener(context, "B"));
        this.reinforcing = new Button((Composite)this.commentGroup, support, 16);
        this.reinforcing.setText("R");
        this.reinforcing.setSelectionFactory((ReadFactory)new CommentRadioSelectionFactory("R"));
        this.reinforcing.addSelectionListener((SelectionListener)new CommentSelectionListener(context, "R"));
        this.other = new Button((Composite)this.commentGroup, support, 16);
        this.other.setText("other");
        String[] stringArray = new String[4];
        stringArray[1] = "B";
        stringArray[2] = "R";
        stringArray[3] = AUTO;
        this.other.setSelectionFactory((ReadFactory)new OtherCommentSelectionFactory(stringArray));
        this.other.addSelectionListener((SelectionListener)new CommentSelectionListener(context, ""));
        this.loopComment = new TrackedText((Composite)this.commentGroup, support, 2048);
        this.loopComment.setTextFactory((ReadFactory)new OtherCommentStringPropertyFactory());
        this.loopComment.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/Loop/Comment"));
        this.rotationGroup = new Group(this.composite, 0);
        this.rotationGroup.setText("Direction of Rotation");
        this.inside = new Button((Composite)this.rotationGroup, support, 16);
        this.inside.setText("Clockwise");
        this.inside.setSelectionFactory((ReadFactory)new ClockwiseRotationRadioSelectionFactory(true));
        this.inside.addSelectionListener((SelectionListener)new ClockwiseRotationSelectionListener(context, true));
        this.outside = new Button((Composite)this.rotationGroup, support, 16);
        this.outside.setText("Counterclockwise");
        this.outside.setSelectionFactory((ReadFactory)new ClockwiseRotationRadioSelectionFactory(false));
        this.outside.addSelectionListener((SelectionListener)new ClockwiseRotationSelectionListener(context, false));
        this.addListeners(context);
    }

    private void addListeners(ISessionContext context) {
        this.loopItemsDropdown.setItemFactory((ReadFactory)new ReadFactoryImpl<Resource, Map<String, Object>>(){

            public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
                LoopTab.this.resource = input;
                HashMap<String, Object> map = new HashMap<String, Object>();
                List loops = LoopUtils.getAllLoopsInDiagram((ReadGraph)graph, (Resource)input);
                map.put("", null);
                for (List loop : loops) {
                    map.put(LoopUtils.cycleToString((ReadGraph)graph, (List)loop), loop);
                }
                return map;
            }
        });
        this.loopItemsDropdown.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, String>(){

            public String perform(ReadGraph graph, Resource input) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Resource itemListResource = graph.getPossibleObject(input, sr.Loop_Items);
                if (itemListResource == null) {
                    return "";
                }
                List itemList = ListUtils.toPossibleList((ReadGraph)graph, (Resource)itemListResource);
                if (itemList == null) {
                    return "";
                }
                List loops = LoopUtils.getAllLoopsInDiagram((ReadGraph)graph, (Resource)input);
                Resource first = (Resource)itemList.get(0);
                for (List loop : loops) {
                    int indexOfFirst;
                    if (loop.size() != itemList.size() || (indexOfFirst = loop.indexOf(first)) < 0) continue;
                    boolean match = true;
                    int i = 1;
                    do {
                        Resource next;
                        if ((next = (Resource)loop.get((i + indexOfFirst) % loop.size())).equalsResource((Resource)itemList.get(i))) continue;
                        match = false;
                        break;
                    } while (++i != itemList.size());
                    if (!match) continue;
                    return LoopUtils.cycleToString((ReadGraph)graph, (List)loop);
                }
                return "";
            }
        });
        this.loopItemsDropdown.addModifyListener((TextModifyListener)new ComboModifyListenerImpl<Resource>(){

            public void applyText(WriteGraph graph, final Resource input, String text) throws DatabaseException {
                final Combo c = LoopTab.this.loopItemsDropdown.getWidget();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Object o = c.getData();
                        if (o != null && !(o instanceof HashMap)) {
                            return;
                        }
                        Object loopObject = ((HashMap)o).get(c.getText());
                        if (loopObject == null || !(loopObject instanceof List)) {
                            return;
                        }
                        final List loop = (List)loopObject;
                        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                                Resource loopResource = graph.getPossibleObject(input, sr.Loop_Items);
                                if (loopResource != null) {
                                    List removedList = ListUtils.toPossibleList((ReadGraph)graph, (Resource)loopResource);
                                    for (Resource r : removedList) {
                                        ListUtils.removeElement((WriteGraph)graph, (Resource)loopResource, (Resource)r);
                                    }
                                    graph.deny(loopResource);
                                }
                                Resource newList = ListUtils.create((WriteGraph)graph, (Iterable)loop);
                                graph.claim(input, sr.Loop_Items, newList);
                            }
                        });
                    }
                });
            }
        });
    }

    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.loopItems);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.loopItems);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.loopItemsLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.loopItemsDropdown.getWidget());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(1).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.commentGroup);
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo((Composite)this.commentGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.loopComment.getWidget());
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.rotationGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.rotationGroup);
    }

    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.loopItems);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.loopItems);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.loopItemsLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.loopItemsDropdown.getWidget());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.commentGroup);
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo((Composite)this.commentGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.loopComment.getWidget());
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.rotationGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.rotationGroup);
    }

    class ClockwiseRotationRadioSelectionFactory
    extends ReadFactoryImpl<Resource, Boolean> {
        private boolean clockwise;

        public ClockwiseRotationRadioSelectionFactory(boolean clockwise) {
            this.clockwise = clockwise;
        }

        public Object getIdentity(Object inputContents) {
            return new Triple(inputContents, (Object)this.clockwise, ((Object)((Object)this)).getClass());
        }

        public Boolean perform(ReadGraph graph, Resource component) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
            Resource symbol = graph.getPossibleObject(component, mr.ComponentToElement);
            if (symbol != null) {
                Boolean clockwise = (Boolean)graph.getPossibleRelatedValue(symbol, sr.LoopSymbol_Clockwise, (Binding)Bindings.BOOLEAN);
                return ObjectUtils.objectEquals((Object)this.clockwise, (Object)clockwise);
            }
            return Boolean.TRUE;
        }
    }

    class ClockwiseRotationSelectionListener
    extends SelectionListenerImpl<Resource> {
        private boolean clockwise;

        public ClockwiseRotationSelectionListener(ISessionContext context, boolean clockwise) {
            super(context);
            this.clockwise = clockwise;
        }

        public void apply(WriteGraph graph, Resource component) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
            Resource symbol = graph.getPossibleObject(component, mr.ComponentToElement);
            if (symbol != null) {
                graph.deny(symbol, sr.LoopSymbol_Clockwise);
                graph.claimLiteral(symbol, sr.LoopSymbol_Clockwise, (Object)this.clockwise);
            }
        }
    }

    class CommentRadioSelectionFactory
    extends ReadFactoryImpl<Resource, Boolean> {
        private String comment;

        public CommentRadioSelectionFactory(String comment) {
            this.comment = comment;
        }

        public Object getIdentity(Object inputContents) {
            return new Triple(inputContents, (Object)this.comment, ((Object)((Object)this)).getClass());
        }

        public Boolean perform(ReadGraph graph, Resource dependencyConnection) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            String comment = (String)graph.getPossibleRelatedValue(dependencyConnection, sr.Loop_Comment, (Binding)Bindings.STRING);
            if (comment == null && this.comment.equals("")) {
                return true;
            }
            return ObjectUtils.objectEquals((Object)comment, (Object)this.comment);
        }
    }

    class CommentSelectionListener
    extends SelectionListenerImpl<Resource> {
        private String comment;

        public CommentSelectionListener(ISessionContext context, String comment) {
            super(context);
            this.comment = comment;
        }

        public void apply(WriteGraph graph, Resource connectionElement) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            graph.deny(connectionElement, sr.Loop_Comment);
            graph.claimLiteral(connectionElement, sr.Loop_Comment, (Object)this.comment.trim());
        }
    }

    class OtherCommentSelectionFactory
    extends ReadFactoryImpl<Resource, Boolean> {
        String[] limits;

        public OtherCommentSelectionFactory(String[] limits) {
            this.limits = limits;
        }

        public Object getIdentity(Object inputContents) {
            return new Pair(inputContents, ((Object)((Object)this)).getClass());
        }

        public Boolean perform(ReadGraph graph, Resource dependencyConnection) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            String comment = (String)graph.getPossibleRelatedValue(dependencyConnection, sr.Loop_Comment, (Binding)Bindings.STRING);
            String[] stringArray = this.limits;
            int n = this.limits.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (ObjectUtils.objectEquals((Object)comment, (Object)s)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    class OtherCommentStringPropertyFactory
    extends ReadFactoryImpl<Resource, String> {
        private final String propertyURI;

        public OtherCommentStringPropertyFactory() {
            this.propertyURI = "http://www.simantics.org/Sysdyn-1.1/Loop/Comment";
        }

        public Object getIdentity(Object inputContents) {
            return new Triple((Object)((Resource)inputContents), (Object)this.propertyURI, ((Object)((Object)this)).getClass());
        }

        public String perform(ReadGraph graph, Resource resource) throws DatabaseException {
            String value = (String)graph.getPossibleRelatedValue(resource, graph.getResource(this.propertyURI));
            if (value == null || LoopTab.AUTO.equals(value)) {
                return "";
            }
            return value;
        }
    }
}

