/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.sysdyn.ui.properties.widgets.FunctionLabelFactory;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionField;
import org.simantics.sysdyn.ui.properties.widgets.factories.FunctionNameInputValidator;
import org.simantics.sysdyn.ui.properties.widgets.functions.FunctionCodeWidget;
import org.simantics.sysdyn.utils.SelectionUtils;

public class FunctionTab
extends AdjustableTab {
    ExpressionField modelicaCode;
    private TrackedText nameText;
    private Group modelicaGroup;
    private Label startLabel;
    private Label endLabel;
    private Group documentationGroup;
    private TrackedText information;

    public FunctionTab(Object id) {
        super(id);
    }

    protected void createAndAddControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        this.composite = new Composite(body, 0);
        this.nameText = new TrackedText(this.composite, support, 2048);
        this.nameText.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasName"));
        this.nameText.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasName"));
        this.nameText.setInputValidator((IInputValidator)new FunctionNameInputValidator(support));
        this.modelicaGroup = new Group(this.composite, 16);
        this.modelicaGroup.setText("Modelica code");
        this.startLabel = new Label((Composite)this.modelicaGroup, support, 0);
        this.startLabel.setTextFactory((ReadFactory)new FunctionLabelFactory("http://www.simantics.org/Layer0-1.1/HasName", false));
        new FunctionCodeWidget((Composite)this.modelicaGroup, support, 2048);
        this.endLabel = new Label((Composite)this.modelicaGroup, support, 0);
        this.endLabel.setTextFactory((ReadFactory)new FunctionLabelFactory("http://www.simantics.org/Layer0-1.1/HasName", true));
        this.documentationGroup = new Group(this.composite, 16);
        this.documentationGroup.setText("Documentation");
        this.information = new TrackedText((Composite)this.documentationGroup, support, 578);
        this.information.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasDescription"));
        this.information.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasDescription"));
        if (this.id instanceof Resource) {
            final Resource r = (Resource)this.id;
            try {
                boolean editable = (Boolean)context.getSession().syncRequest((Read)new Read<Boolean>(){

                    public Boolean perform(ReadGraph graph) throws DatabaseException {
                        return SelectionUtils.canEdit((ReadGraph)graph, (Resource)r);
                    }
                });
                this.information.setEditable(editable);
                this.nameText.setEditable(editable);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }

    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)this.nameText.getWidget());
        GridDataFactory.fillDefaults().grab(true, true).minSize(150, 0).applyTo((Control)this.modelicaGroup);
        GridLayoutFactory.fillDefaults().spacing(0, 0).margins(3, 3).applyTo((Composite)this.modelicaGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.documentationGroup);
        GridLayoutFactory.fillDefaults().spacing(0, 0).margins(3, 3).applyTo((Composite)this.documentationGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.information.getWidget());
    }

    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.nameText.getWidget());
        GridDataFactory.fillDefaults().grab(true, true).minSize(150, 0).applyTo((Control)this.modelicaGroup);
        GridLayoutFactory.fillDefaults().spacing(0, 0).margins(3, 3).applyTo((Composite)this.modelicaGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.documentationGroup);
        GridLayoutFactory.fillDefaults().spacing(0, 0).margins(3, 3).applyTo((Composite)this.documentationGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.information.getWidget());
    }
}

