/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.management.ISessionContext;
import org.simantics.jfreechart.chart.properties.LabelPropertyTabContributor;
import org.simantics.sysdyn.ui.handlers.exports.ExportExternalFunctionFilesHandler;
import org.simantics.sysdyn.ui.handlers.imports.ImportExternalFunctionFilesHandler;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.SWTThread;

public class ExternalFilesTab
extends LabelPropertyTabContributor
implements Widget {
    GraphExplorerComposite externalFilesExplorer;
    Button importButton;
    Button exportButton;
    Button removeButton;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            ISelection selection = ((ISelectionProvider)ExternalFilesTab.this.externalFilesExplorer.getAdapter(ISelectionProvider.class)).getSelection();
            IStructuredSelection iss = (IStructuredSelection)selection;
            List selections = iss.toList();
            boolean enabled = false;
            if (!selections.isEmpty()) {
                enabled = true;
            }
            ExternalFilesTab.this.removeButton.getControl().setEnabled(enabled);
            ExternalFilesTab.this.exportButton.getControl().setEnabled(enabled);
        }
    };

    public ExternalFilesTab(Object id) {
        super(id);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        support.register((Widget)this);
        Composite composite = new Composite(body, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(composite);
        this.externalFilesExplorer = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), site, composite, 67586);
        this.externalFilesExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/ExternalFiles"});
        this.externalFilesExplorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        this.externalFilesExplorer.setContextMenuId("#ExternalFunctionFileBrowser");
        this.externalFilesExplorer.addListenerToControl(13, new Listener(){

            public void handleEvent(Event event) {
                ExternalFilesTab.this.updateButtons(ExternalFilesTab.this.externalFilesExplorer);
            }
        });
        this.externalFilesExplorer.finish();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.externalFilesExplorer);
        Control c = (Control)this.externalFilesExplorer.getExplorerControl();
        if (c instanceof Tree) {
            ((Tree)c).setLinesVisible(true);
        }
        Composite buttonRow = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(buttonRow);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonRow);
        this.importButton = new Button(buttonRow, support, 0);
        this.importButton.setText("Import");
        this.importButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){
            private Pair<String, String[]> importedFiles;

            public void beforeApply() {
                Shell shell = ExternalFilesTab.this.importButton.getWidget().getShell();
                this.importedFiles = ImportExternalFunctionFilesHandler.importFiles(shell, "Import files", ImportExternalFunctionFilesHandler.C_EXTENSIONS);
            }

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                graph.markUndoPoint();
                ImportExternalFunctionFilesHandler.addFilesToFunction(graph, input, this.importedFiles);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Imported External File(s) " + Arrays.toString((Object[])this.importedFiles.second) + " to " + NameUtils.getSafeName((ReadGraph)graph, (Resource)input)));
                ExternalFilesTab.this.updateButtons(ExternalFilesTab.this.externalFilesExplorer);
            }
        });
        this.exportButton = new Button(buttonRow, support, 0);
        this.exportButton.setText("Export");
        this.exportButton.getControl().setEnabled(false);
        this.exportButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                ExternalFilesTab.this.exportButton.getWidget().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = (this).ExternalFilesTab.this.exportButton.getWidget().getShell();
                        List<Resource> resourceList = ExternalFilesTab.this.getSelectedResources((this).ExternalFilesTab.this.externalFilesExplorer);
                        Resource[] resources = resourceList.toArray(new Resource[resourceList.size()]);
                        if (resources.length > 0) {
                            ExportExternalFunctionFilesHandler.exportFiles(shell, resources);
                        }
                    }
                });
            }
        });
        this.removeButton = new Button(buttonRow, support, 0);
        this.removeButton.setText("Remove");
        this.removeButton.getControl().setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){
            private int delete;
            private List<Resource> resourceList;

            public void beforeApply() {
                Shell shell = ExternalFilesTab.this.removeButton.getWidget().getShell();
                this.resourceList = ExternalFilesTab.this.getSelectedResources(ExternalFilesTab.this.externalFilesExplorer);
                Resource[] resources = this.resourceList.toArray(new Resource[this.resourceList.size()]);
                if (resources.length > 0) {
                    MessageDialog dialog = new MessageDialog(shell, resources.length > 1 ? "Remove selected items" : "Remove selected item", null, "Are you sure?", 0, new String[]{"OK", "Cancel"}, 0);
                    dialog.create();
                    this.delete = dialog.open();
                }
            }

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                if (this.delete == 0) {
                    Resource[] resources = this.resourceList.toArray(new Resource[this.resourceList.size()]);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Removed External File(s) ");
                    Resource[] resourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Resource resource = resourceArray[n2];
                        RemoverUtil.remove((WriteGraph)graph, (Resource)resource);
                        sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)resource) + " ");
                        ++n2;
                    }
                    sb.append("from " + NameUtils.getSafeName((ReadGraph)graph, (Resource)input));
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)sb.toString());
                    ExternalFilesTab.this.updateButtons(ExternalFilesTab.this.externalFilesExplorer);
                }
            }
        });
    }

    public void setInput(ISessionContext context, Object input) {
        this.externalFilesExplorer.setInput(context, input);
        this.updateButtons(this.externalFilesExplorer);
    }

    private List<Resource> getSelectedResources(GraphExplorerComposite explorer) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        ISelection selection = ((ISelectionProvider)explorer.getAdapter(ISelectionProvider.class)).getSelection();
        if (selection == null) {
            return result;
        }
        IStructuredSelection iss = (IStructuredSelection)selection;
        List selections = iss.toList();
        for (AdaptableHintContext ahc : selections) {
            Resource resource = (Resource)ahc.getAdapter(Resource.class);
            result.add(resource);
        }
        return result;
    }

    protected void updateButtons(GraphExplorerComposite explorer) {
        if (SWTThread.getThreadAccess().currentThreadAccess()) {
            this.runnable.run();
        } else {
            SWTThread.getThreadAccess().asyncExec(this.runnable);
        }
    }
}

