/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.Scale;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.ArrowHeadWidget;
import org.simantics.sysdyn.ui.properties.widgets.DelayMarkWidget;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;

public class DependencyTab
extends AdjustableTab {
    Button none;
    Button plus;
    Button minus;
    Button other;
    Button inside;
    Button outside;
    TrackedText polarityText;
    TrackedText polarityLocationText;
    Scale lineThicknessScale;
    private DelayMarkWidget delayMark;
    private ArrowHeadWidget arrowhead;
    private Group polarityGroup;
    private Group locationGroup;
    private Composite misc;
    private Group lineThicknessGroup;

    public DependencyTab(Object id) {
        super(id);
    }

    protected void createAndAddControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        this.composite = new Composite(body, 0);
        this.polarityGroup = new Group(this.composite, 0);
        this.polarityGroup.setText("Polarity");
        this.none = new Button((Composite)this.polarityGroup, support, 16);
        this.none.setText("None");
        this.none.setSelectionFactory((ReadFactory)new PolarityRadioSelectionFactory(""));
        this.none.addSelectionListener((SelectionListener)new PolaritySelectionListener(context, ""));
        this.plus = new Button((Composite)this.polarityGroup, support, 16);
        this.plus.setText("+");
        this.plus.setSelectionFactory((ReadFactory)new PolarityRadioSelectionFactory("+"));
        this.plus.addSelectionListener((SelectionListener)new PolaritySelectionListener(context, "+"));
        this.minus = new Button((Composite)this.polarityGroup, support, 16);
        this.minus.setText("-");
        this.minus.setSelectionFactory((ReadFactory)new PolarityRadioSelectionFactory("-"));
        this.minus.addSelectionListener((SelectionListener)new PolaritySelectionListener(context, "-"));
        this.other = new Button((Composite)this.polarityGroup, support, 16);
        this.other.setText("other");
        String[] stringArray = new String[4];
        stringArray[1] = "+";
        stringArray[2] = "-";
        stringArray[3] = "";
        this.other.setSelectionFactory((ReadFactory)new OtherPolaritySelectionFactory(stringArray));
        this.polarityText = new TrackedText((Composite)this.polarityGroup, support, 2048);
        this.polarityText.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Sysdyn-1.1/DependencyConnection/polarity"));
        this.polarityText.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/DependencyConnection/polarity"));
        this.locationGroup = new Group(this.composite, 0);
        this.locationGroup.setText("Location");
        this.inside = new Button((Composite)this.locationGroup, support, 16);
        this.inside.setText("Inside");
        this.inside.setSelectionFactory((ReadFactory)new PolarityLocationRadioSelectionFactory("Inside"));
        this.inside.addSelectionListener((SelectionListener)new PolarityLocationSelectionListener(context, "Inside"));
        this.outside = new Button((Composite)this.locationGroup, support, 16);
        this.outside.setText("Outside");
        this.outside.setSelectionFactory((ReadFactory)new PolarityLocationRadioSelectionFactory("Outside"));
        this.outside.addSelectionListener((SelectionListener)new PolarityLocationSelectionListener(context, "Outside"));
        this.misc = new Composite(this.composite, 0);
        this.arrowhead = new ArrowHeadWidget(this.misc, support, 0);
        this.delayMark = new DelayMarkWidget(this.misc, support, 0);
        this.lineThicknessGroup = new Group(this.misc, 0);
        this.lineThicknessGroup.setText("Line thickness:");
        this.lineThicknessScale = new Scale((Composite)this.lineThicknessGroup, support, 256);
        this.lineThicknessScale.getWidget().setMinimum(1);
        this.lineThicknessScale.getWidget().setMaximum(15);
        this.lineThicknessScale.getWidget().setPageIncrement(1);
        this.lineThicknessScale.getWidget().setIncrement(1);
        this.lineThicknessScale.setSelectionFactory((ReadFactory)new LineThicknessRadioSelectionFactory());
        this.lineThicknessScale.addSelectionListener((SelectionListener)new LineThicknessSelectionListener(context, this.lineThicknessScale));
    }

    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(1).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.polarityGroup);
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo((Composite)this.polarityGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.polarityText.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.locationGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.locationGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.misc);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.misc);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)this.arrowhead.getWidget());
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)this.delayMark.getWidget());
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.lineThicknessGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.lineThicknessGroup);
    }

    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.polarityGroup);
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo((Composite)this.polarityGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.polarityText.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.locationGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.locationGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.misc);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.misc);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)this.arrowhead.getWidget());
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)this.delayMark.getWidget());
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.lineThicknessGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.lineThicknessGroup);
    }

    class LineThicknessRadioSelectionFactory
    extends ReadFactoryImpl<Resource, Integer> {
        public Integer perform(ReadGraph graph, Resource dependencyConnection) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            Float width = (Float)graph.getPossibleRelatedValue(dependencyConnection, sr.DependencyConnection_strokeWidth, (Binding)Bindings.FLOAT);
            if (width == null) {
                return Math.round(3.0f);
            }
            return Math.round(width.floatValue() * 10.0f);
        }
    }

    class LineThicknessSelectionListener
    extends SelectionListenerImpl<Resource> {
        Scale scale;
        private int selection;

        public LineThicknessSelectionListener(ISessionContext context, Scale scale) {
            super(context);
            this.scale = scale;
        }

        public void beforeApply() {
            this.selection = this.scale.getWidget().getSelection();
        }

        public void apply(WriteGraph graph, Resource connectionElement) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            float width = (float)this.selection / 10.0f;
            graph.claimLiteral(connectionElement, sr.DependencyConnection_strokeWidth, (Object)Float.valueOf(width));
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified Line thickness for connection " + String.valueOf(graph.getPossibleRelatedValue2(connectionElement, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)) + " to " + width));
        }
    }

    class OtherPolaritySelectionFactory
    extends ReadFactoryImpl<Resource, Boolean> {
        String[] limits;

        public OtherPolaritySelectionFactory(String[] limits) {
            this.limits = limits;
        }

        public Object getIdentity(Object inputContents) {
            return new Pair(inputContents, ((Object)((Object)this)).getClass());
        }

        public Boolean perform(ReadGraph graph, Resource dependencyConnection) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            String polarity = (String)graph.getPossibleRelatedValue(dependencyConnection, sr.DependencyConnection_polarity, (Binding)Bindings.STRING);
            String[] stringArray = this.limits;
            int n = this.limits.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (ObjectUtils.objectEquals((Object)polarity, (Object)s)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    class PolarityLocationRadioSelectionFactory
    extends ReadFactoryImpl<Resource, Boolean> {
        private String location;

        public PolarityLocationRadioSelectionFactory(String location) {
            this.location = location;
        }

        public Object getIdentity(Object inputContents) {
            return new Triple(inputContents, (Object)this.location, ((Object)((Object)this)).getClass());
        }

        public Boolean perform(ReadGraph graph, Resource dependencyConnection) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            String location = (String)graph.getPossibleRelatedValue(dependencyConnection, sr.DependencyConnection_polarityLocation, (Binding)Bindings.STRING);
            if ("Outside".equals(this.location)) {
                return ObjectUtils.objectEquals((Object)this.location, (Object)location);
            }
            if (location == null) {
                return true;
            }
            return ObjectUtils.objectEquals((Object)this.location, (Object)location);
        }
    }

    class PolarityLocationSelectionListener
    extends SelectionListenerImpl<Resource> {
        private String location;

        public PolarityLocationSelectionListener(ISessionContext context, String location) {
            super(context);
            this.location = location;
        }

        public void apply(WriteGraph graph, Resource connectionElement) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            String currentLocation = (String)graph.getPossibleRelatedValue2(connectionElement, sr.DependencyConnection_polarityLocation, (Binding)Bindings.STRING);
            if (currentLocation != null && currentLocation.equals(this.location)) {
                return;
            }
            graph.claimLiteral(connectionElement, sr.DependencyConnection_polarityLocation, (Object)this.location);
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified Location for connection " + String.valueOf(graph.getPossibleRelatedValue2(connectionElement, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)) + " to " + this.location));
        }
    }

    class PolarityRadioSelectionFactory
    extends ReadFactoryImpl<Resource, Boolean> {
        private String polarity;

        public PolarityRadioSelectionFactory(String polarity) {
            this.polarity = polarity;
        }

        public Object getIdentity(Object inputContents) {
            return new Triple(inputContents, (Object)this.polarity, ((Object)((Object)this)).getClass());
        }

        public Boolean perform(ReadGraph graph, Resource dependencyConnection) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            String polarity = (String)graph.getPossibleRelatedValue(dependencyConnection, sr.DependencyConnection_polarity, (Binding)Bindings.STRING);
            if (polarity == null && this.polarity.equals("")) {
                return true;
            }
            return ObjectUtils.objectEquals((Object)polarity, (Object)this.polarity);
        }
    }

    class PolaritySelectionListener
    extends SelectionListenerImpl<Resource> {
        private String polarity;

        public PolaritySelectionListener(ISessionContext context, String polarity) {
            super(context);
            this.polarity = polarity;
        }

        public void apply(WriteGraph graph, Resource connectionElement) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            String currentPolarity = (String)graph.getPossibleRelatedValue2(connectionElement, sr.DependencyConnection_polarity, (Binding)Bindings.STRING);
            if (currentPolarity != null && currentPolarity.equals(this.polarity)) {
                return;
            }
            graph.claimLiteral(connectionElement, sr.DependencyConnection_polarity, (Object)this.polarity.trim());
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified Polarity for connection " + String.valueOf(graph.getPossibleRelatedValue2(connectionElement, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)) + " to " + this.polarity.trim()));
        }
    }
}

