/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.imports;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.DatabaseJob;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.utils.imports.ImportUtilsUI;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class ImportModelHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        FileDialog fd = new FileDialog(shell, 4096);
        fd.setText("Import Model");
        Object path = Activator.getDefault().getPreferenceStore().getString(ImportUtilsUI.IMPORTMODELTPATH);
        if (((String)path).isEmpty() || !new File((String)path).exists()) {
            String execDir = System.getProperty("user.dir");
            String slash = System.getProperty("file.separator");
            path = execDir + slash + "sampleModels";
        }
        fd.setFilterPath((String)path);
        String[] filterExt = new String[]{"*.sysdyn; *.tg", "*.*"};
        fd.setFilterExtensions(filterExt);
        final String selected = fd.open();
        if (selected == null) {
            return null;
        }
        DatabaseJob job = new DatabaseJob("Import model"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Importing Model " + selected, 3);
                IStatus status = null;
                try {
                    try {
                        monitor.worked(1);
                        status = ImportUtilsUI.importModelFile(selected, monitor);
                        monitor.worked(2);
                    }
                    catch (Exception e) {
                        ExceptionUtils.logAndShowError((String)"Model import failed, see exception for details", (Throwable)e);
                        ErrorLogger.defaultLogError((String)"Model import failed, see exception for details", (Throwable)e);
                        IStatus iStatus = Status.OK_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

