/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedElement;
import org.simantics.objmap.annotations.RelatedElements;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.Dependency;
import org.simantics.sysdyn.representation.Entity;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.Input;
import org.simantics.sysdyn.representation.ModuleType;
import org.simantics.sysdyn.representation.ParameterOverride;
import org.simantics.sysdyn.representation.Redeclaration;
import org.simantics.sysdyn.representation.Shadow;
import org.simantics.sysdyn.representation.Variability;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.visitors.IElementVisitorVoid;
import org.simantics.utils.datastructures.Pair;

@GraphType(value="http://www.simantics.org/Sysdyn-1.1/Module")
public class Module
implements IElement {
    @RelatedValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    private String name;
    @RelatedElement(value="http://www.simantics.org/Layer0-1.1/PartOf")
    private Configuration parentConfiguration;
    @RelatedElement(value="http://www.simantics.org/Layer0-1.1/InstanceOf")
    private ModuleType type;
    @RelatedElements(value="http://www.simantics.org/Sysdyn-1.1/Module/redeclaration")
    private List<Redeclaration> redeclarations;
    @RelatedElements(value="http://www.simantics.org/Layer0-1.1/ConsistsOf")
    private List<Entity> consistsOf;

    @Override
    public void accept(IElementVisitorVoid v) {
        v.visit(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getModelicaName() {
        if (this.name == null) {
            return null;
        }
        return this.name.replace(' ', '_');
    }

    public ModuleType getType() {
        return this.type;
    }

    public String getDeclaration() {
        String enumerationRedeclarations = this.getEnumerationRedeclarations();
        Pair<String, String> inputRedeclarations = this.getInputRedeclarations();
        String parameterOverrides = this.getParameterOverrideString();
        StringBuilder redeclarations = new StringBuilder();
        if (!(enumerationRedeclarations.isEmpty() && ((String)inputRedeclarations.first).isEmpty() && parameterOverrides.isEmpty())) {
            redeclarations.append("(");
            redeclarations.append(enumerationRedeclarations);
            String ir = (String)inputRedeclarations.first;
            if (enumerationRedeclarations.isEmpty() && !((String)inputRedeclarations.first).isEmpty()) {
                ir = ((String)inputRedeclarations.first).substring(2);
            }
            redeclarations.append(ir);
            if (!parameterOverrides.isEmpty()) {
                if (redeclarations.length() > 1) {
                    redeclarations.append(", ");
                }
                redeclarations.append(parameterOverrides);
            }
            redeclarations.append(")");
        }
        StringBuilder sb = new StringBuilder();
        if (inputRedeclarations.second != null && !((String)inputRedeclarations.second).isEmpty()) {
            sb.append((String)inputRedeclarations.second);
        }
        sb.append("    ");
        sb.append(this.getType().getModelicaName());
        sb.append(" ");
        sb.append(this.getModelicaName());
        sb.append(redeclarations.toString());
        sb.append(";\n");
        return sb.toString();
    }

    private String getEnumerationRedeclarations() {
        StringBuilder redeclarations = new StringBuilder();
        if (!this.getRedeclarations().isEmpty()) {
            boolean first = true;
            for (Redeclaration rd : this.getRedeclarations()) {
                String redeclaration = rd.getRedeclaration();
                if (redeclaration == null || redeclaration.isEmpty()) continue;
                if (!first) {
                    redeclarations.append(",");
                } else {
                    first = false;
                }
                redeclarations.append(redeclaration);
            }
        }
        return redeclarations.toString();
    }

    private Pair<String, String> getInputRedeclarations() {
        StringBuilder declarations = new StringBuilder();
        StringBuilder references = new StringBuilder();
        for (IElement element : this.parentConfiguration.getElements()) {
            Dependency dependency;
            if (!(element instanceof Dependency) || !(dependency = (Dependency)element).getHead().equals(this)) continue;
            Input reference = (Input)dependency.refersTo();
            Variable outputVariable = (Variable)dependency.getTail();
            if (outputVariable instanceof Shadow) {
                outputVariable = ((Shadow)outputVariable).getOriginal();
            }
            Object name = outputVariable.getModelicaName();
            Module module = (Module)dependency.getHead();
            if (reference == null || reference.getName() == null || reference.getVariability() == null || reference.getVariability().isEmpty()) continue;
            for (IElement e : module.getType().getConfiguration().getElements()) {
                Variable v;
                if (!(e instanceof Variable) || (v = (Variable)e).getName() == null || !outputVariable.getName().equals(v.getName())) continue;
                Object declaration = outputVariable instanceof Input ? ((Input)outputVariable).getDeclaration() : ((IndependentVariable)outputVariable).getDeclaration();
                declaration = ((String)declaration).contains("=") ? ((String)declaration).substring(0, ((String)declaration).indexOf("=") - 1) : ((String)declaration).substring(0, ((String)declaration).length() - 2);
                name = outputVariable.getModelicaName() + "_reference";
                declaration = ((String)declaration).replace(outputVariable.getModelicaName(), (CharSequence)name);
                declaration = (String)declaration + " = " + outputVariable.getModelicaName() + " /* Reference value to avoid name conflicts in module instantiation */ ;\n";
                references.append((String)declaration);
                break;
            }
            declarations.append(", " + reference.getModelicaName() + " = " + (String)name);
        }
        return new Pair((Object)declarations.toString(), (Object)references.toString());
    }

    public Configuration getParentConfiguration() {
        return this.parentConfiguration;
    }

    public List<Redeclaration> getRedeclarations() {
        if (this.redeclarations == null) {
            this.redeclarations = new ArrayList<Redeclaration>();
        }
        return this.redeclarations;
    }

    public String getParameterOverrideString() {
        Object result = "";
        for (ParameterOverride po : this.getParameterOverrides()) {
            IndependentVariable var = po.getVariable();
            if (Variability.CONTINUOUS.equals((Object)Variability.getVariability(var, false, this.parentConfiguration))) continue;
            if (!((String)result).isEmpty()) {
                result = (String)result + ", ";
            }
            result = (String)result + po.getOverride();
        }
        return result;
    }

    public Set<ParameterOverride> getParameterOverrides() {
        HashSet<ParameterOverride> result = new HashSet<ParameterOverride>();
        if (this.consistsOf != null) {
            for (Entity e : this.consistsOf) {
                if (!(e instanceof ParameterOverride)) continue;
                result.add((ParameterOverride)e);
            }
        }
        return result;
    }

    public String getDocumentationDefinition() {
        String enumerationRedeclarations = this.getEnumerationRedeclarations();
        String parameterOverrides = this.getParameterOverrideString();
        StringBuilder result = new StringBuilder();
        String[] erecs = enumerationRedeclarations.split(",");
        boolean first = true;
        result.append("<p>");
        String[] stringArray = erecs;
        int n = erecs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() != 0) {
                if (first) {
                    result.append("<b>Enumeration redeclarations:</b><br/>");
                }
                first = false;
                result.append(s.trim());
                result.append("<br/>");
            }
            ++n2;
        }
        result.append("</p>");
        first = true;
        result.append("<p>");
        String[] poverrds = parameterOverrides.split(",");
        String[] stringArray2 = poverrds;
        int n3 = poverrds.length;
        n = 0;
        while (n < n3) {
            String s = stringArray2[n];
            if (s.length() != 0) {
                if (first) {
                    result.append("<b>Parameter overrides:</b><br/>");
                }
                first = false;
                result.append(s.trim());
                result.append("<br/>");
            }
            ++n;
        }
        result.append("</p>");
        ArrayList<Dependency> inputs = new ArrayList<Dependency>();
        ArrayList<Dependency> outputs = new ArrayList<Dependency>();
        for (IElement e : this.parentConfiguration.getElements()) {
            if (!(e instanceof Dependency)) continue;
            Dependency d = (Dependency)e;
            if (this.equals(d.getHead()) && d.refersTo() != null) {
                inputs.add(d);
                continue;
            }
            if (!this.equals(d.getTail()) || d.refersTo() == null) continue;
            outputs.add(d);
        }
        first = true;
        result.append("<p>");
        for (Dependency d : inputs) {
            if (first) {
                result.append("<b>Inputs:</b><br/>");
            }
            first = false;
            result.append(this.getName() + "." + ((Variable)d.refersTo()).getModelicaName() + " = " + ((Variable)d.getTail()).getModelicaName());
            result.append("<br/>");
        }
        result.append("</p>");
        first = true;
        result.append("<p>");
        for (Dependency d : outputs) {
            if (first) {
                result.append("<b>Outputs:</b><br/>");
            }
            first = false;
            result.append(((Variable)d.getHead()).getModelicaName() + " = " + this.getName() + "." + ((Variable)d.refersTo()).getModelicaName());
            result.append("<br/>");
        }
        result.append("</p>");
        return result.toString();
    }
}

