/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedElements;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.sysdyn.representation.Dependency;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.visitors.IElementVisitorVoid;

@GraphType(value="http://www.simantics.org/Sysdyn-1.1/Input")
public class Input
extends Variable {
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/Input/defaultInputValue")
    private Double defaultInputValue;
    @RelatedElements(value="http://www.simantics.org/Sysdyn-1.1/Variable/isHeadOf")
    private List<IElement> isHeadOf;

    @Override
    public void accept(IElementVisitorVoid v) {
        v.visit(this);
    }

    public String getDefaultInputValue(String inModule) {
        if (this.getArrayIndexes() == null || this.getArrayIndexes().isEmpty()) {
            return this.defaultInputValue.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("fill(");
        sb.append(this.defaultInputValue);
        sb.append(", ");
        Iterator<Enumeration> i = this.getArrayIndexes().iterator();
        while (i.hasNext()) {
            Enumeration e = i.next();
            sb.append((String)(inModule != null && !inModule.isEmpty() ? inModule + "." : "") + e.getModelicaName() + ".size");
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getDefaultInputValue() {
        return this.getDefaultInputValue(null);
    }

    public boolean isHeadOfDependency() {
        return !this.isHeadOf.isEmpty();
    }

    public String getDeclarationWithValue() {
        Object declaration = this.getDeclaration();
        declaration = ((String)declaration).substring(0, ((String)declaration).length() - 2);
        declaration = (String)declaration + " = " + this.getDefaultInputValue() + ";\n";
        return declaration;
    }

    public String getDeclaration() {
        ArrayList<Enumeration> enumerations = this.getArrayIndexes();
        String range = "";
        if (enumerations != null && enumerations.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            Iterator<Enumeration> iterator = enumerations.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next().getModelicaName() + ".size");
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
            range = sb.toString();
        }
        boolean continuous = this.variability == null || this.variability.isEmpty();
        return "    " + (String)(continuous ? "" : this.variability + " ") + this.getType() + " " + this.getModelicaName() + range + ";\n";
    }

    @Override
    public String getDocumentationDefinition(ReadGraph graph) throws DatabaseException {
        String expression = this.getDefaultInputValue() + "   // Default value";
        if (this.isHeadOf.size() > 0 && this.isHeadOf.get(0) instanceof Dependency) {
            Dependency dependency = (Dependency)this.isHeadOf.get(0);
            Module module = (Module)dependency.getTail();
            Variable reference = (Variable)dependency.refersTo();
            if (reference != null && reference.getModelicaName() != null) {
                expression = "<b>Reference:</b><br/>" + module.getName() + "." + reference.getModelicaName() + ";\n";
            }
        }
        return expression + super.getDocumentationDefinition(graph);
    }
}

