/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation;

import java.util.ArrayList;
import java.util.Iterator;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.annotations.RelatedElements;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.Stock;
import org.simantics.sysdyn.representation.Variability;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.expressions.IExpression;
import org.simantics.sysdyn.representation.expressions.ParameterExpression;
import org.simantics.sysdyn.representation.expressions.StockExpression;
import org.simantics.sysdyn.representation.utils.FormatUtils;

public abstract class IndependentVariable
extends Variable {
    @RelatedElements(value="http://www.simantics.org/Sysdyn-1.1/Variable/isHeadOf", composition=true)
    private ArrayList<IElement> isHeadOf = new ArrayList();

    public String getDeclaration() {
        Variability variability = Variability.getVariability(this);
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append((String)(variability.getText().isEmpty() ? "" : variability.getText() + " "));
        sb.append(this.getType() + " ");
        sb.append(this.getModelicaName());
        sb.append(this.getRange());
        if (variability == Variability.PARAMETER || variability == Variability.CONSTANT) {
            String expression = this.getExpressions().get(0).getExpression();
            expression = FormatUtils.replaceWhitespace(expression);
            String equation = FormatUtils.formatExpressionForModelica(this, expression);
            sb.append(" = " + equation);
        }
        sb.append(";\n");
        if (this.getExpressions() != null) {
            for (IExpression e : this.getExpressions()) {
                String addition = e.getDeclarationAddition();
                if (addition == null) continue;
                sb.append(addition);
            }
        }
        return sb.toString();
    }

    public String getRange() {
        ArrayList<Enumeration> enumerations = this.getArrayIndexes();
        String range = "";
        if (enumerations != null && enumerations.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            Iterator<Enumeration> iterator = enumerations.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next().getModelicaName() + ".size");
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
            range = sb.toString();
        }
        return range;
    }

    public String getInitialEquation() {
        StringBuilder sb = new StringBuilder();
        for (IExpression expression : this.getExpressions()) {
            String initialEquation = expression.getInitialEquation();
            if (initialEquation == null) continue;
            sb.append(initialEquation);
        }
        String result = sb.toString();
        return result.length() > 0 ? result : null;
    }

    public String getEquation() {
        if (Variability.getVariability(this) == Variability.CONTINUOUS) {
            return this.getVariableEquation();
        }
        return null;
    }

    protected String getVariableEquation() {
        if (this.expressions == null || this.expressions.isEmpty()) {
            return null;
        }
        ArrayList<IExpression> expressions = this.getExpressions();
        ArrayList<Enumeration> enumerations = this.getArrayIndexes();
        IExpression firstExpression = expressions.get(0);
        if (enumerations == null || enumerations.size() < 1) {
            if (firstExpression == null) {
                return null;
            }
            return firstExpression.getEquation();
        }
        StringBuilder sb = new StringBuilder();
        for (IExpression expression : expressions) {
            sb.append(expression.getEquation());
        }
        return sb.toString();
    }

    public ArrayList<IElement> getIncomingDependencies() {
        return this.isHeadOf;
    }

    @Override
    public String getDocumentationDefinition(ReadGraph graph) throws DatabaseException {
        String declaration = this.getDeclaration();
        String initialEquation = this.getInitialEquation();
        StringBuilder result = new StringBuilder();
        if (declaration != null && declaration.length() > 0 && declaration.contains("=")) {
            result.append("<p>");
            if (this.getExpressions().size() > 1) {
                result.append(this.formatForHTML(declaration));
            }
            if (this instanceof Stock) {
                result.append(this.formatForHTML(declaration.substring(declaration.indexOf("(") + 1, declaration.lastIndexOf(")"))));
            } else {
                result.append(this.formatForHTML(declaration.substring(declaration.indexOf("=") + 1)));
            }
            result.append("</p>");
        }
        result.append("<p>");
        for (IExpression exp : this.getExpressions()) {
            String expression = exp.getDocumentationExpression(graph);
            if (!(exp instanceof StockExpression)) {
                expression = expression.substring(expression.indexOf("=") + 1);
            }
            if (exp instanceof ParameterExpression) continue;
            result.append(this.formatForHTML(expression));
        }
        result.append("</p>");
        if (initialEquation != null && initialEquation.length() > 0) {
            result.append("<p><b>Initial value:</b></p><p>");
            if (this.getExpressions().size() > 1) {
                result.append(this.formatForHTML(initialEquation));
            } else {
                result.append(this.formatForHTML(initialEquation.substring(initialEquation.indexOf("=") + 1)));
            }
            result.append("</p>");
        }
        result.append(super.getDocumentationDefinition(graph));
        return result.toString();
    }

    private String formatForHTML(String text) {
        text = text.trim();
        if ((text = text.replaceAll("\\r\\n|\\r|\\n", "<br/>")).endsWith(";")) {
            text = text.substring(0, text.length() - 1);
        }
        text = text.replace("/* Actual value read from init file */", "");
        return text;
    }
}

