/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelica;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.simantics.sysdyn.representation.Book;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.Dependency;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.Input;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.ModuleType;
import org.simantics.sysdyn.representation.Sheet;
import org.simantics.sysdyn.representation.Stock;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.expressions.DelayExpression;
import org.simantics.sysdyn.representation.expressions.IExpression;

public class ModelicaWriter {
    public static final String VAR_TIME = "time";
    public static final String VAR_START = "startTime";
    public static final String VAR_STOP = "stopTime";
    public static final String VAR_STEP = "timeStep";
    public static final String DELAY_TIME = "delayTime";
    public static final String DELAY_INITIAL = "initialValue";

    static String configurationName(Configuration c) {
        ModuleType moduleType = c.getModuleType();
        if (moduleType == null) {
            return "Model";
        }
        return moduleType.getName();
    }

    public static String write(final Collection<Configuration> _configurations, double startTime, double stopTime, double timeStep, boolean isGame, String omVersion) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>(_configurations);
        Collections.sort(configurations, new Comparator<Configuration>(){

            Configuration findConfiguration(ModuleType type) {
                for (Configuration c : _configurations) {
                    if (!type.equals(c.getModuleType())) continue;
                    return c;
                }
                return null;
            }

            boolean uses(Configuration o1, Configuration o2) {
                ModuleType type = o2.getModuleType();
                if (type == null) {
                    return false;
                }
                for (IElement e : o1.getElements()) {
                    if (!(e instanceof Module)) continue;
                    Module m = (Module)e;
                    if (m.getType().equals(type)) {
                        return true;
                    }
                    Configuration c = this.findConfiguration(m.getType());
                    if (c == null) continue;
                    return this.uses(c, o2);
                }
                return false;
            }

            @Override
            public int compare(Configuration o1, Configuration o2) {
                if (this.uses(o1, o2)) {
                    return 1;
                }
                if (this.uses(o2, o1)) {
                    return -1;
                }
                return ModelicaWriter.configurationName(o1).compareTo(ModelicaWriter.configurationName(o2));
            }
        });
        Configuration modelConf = null;
        for (Configuration conf : configurations) {
            if (conf.getModel() == null) continue;
            modelConf = conf;
        }
        StringBuilder b = new StringBuilder();
        int spreadsheetlocation = b.length();
        String modelName = modelConf.getLabel().replace(" ", "");
        b.append("model " + modelName + "\n");
        b.append("partial class Enumeration_class\n");
        b.append("    parameter Integer size;\n");
        b.append("    parameter Integer elements[:];\n");
        b.append("end Enumeration_class;\n\n");
        ArrayList<String> generated = new ArrayList<String>();
        for (Configuration configuration : configurations) {
            for (IElement element : configuration.getElements()) {
                if (!(element instanceof IndependentVariable)) continue;
                IndependentVariable variable = (IndependentVariable)element;
                for (IExpression expression : variable.getExpressions()) {
                    if (!(expression instanceof DelayExpression)) continue;
                    DelayExpression delay = (DelayExpression)expression;
                    int order = delay.getOrder();
                    int[] dimensions = null;
                    if (expression.getArrayRange() == null) {
                        dimensions = variable.getDimensionArray();
                    }
                    if (generated.contains(ModelicaWriter.getDelayName(order, dimensions))) continue;
                    b.append(ModelicaWriter.getDelayClass(order, dimensions));
                    b.append("\n");
                    generated.add(ModelicaWriter.getDelayName(order, dimensions));
                }
            }
        }
        HashSet<String> sheetNames = new HashSet<String>();
        for (Sheet sheet : ModelicaWriter.getSpreadSheets(configurations)) {
            sheetNames.add(sheet.getModelicaName());
        }
        b.append("// Simulation parameters\n");
        b.append("inner parameter Real ").append(VAR_START).append(" = ").append(startTime).append(";\n");
        b.append("inner parameter Real ").append(VAR_STOP).append(" = ").append(stopTime).append(";\n");
        b.append("inner parameter Real ").append(VAR_STEP).append(" = ").append(timeStep).append(";\n");
        b.append('\n');
        for (Configuration conf : configurations) {
            conf.setIsGameConfiguration(isGame);
            if (conf.equals(modelConf)) continue;
            ModelicaWriter.writeConfiguration(conf, sheetNames, startTime, b);
        }
        modelConf.setIsGameConfiguration(isGame);
        ModelicaWriter.writeConfiguration(modelConf, sheetNames, startTime, b);
        b.append("end " + modelName + ";\n\n");
        if (omVersion != null && omVersion.startsWith("1.9")) {
            b.insert(spreadsheetlocation, ModelicaWriter.getGlobalSpreadSheets(configurations));
        } else {
            b.append(ModelicaWriter.getGlobalSpreadSheets(configurations));
        }
        return b.toString();
    }

    private static List<Sheet> getSpreadSheets(Collection<Configuration> configurations) {
        for (Configuration conf : configurations) {
            if (conf.getModel() == null) continue;
            for (IElement e : conf.getElements()) {
                if (!(e instanceof Book)) continue;
                return ((Book)e).getSheets();
            }
        }
        return Collections.emptyList();
    }

    private static String getGlobalSpreadSheets(Collection<Configuration> configurations) {
        StringBuilder sheets = new StringBuilder();
        for (Configuration conf : configurations) {
            if (conf.getModel() == null) continue;
            for (IElement e : conf.getElements()) {
                if (!(e instanceof Book)) continue;
                return ((Book)e).getBook();
            }
        }
        return sheets.toString();
    }

    private static void writeConfiguration(Configuration configuration, HashSet<String> sheetNames, double startTime, StringBuilder b) {
        String app;
        String className;
        boolean defTime = true;
        ArrayList<IndependentVariable> variables = new ArrayList<IndependentVariable>();
        ArrayList<Input> inputs = new ArrayList<Input>();
        ArrayList<Module> modules = new ArrayList<Module>();
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        ArrayList<Enumeration> enumerations = new ArrayList<Enumeration>();
        ArrayList<Dependency> inputDependencies = new ArrayList<Dependency>();
        ArrayList<Dependency> outputDependencies = new ArrayList<Dependency>();
        HashMap moduleInputs = new HashMap();
        for (IElement element : configuration.getElements()) {
            if (element instanceof IndependentVariable) {
                variables.add((IndependentVariable)element);
                if (!(element instanceof Stock)) continue;
                stocks.add((Stock)element);
                continue;
            }
            if (element instanceof Module) {
                Module m = (Module)element;
                modules.add(m);
                moduleInputs.put(m.getModelicaName(), new ArrayList());
                for (IElement e : m.getType().getConfiguration().getElements()) {
                    if (!(e instanceof Input) || ((Input)e).isHeadOfDependency()) continue;
                    ((ArrayList)moduleInputs.get(m.getModelicaName())).add((Input)e);
                }
                continue;
            }
            if (element instanceof Input) {
                inputs.add((Input)element);
                continue;
            }
            if (element instanceof Enumeration) {
                enumerations.add((Enumeration)element);
                continue;
            }
            if (!(element instanceof Dependency)) continue;
            Dependency dependency = (Dependency)element;
            if (dependency.getHead() instanceof Module) {
                outputDependencies.add(dependency);
                continue;
            }
            if (!(dependency.getTail() instanceof Module)) continue;
            inputDependencies.add(dependency);
        }
        HashMap<Input, String> inputReferences = new HashMap<Input, String>();
        ModelicaWriter.setupInputReferences(inputReferences, inputDependencies);
        ModuleType mt = configuration.getModuleType();
        String string = className = mt != null ? mt.getModelicaName() : null;
        if (className != null) {
            b.append("class " + className + "\n");
        }
        String globalStatus = mt != null ? "outer" : "inner";
        for (String sheetName : sheetNames) {
            b.append("    " + globalStatus + " " + sheetName + "_class " + sheetName + ";\n");
        }
        if (!enumerations.isEmpty()) {
            b.append("// Enumeration definitions\n");
            for (Enumeration e : enumerations) {
                b.append(e.getDeclaration());
            }
        }
        if (mt != null) {
            b.append("// References to simulation parameters\n");
            b.append("    outer Real ").append(VAR_START).append(";\n");
            b.append("    outer Real ").append(VAR_STOP).append(";\n");
            b.append("    outer Real ").append(VAR_STEP).append(";\n");
        }
        b.append("// Variable definitions\n");
        for (IndependentVariable variable : variables) {
            app = variable.getDeclaration();
            if (app == null) continue;
            b.append(app);
        }
        if (defTime && configuration.isGameConfiguration()) {
            if (configuration.getModel() != null) {
                b.append("    parameter Real time = " + startTime + ";\n");
            } else {
                b.append("    Real time;\n");
            }
        }
        if (!modules.isEmpty()) {
            b.append("// Module definitions\n");
            for (Module m : modules) {
                b.append(m.getDeclaration());
            }
        }
        ModelicaWriter.inputDefinitions(b, configuration, inputs, inputReferences);
        boolean initialEquations = false;
        for (Stock stock : stocks) {
            app = stock.getInitialEquation();
            if (app == null) continue;
            if (!initialEquations) {
                initialEquations = true;
                b.append("// Initial Equations\n");
                b.append("initial equation\n");
            }
            b.append(app);
        }
        boolean equation = false;
        b.append("// Equations\n");
        for (IndependentVariable variable : variables) {
            app = variable.getEquation();
            if (app == null) continue;
            if (!equation) {
                b.append("equation\n");
                equation = true;
            }
            b.append(app);
        }
        if (!(equation || inputReferences.isEmpty() && outputDependencies.isEmpty() && moduleInputs.isEmpty() && modules.isEmpty())) {
            b.append("equation\n");
        }
        ModelicaWriter.continuousInputReferences(b, inputReferences);
        b.append("// Outputs\n");
        for (Dependency dependency : outputDependencies) {
            Variable variable = (Variable)dependency.getTail();
            Module module = (Module)dependency.getHead();
            Input reference = (Input)dependency.refersTo();
            if (reference == null || reference.getName() == null || reference.getVariability() != null && !reference.getVariability().isEmpty()) continue;
            b.append("    " + module.getModelicaName() + "." + reference.getModelicaName() + " = " + variable.getModelicaName() + ";\n");
            ((ArrayList)moduleInputs.get(module.getModelicaName())).remove(reference);
        }
        b.append("// Default values for inputs in modules\n");
        for (String moduleLabel : moduleInputs.keySet()) {
            for (Input input : (ArrayList)moduleInputs.get(moduleLabel)) {
                if (input.getVariability() != null && !input.getVariability().isEmpty()) continue;
                b.append("    " + moduleLabel + "." + input.getModelicaName() + " = " + input.getDefaultInputValue(moduleLabel) + ";\n");
            }
        }
        if (defTime && configuration.isGameConfiguration() && !modules.isEmpty()) {
            b.append("// Time values for module\n");
            for (Module m : modules) {
                b.append("    " + m.getModelicaName() + ".time = time;\n");
            }
        }
        if (className != null) {
            b.append("end ").append(className).append(";\n\n");
        }
    }

    private static void continuousInputReferences(StringBuilder b, HashMap<Input, String> inputReferences) {
        b.append("// Inputs\n");
        for (Input i : inputReferences.keySet()) {
            if (i.getVariability() != null && !i.getVariability().isEmpty()) continue;
            b.append("    " + i.getModelicaName() + " = " + inputReferences.get(i));
        }
    }

    private static void setupInputReferences(HashMap<Input, String> inputReferences, ArrayList<Dependency> inputDependencies) {
        for (Dependency dependency : inputDependencies) {
            Input input = (Input)dependency.getHead();
            Module module = (Module)dependency.getTail();
            Variable reference = (Variable)dependency.refersTo();
            String expression = reference != null && reference.getName() != null ? module.getModelicaName() + "." + reference.getModelicaName() + ";\n" : input.getDefaultInputValue() + ";\n";
            inputReferences.put(input, expression);
        }
    }

    private static void inputDefinitions(StringBuilder b, Configuration configuration, ArrayList<Input> inputs, HashMap<Input, String> inputReferences) {
        if (inputs.isEmpty()) {
            return;
        }
        b.append("// Input definitions\n");
        for (Input i : inputs) {
            if (i.getVariability() != null && !i.getVariability().isEmpty()) {
                if (inputReferences.containsKey(i)) {
                    String declaration = i.getDeclaration();
                    declaration = declaration.substring(0, declaration.length() - 2);
                    b.append(declaration + " = " + inputReferences.get(i));
                    continue;
                }
                b.append(i.getDeclarationWithValue());
                continue;
            }
            if (configuration.getModel() != null && !i.isHeadOfDependency()) {
                b.append(i.getDeclarationWithValue());
                continue;
            }
            b.append(i.getDeclaration());
        }
    }

    public String escape(String name) {
        return name.replace(' ', '_');
    }

    private static String getDelayClass(int order, int ... dimensions) {
        boolean array = dimensions != null && dimensions.length > 0;
        StringBuilder buffer = new StringBuilder();
        buffer.append("class ").append(ModelicaWriter.getDelayName(order, dimensions)).append("\n");
        buffer.append('\t').append(ModelicaWriter.getReal("DL", new int[0])).append(";\n");
        buffer.append('\t').append(ModelicaWriter.getReal(DELAY_TIME, new int[0])).append(";\n");
        buffer.append('\t').append(ModelicaWriter.getReal(DELAY_INITIAL, dimensions)).append(";\n");
        buffer.append('\t').append(ModelicaWriter.getReal(ModelicaWriter.getDelayValve(0), dimensions)).append(";\n");
        int i = 1;
        while (i <= order) {
            buffer.append('\t').append(ModelicaWriter.getReal("LV" + i, dimensions)).append(' ').append("(" + (array ? "each " : "") + "fixed=false)").append(";\n");
            buffer.append('\t').append(ModelicaWriter.getReal(ModelicaWriter.getDelayValve(i), dimensions)).append(";\n");
            ++i;
        }
        buffer.append("initial equation\n");
        i = 1;
        while (i <= order) {
            buffer.append('\t').append("LV" + i).append(" = ").append("DL" + (array ? " .* " : " * ") + DELAY_INITIAL).append(";\n");
            ++i;
        }
        buffer.append("equation\n");
        buffer.append('\t').append("DL").append(" = ").append("delayTime / " + order).append(";\n");
        i = 1;
        while (i <= order) {
            buffer.append('\t').append("der(LV" + i + ")").append(" = ").append("-" + ModelicaWriter.getDelayValve(i) + (array ? " .+ " : " + ") + ModelicaWriter.getDelayValve(i - 1)).append(";\n");
            buffer.append('\t').append(ModelicaWriter.getDelayValve(i)).append(" = ").append("LV" + i + (array ? " ./ " : " / ") + "DL").append(";\n");
            ++i;
        }
        buffer.append("end ").append(ModelicaWriter.getDelayName(order, dimensions)).append(";\n");
        return buffer.toString();
    }

    private static String getReal(String name, int ... dims) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Real ").append(name);
        if (dims != null && dims.length > 0) {
            buffer.append('[');
            int i = 0;
            while (i < dims.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(dims[i]);
                ++i;
            }
            buffer.append(']');
        }
        return buffer.toString();
    }

    public static String getDelayName(int order, int ... dims) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("o_").append(order).append('_');
        if (dims != null && dims.length > 0) {
            buffer.append("d_");
            int[] nArray = dims;
            int n = dims.length;
            int n2 = 0;
            while (n2 < n) {
                int dim = nArray[n2];
                buffer.append(dim).append('_');
                ++n2;
            }
        }
        buffer.append("delay");
        return buffer.toString();
    }

    public static String getDelayValve(int order) {
        return "delay" + order;
    }
}

