/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modelica.IModelicaMonitor;
import org.simantics.modelica.ModelicaKeys;
import org.simantics.modelica.data.CSVSimulationResult;
import org.simantics.modelica.data.MatSimulationResult;
import org.simantics.modelica.data.SimulationResult;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.SensitivityExperimentParameter;
import org.simantics.sysdyn.adapter.generator.IGenerator;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.OldSysdynExperiment;
import org.simantics.sysdyn.manager.SaveResultSetJob;
import org.simantics.sysdyn.manager.SysdynResult;

public abstract class SysdynSensitivityAnalysisExperimentBase
extends OldSysdynExperiment {
    protected ArrayList<MemoryResult> results = null;
    protected int numberOfRuns = 0;
    private IGenerator valueGenerator = null;
    protected IProgressMonitor progressMonitor;
    protected int currentRun = 0;
    protected int refreshRate = 1;
    protected List<SensitivityExperimentParameter> parameters = new ArrayList<SensitivityExperimentParameter>();

    public SysdynSensitivityAnalysisExperimentBase(Resource experiment, Resource model, String identifier) {
        super(experiment, model, identifier);
    }

    /*
     * WARNING - void declaration
     */
    protected void findValuesAndRun(List<SensitivityExperimentParameter> parameters, HashMap<String, String> values, HashMap<String, String> experimentParameters) {
        void var6_8;
        ArrayList parameterMaps = new ArrayList();
        int parametersSize = parameters.size();
        try {
            this.session.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                    SysdynSensitivityAnalysisExperimentBase.this.numberOfRuns = (Integer)graph.getPossibleRelatedValue(SysdynSensitivityAnalysisExperimentBase.this.experiment, SR.SensitivityAnalysisExperiment_numberOfValues, (Binding)Bindings.INTEGER);
                    Resource methodResource = graph.getPossibleObject(SysdynSensitivityAnalysisExperimentBase.this.experiment, SR.SensitivityAnalysisExperiment_method);
                    if (methodResource == null) {
                        methodResource = GraphUtils.create2((WriteGraph)graph, (Resource)SR.RandomGenerator, (Object[])new Object[0]);
                        graph.claim(SysdynSensitivityAnalysisExperimentBase.this.experiment, SR.SensitivityAnalysisExperiment_method, methodResource);
                    }
                    SysdynSensitivityAnalysisExperimentBase.this.valueGenerator = (IGenerator)graph.adapt(methodResource, IGenerator.class);
                }
            });
        }
        catch (DatabaseException databaseException) {
            databaseException.printStackTrace();
        }
        this.refreshRate = this.numberOfRuns / 20 + 1;
        this.valueGenerator.initialize();
        boolean bl = false;
        while (var6_8 < this.numberOfRuns) {
            List<Double> randoms = this.valueGenerator.next();
            HashMap<String, String> parameterMap = new HashMap<String, String>(parametersSize);
            int j = 0;
            while (j < parametersSize) {
                SensitivityExperimentParameter p = parameters.get(j);
                double value = p.getDistribution().inverseCDF(randoms.get(j));
                parameterMap.put(p.getFullModelicaName(), Double.toString(value));
                ++j;
            }
            parameterMaps.add(parameterMap);
            ++var6_8;
        }
        for (HashMap hashMap : parameterMaps) {
            values.putAll(hashMap);
            this.runSensitivityRun(values, experimentParameters);
        }
    }

    protected abstract void runSensitivityRun(HashMap<String, String> var1, HashMap<String, String> var2);

    protected void loadConfiguration() {
        try {
            this.session.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                    Integer rRate = (Integer)graph.getPossibleRelatedValue(SysdynSensitivityAnalysisExperimentBase.this.experiment, SR.SensitivityAnalysisExperiment_resultRefreshRate, (Binding)Bindings.INTEGER);
                    if (rRate != null) {
                        SysdynSensitivityAnalysisExperimentBase.this.refreshRate = rRate;
                    }
                    Resource parameterListResource = graph.getPossibleObject(SysdynSensitivityAnalysisExperimentBase.this.experiment, SR.SensitivityAnalysisExperiment_parameterList);
                    List parameterResources = ListUtils.toList((ReadGraph)graph, (Resource)parameterListResource);
                    if (SysdynSensitivityAnalysisExperimentBase.this.parameters != null) {
                        SysdynSensitivityAnalysisExperimentBase.this.parameters.clear();
                        for (Resource p : parameterResources) {
                            SensitivityExperimentParameter parameter = (SensitivityExperimentParameter)graph.adapt(p, SensitivityExperimentParameter.class);
                            if (parameter.getFullName() == null) continue;
                            SysdynSensitivityAnalysisExperimentBase.this.parameters.add(parameter);
                        }
                    }
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    protected Thread getResultThread(final File resFile, final HashMap<String, String> experimentParameters, final IModelicaMonitor monitor, IProgressMonitor progressMonitor, final boolean updateMonitors, final int currentRun) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    SysdynSensitivityAnalysisExperimentBase.this.process.waitFor();
                    if (!SysdynSensitivityAnalysisExperimentBase.this.canceled) {
                        int maxIntervalInt;
                        Double outInterval;
                        Object result = resFile.getName().endsWith(".csv") ? new CSVSimulationResult() : (resFile.getName().endsWith(".plt") ? new SimulationResult() : new MatSimulationResult());
                        String startTime = (String)experimentParameters.get(ModelicaKeys.START_VALUE);
                        String stopTime = (String)experimentParameters.get(ModelicaKeys.STOP_VALUE);
                        String stepTime = (String)experimentParameters.get(ModelicaKeys.STEP_VALUE);
                        Double start = Double.parseDouble(startTime);
                        Double stop = Double.parseDouble(stopTime);
                        Double step = Double.parseDouble(stepTime);
                        int outIntervalInt = 1;
                        String outputInterval = (String)experimentParameters.get(ModelicaKeys.OUTPUT_INTERVAL);
                        if (outputInterval != null && (outIntervalInt = (int)SysdynSensitivityAnalysisExperimentBase.getInterval(outInterval = Double.valueOf(Double.parseDouble(outputInterval)), step)) > (maxIntervalInt = (int)Math.round((stop - start) / step))) {
                            outIntervalInt = maxIntervalInt;
                        }
                        result.initRead(resFile);
                        result.readTime(resFile, outIntervalInt);
                        result.filter();
                        MemoryResult currentResult = new MemoryResult(null, null);
                        SysdynSensitivityAnalysisExperimentBase.this.getCurrentResults().add(currentResult);
                        currentResult.setResult((SimulationResult)result);
                        currentResult.setResultFile(resFile);
                        currentResult.setResultIndex(currentRun);
                        currentResult.setFilter(start, stop, step);
                        if (updateMonitors) {
                            SysdynSensitivityAnalysisExperimentBase.this.resultsChanged();
                        }
                        SysdynSensitivityAnalysisExperimentBase.this.simulate(false);
                        String errorString = result.getResultReadErrors();
                        if (errorString != null && !errorString.isEmpty()) {
                            monitor.message(errorString);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public ArrayList<MemoryResult> getCurrentResults() {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        return this.results;
    }

    @Override
    public Collection<SysdynResult> getActiveResults() {
        ArrayList<SysdynResult> result = new ArrayList<SysdynResult>();
        result.addAll(this.getCurrentResults());
        result.addAll(this.sysdynModel.getDisplayedResults());
        return result;
    }

    @Override
    public MemoryResult getCurrentResult() {
        if (this.results == null || this.results.size() < 1) {
            return null;
        }
        return this.results.get(0);
    }

    @Override
    public void resultsChanged() {
        long time = System.nanoTime();
        this.updateSubscriptions();
        this.previousVariableUpdateTime = time;
    }

    @Override
    public void saveState() {
        if (this.results == null || !(this.results instanceof ArrayList)) {
            return;
        }
        SaveResultSetJob saveResultSetJob = new SaveResultSetJob(this, this.session, this.results);
        saveResultSetJob.schedule();
    }

    @Override
    public int numberOfSimulationRunSteps() {
        try {
            Integer numberOfIterations = (Integer)this.session.syncRequest((Read)new Read<Integer>(){

                public Integer perform(ReadGraph graph) throws DatabaseException {
                    SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                    Integer numberOfIterations = (Integer)graph.getPossibleRelatedValue(SysdynSensitivityAnalysisExperimentBase.this.experiment, SR.SensitivityAnalysisExperiment_numberOfValues, (Binding)Bindings.INTEGER);
                    return numberOfIterations;
                }
            });
            if (numberOfIterations == null) {
                numberOfIterations = 0;
            }
            return 3 + numberOfIterations;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return super.numberOfSimulationRunSteps();
        }
    }
}

