/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.scenegraph.utils.GridUtils;

public class GridNode
extends G2DNode {
    public static final String GRID_NODE_ID = "grid";
    private static final long serialVersionUID = -624916761394994358L;
    protected Boolean enabled = true;
    protected Color gridColor = new Color(0.9f, 0.9f, 0.9f);
    protected double gridSize = 1.0;
    protected ISnapAdvisor snapAdvisor;
    private final transient BasicStroke stroke = new BasicStroke(1.0f);

    @INode.SyncField(value={"enabled"})
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @INode.SyncField(value={"gridColor"})
    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    @INode.SyncField(value={"gridSize"})
    public void setGridSize(double gridSize) {
        if (gridSize < 1.0E-6) {
            gridSize = 1.0E-6;
        }
        this.gridSize = gridSize;
    }

    @INode.SyncField(value={"snapAdvisor"})
    public void setSnapAdvisor(ISnapAdvisor snapAdvisor) {
        this.snapAdvisor = snapAdvisor;
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public ISnapAdvisor getSnapAdvisor() {
        return this.snapAdvisor;
    }

    @Override
    public void render(Graphics2D g2d) {
        Rectangle bounds;
        if (!this.enabled.booleanValue()) {
            return;
        }
        AffineTransform ot = g2d.getTransform();
        double scaleX = Math.abs(ot.getScaleX());
        double scaleY = Math.abs(ot.getScaleY());
        if (scaleX <= 0.0 || scaleY <= 0.0) {
            return;
        }
        double offsetX = ot.getTranslateX();
        double offsetY = ot.getTranslateY();
        g2d.setTransform(new AffineTransform());
        g2d.setStroke(this.stroke);
        if (this.gridColor != null) {
            g2d.setColor(this.gridColor);
        }
        if ((bounds = g2d.getClipBounds()) == null) {
            return;
        }
        double stepX = 50.0;
        double stepY = 50.0;
        stepX = GridUtils.limitedEvenGridSpacing(stepX, scaleX, 100.0, this.gridSize, true);
        stepY = GridUtils.limitedEvenGridSpacing(stepY, scaleY, 100.0, this.gridSize, true);
        while (stepX * scaleX < 50.0) {
            stepX *= 2.0;
        }
        while (stepY * scaleY < 50.0) {
            stepY *= 2.0;
        }
        if (stepX < this.gridSize * 5.0) {
            stepX = this.gridSize * 5.0;
        }
        if (stepY < this.gridSize * 5.0) {
            stepY = this.gridSize * 5.0;
        }
        stepX *= scaleX;
        stepY *= scaleY;
        stepY /= 5.0;
        double x = offsetX % (stepX /= 5.0);
        while (x < bounds.getMaxX()) {
            g2d.drawLine((int)x, (int)bounds.getMinY(), (int)x, (int)bounds.getMaxY());
            x += stepX;
        }
        double y = offsetY % stepY;
        while (y < bounds.getMaxY()) {
            g2d.drawLine((int)bounds.getMinX(), (int)y, (int)bounds.getMaxX(), (int)y);
            y += stepY;
        }
        g2d.setTransform(ot);
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return null;
    }
}

