/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.procedure.primitive;

import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.tuple.Tuples;

public class ByteCaseProcedure
implements ByteProcedure {
    private static final long serialVersionUID = 1L;
    private final MutableList<Pair<BytePredicate, ByteProcedure>> predicateProcedures = Lists.mutable.empty();
    private ByteProcedure defaultProcedure;

    public ByteCaseProcedure() {
    }

    public ByteCaseProcedure(ByteProcedure newDefaultProcedure) {
        this.setDefault(newDefaultProcedure);
    }

    public ByteCaseProcedure addCase(BytePredicate predicate, ByteProcedure procedure) {
        this.predicateProcedures.add(Tuples.pair(predicate, procedure));
        return this;
    }

    public ByteCaseProcedure setDefault(ByteProcedure procedure) {
        this.defaultProcedure = procedure;
        return this;
    }

    @Override
    public void value(byte argument) {
        int localSize = this.predicateProcedures.size();
        for (int i = 0; i < localSize; ++i) {
            Pair pair = (Pair)this.predicateProcedures.get(i);
            if (!((BytePredicate)pair.getOne()).accept(argument)) continue;
            ((ByteProcedure)pair.getTwo()).value(argument);
            return;
        }
        if (this.defaultProcedure != null) {
            this.defaultProcedure.value(argument);
        }
    }

    public String toString() {
        return "new ByteCaseProcedure(" + this.predicateProcedures + ')';
    }
}

